/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.impl;

import com.intel.stl.api.Utils;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.UserNotFoundException;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.subnet.SubnetConnectionException;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.alert.MailNotifier;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.IFabricController;
import com.intel.stl.ui.main.ISubnetManager;
import com.intel.stl.ui.main.view.IFabricView;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.wizards.impl.ConfigTaskStatus;
import com.intel.stl.ui.wizards.impl.ConfigTaskType;
import com.intel.stl.ui.wizards.impl.IMultinetWizardListener;
import com.intel.stl.ui.wizards.impl.IMultinetWizardTask;
import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.impl.WizardType;
import com.intel.stl.ui.wizards.impl.WizardValidationException;
import com.intel.stl.ui.wizards.impl.event.EventWizardController;
import com.intel.stl.ui.wizards.impl.preferences.PreferencesWizardController;
import com.intel.stl.ui.wizards.impl.subnet.SubnetWizardController;
import com.intel.stl.ui.wizards.model.IModelChangeListener;
import com.intel.stl.ui.wizards.model.IWizardModel;
import com.intel.stl.ui.wizards.model.MultinetWizardModel;
import com.intel.stl.ui.wizards.model.event.EventRulesTableModel;
import com.intel.stl.ui.wizards.model.event.EventsModel;
import com.intel.stl.ui.wizards.model.preferences.PreferencesModel;
import com.intel.stl.ui.wizards.model.subnet.SubnetModel;
import com.intel.stl.ui.wizards.view.IMultinetWizardView;
import com.intel.stl.ui.wizards.view.ITaskView;
import com.intel.stl.ui.wizards.view.MultinetWizardView;
import com.intel.stl.ui.wizards.view.WizardViewType;
import com.intel.stl.ui.wizards.view.event.EventWizardView;
import com.intel.stl.ui.wizards.view.preferences.PreferencesWizardView;
import com.intel.stl.ui.wizards.view.subnet.SubnetWizardView;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultinetWizardController
implements IMultinetWizardListener,
IModelChangeListener<IWizardModel> {
    private static final Logger log = LoggerFactory.getLogger(MultinetWizardController.class);
    private final MultinetWizardView view;
    private final ISubnetManager subnetMgr;
    private final List<IMultinetWizardTask> tasks;
    private IWizardTask currentTask;
    private final IWizardTask firstTask;
    private final IWizardTask lastTask;
    private String userName;
    private UserSettings userSettings;
    private IFabricController controller;
    private boolean isFirstRun;
    private final MultinetWizardModel wizardModel;
    private SubnetWizardView subnetView;
    private static MultinetWizardController instance;
    private SubnetWizardController subnetController;
    private EventWizardController eventController;
    private SubnetDescription subnet;
    private boolean workerStatus;
    private ConfigureSubnetTask configTask;

    protected MultinetWizardController(MultinetWizardView view, MultinetWizardModel wizardModel, ISubnetManager subnetMgr) {
        this.view = view;
        this.wizardModel = wizardModel;
        this.subnetMgr = subnetMgr;
        this.isFirstRun = subnetMgr.isFirstRun();
        this.view.setWizardListener(this);
        this.tasks = this.getTasks(subnetMgr);
        this.installTasks(this.tasks);
        this.view.setTasks(this.tasks);
        this.firstTask = this.tasks.get(0);
        this.lastTask = this.tasks.get(this.tasks.size() - 1);
        HelpAction helpAction = this.getHelpAction();
        helpAction.getHelpBroker().enableHelpOnButton((Component)view.getHelpButton(), helpAction.getSetupWizard(), helpAction.getHelpSet());
    }

    public static MultinetWizardController getInstance(IFabricView owner, ISubnetManager subnetMgr) {
        if (instance == null) {
            MultinetWizardView wizardView = new MultinetWizardView(owner);
            MultinetWizardModel wizardModel = new MultinetWizardModel();
            instance = new MultinetWizardController(wizardView, wizardModel, subnetMgr);
        }
        return instance;
    }

    protected List<IMultinetWizardTask> getTasks(ISubnetManager subnetMgr) {
        ArrayList<IMultinetWizardTask> tasks = new ArrayList<IMultinetWizardTask>();
        this.wizardModel.addModelListener(this, WizardType.MULTINET);
        SubnetModel subnetModel = new SubnetModel();
        this.subnetView = new SubnetWizardView(this.view);
        this.subnetController = new SubnetWizardController(this.subnetView, subnetModel, subnetMgr);
        this.subnetView.setWizardListener(this.subnetController);
        this.wizardModel.setSubnetModel(subnetModel);
        tasks.add(this.subnetController);
        this.wizardModel.addModelListener(this.subnetController, WizardType.SUBNET);
        EventRulesTableModel eventRulesTableModel = new EventRulesTableModel();
        EventsModel eventModel = new EventsModel(eventRulesTableModel);
        EventWizardView eventView = new EventWizardView(eventRulesTableModel, this.view);
        this.eventController = new EventWizardController(eventView, eventModel);
        eventView.setWizardListener(this.eventController);
        this.wizardModel.setEventsModel(eventModel);
        tasks.add(this.eventController);
        this.wizardModel.addModelListener(this.eventController, WizardType.EVENT);
        PreferencesModel preferencesModel = new PreferencesModel();
        PreferencesWizardView preferencesView = new PreferencesWizardView(this.view, preferencesModel);
        PreferencesWizardController preferencesController = new PreferencesWizardController(preferencesView, preferencesModel);
        preferencesView.setWizardListener(preferencesController);
        this.wizardModel.setPreferencesModel(preferencesModel);
        tasks.add(preferencesController);
        this.wizardModel.addModelListener(preferencesController, WizardType.PREFERENCES);
        return tasks;
    }

    protected HelpAction getHelpAction() {
        return HelpAction.getInstance();
    }

    protected IWizardTask getTaskByName(String name) {
        boolean found = false;
        IWizardTask currentTask = null;
        Iterator<IMultinetWizardTask> it = this.tasks.iterator();
        while (!found && it.hasNext()) {
            currentTask = it.next();
            found = currentTask.getName().equals(name);
        }
        return currentTask;
    }

    private void installTasks(List<IMultinetWizardTask> tasks) {
        for (IMultinetWizardTask task : tasks) {
            task.setWizardController(this);
        }
    }

    public void setReady(boolean b) {
    }

    public void cleanup() {
        for (IWizardTask iWizardTask : this.tasks) {
            try {
                iWizardTask.cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onPrevious() {
        IWizardTask previousTask = this.tasks.get(this.tasks.indexOf(this.currentTask) - 1);
        this.view.enableNext(true);
        this.view.enablePrevious(true);
        previousTask.onPrevious();
        boolean validTab = this.view.previousTab();
        if (validTab) {
            this.selectStep(previousTask.getName());
            if (this.currentTask != null && this.currentTask.getName().equals(this.firstTask.getName())) {
                this.view.enablePrevious(false);
            }
        }
    }

    @Override
    public boolean onNext() {
        boolean success = false;
        try {
            success = this.currentTask.validateUserEntry();
            this.currentTask.promoteModel(this.wizardModel);
            if (success) {
                this.view.enableNext(true);
                this.view.enablePrevious(true);
                boolean validTab = this.view.nextTab();
                if (validTab) {
                    this.selectStep(this.tasks.get(this.tasks.indexOf(this.currentTask) + 1).getName());
                }
            }
        }
        catch (WizardValidationException e) {
            this.view.showErrorMessage(STLConstants.K0030_ERROR.getValue(), e.getMessage());
        }
        return success;
    }

    @Override
    public void onTab(String tabName) {
        IWizardTask task;
        IWizardTask iWizardTask = task = tabName != null ? this.getTaskByName(tabName) : this.currentTask;
        if (task != null) {
            task.promoteModel(this.wizardModel);
            this.showStep(this.tasks.get(this.tasks.indexOf(task)).getName());
        } else {
            this.view.showErrorMessage(STLConstants.K0030_ERROR.getValue(), STLConstants.K3043_INVALID_WIZARD_TASK.getValue());
        }
    }

    @Override
    public void onFinish() {
        String subnetName = this.view.getSubnetName();
        this.wizardModel.getSubnetModel().getSubnet().setName(subnetName);
        this.configTask = new ConfigureSubnetTask();
        this.configTask.execute();
    }

    @Override
    public void cancelConfiguration() {
        if (this.configTask != null) {
            this.configTask.cancel(true);
        }
    }

    @Override
    public void validateEntry() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean success = false;
                try {
                    success = MultinetWizardController.this.currentTask.validateUserEntry();
                }
                catch (WizardValidationException e) {
                    MultinetWizardController.this.view.showErrorMessage(STLConstants.K0030_ERROR.getValue(), e.getMessage());
                }
                return success;
            }

            @Override
            protected void done() {
                try {
                    MultinetWizardController.this.workerStatus = (Boolean)this.get();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    MultinetWizardController.this.view.showErrorMessage(STLConstants.K0030_ERROR.getValue(), e);
                }
            }
        };
        worker.execute();
    }

    @Override
    public boolean isValidEntry() {
        return this.workerStatus;
    }

    @Override
    public void resetWorkerStatus() {
        this.workerStatus = false;
    }

    @Override
    public void checkHost() {
    }

    @Override
    public void saveConfiguration() {
    }

    @Override
    public void onApply() {
    }

    private boolean updateDatabase() throws Exception {
        boolean result = false;
        boolean success = this.saveSubnet();
        if (success) {
            SubnetDescription subnetDescription = this.subnet;
            String currentSubnetName = null;
            if (subnetDescription != null) {
                currentSubnetName = subnetDescription.getName();
            }
            UserSettings userSettings = this.subnetMgr.getUserSettings(currentSubnetName, this.userName);
            EventRulesTableModel eventRulesTable = this.wizardModel.getEventsModel().getEventsRulesModel();
            userSettings.setEventRules(eventRulesTable.getEventRules());
            PreferencesModel preferencesModel = this.wizardModel.getPreferencesModel();
            userSettings.setPreferences(preferencesModel.getPreferencesMap());
            this.subnetMgr.saveUserSettings(currentSubnetName, userSettings);
            this.view.setNewWizardInProgress(false);
            for (IMultinetWizardTask task : this.tasks) {
                task.setDirty(false);
            }
            result = true;
        }
        return result;
    }

    @Override
    public void onClose() {
        this.view.closeWizard();
        this.isFirstRun = false;
    }

    @Override
    public void selectStep(String taskName) {
        IWizardTask task = this.getTaskByName(taskName);
        if (task != null) {
            this.currentTask = task;
            this.currentTask.init();
        }
        this.view.showTaskView(taskName);
        if (this.lastTask != null && task != null && !task.getName().equals(this.lastTask.getName())) {
            this.view.updateNextButton(STLConstants.K0622_NEXT.getValue());
        }
    }

    @Override
    public void showStep(String taskName) {
        IWizardTask task;
        this.currentTask = task = this.getTaskByName(taskName);
        this.view.showTaskView(taskName);
        if (this.lastTask != null && task != null && !task.getName().equals(this.lastTask.getName())) {
            this.view.updateNextButton(STLConstants.K0622_NEXT.getValue());
        }
    }

    @Override
    public void showView(SubnetDescription subnet, String userName, IFabricController callingController) {
        this.subnet = subnet;
        List<SubnetDescription> subnets = this.subnetMgr.getSubnets();
        if (subnet.getSubnetId() == 0L && subnets.size() > 0) {
            subnet = this.subnetMgr.getSubnets().get(0);
        }
        this.userName = userName;
        IFabricView mainFrame = callingController.getView();
        try {
            this.userSettings = this.subnetMgr.getUserSettings(subnet.getName(), userName);
        }
        catch (UserNotFoundException e) {
            e.printStackTrace();
        }
        if (subnets.size() > 0) {
            this.view.setWizardViewType(WizardViewType.WIZARD);
            this.updateModels(subnet);
        } else {
            this.view.setWizardViewType(WizardViewType.WELCOME);
        }
        this.view.setSubnets(subnets);
        if (subnet.getSubnetId() != 0L) {
            this.view.setSelectedSubnet(subnet);
            this.wizardModel.getSubnetModel().setSubnet(subnet);
        }
        for (IWizardTask iWizardTask : this.tasks) {
            iWizardTask.init();
        }
        this.currentTask = this.tasks.get(0);
        this.view.enablePrevious(false);
        this.view.showWizard(subnet, this.subnetMgr.isFirstRun(), mainFrame);
    }

    @Override
    public IMultinetWizardView getView() {
        return this.view;
    }

    @Override
    public void closeStatusPanels() {
        for (IWizardTask iWizardTask : this.tasks) {
            ((ITaskView)((Object)iWizardTask.getView())).closeStatusPanel();
        }
    }

    @Override
    public UserSettings getUserSettings() {
        return this.userSettings;
    }

    @Override
    public boolean isFirstRun() {
        return this.isFirstRun;
    }

    @Override
    public boolean onRun() {
        boolean result = false;
        String hostName = null;
        String subnetName = this.wizardModel.getSubnetModel().getSubnet().getName();
        try {
            hostName = this.wizardModel.getSubnetModel().getSubnet().getCurrentFE().getHost();
        }
        catch (IllegalArgumentException e) {
            Util.showError(this.view, e);
        }
        if (this.isHostConnectable()) {
            try {
                this.subnetMgr.startSubnet(subnetName);
                result = true;
            }
            catch (SubnetConnectionException e) {
                this.view.showErrorMessage(STLConstants.K0030_ERROR.getValue(), e.getMessage(), STLConstants.K2004_CONNECTION.getValue());
            }
        } else {
            this.view.showErrorMessage(STLConstants.K0030_ERROR.getValue(), UILabels.STL50050_CONNECTION_FAIL.getDescription(subnetName, hostName));
        }
        return result;
    }

    @Override
    public void onReset() {
        for (IWizardTask iWizardTask : this.tasks) {
            iWizardTask.onReset();
        }
        this.view.setDirty(false);
    }

    @Override
    public void onNewSubnet() {
        this.subnet = new SubnetDescription(STLConstants.K3018_UNKNOWN_SUBNET.getValue(), STLConstants.K3018_UNKNOWN_SUBNET.getValue(), SubnetModel.DEFAULT_PORT_NUM);
        this.view.addSubnet(this.subnet);
        this.wizardModel.getSubnetModel().setSubnet(this.subnet);
        this.wizardModel.notifyModelChange(WizardType.SUBNET);
        for (IMultinetWizardTask task : this.tasks) {
            task.clear();
            task.promoteModel(this.wizardModel);
        }
        this.wizardModel.notifyModelChange();
        this.view.setSelectedSubnet(this.subnet);
    }

    @Override
    public void onSelectSubnet(SubnetDescription subnet) {
        this.subnet = subnet;
        this.updateModels(subnet);
        for (IMultinetWizardTask task : this.tasks) {
            task.setDirty(false);
        }
        this.view.setSelectedSubnet(subnet);
    }

    @Override
    public boolean haveUnsavedChanges() {
        if (this.view.isDirty()) {
            return true;
        }
        for (IWizardTask iWizardTask : this.tasks) {
            if (!iWizardTask.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onDelete() {
    }

    @Override
    public void deleteSubnet(SubnetDescription subnet) {
        if (subnet.getSubnetId() != 0L) {
            try {
                this.subnetMgr.removeSubnet(subnet);
            }
            catch (SubnetDataNotFoundException e) {
                this.view.showErrorMessage(STLConstants.K0329_PORT_SUBNET_MANAGER.getValue() + " " + STLConstants.K0030_ERROR.getValue(), e.getMessage());
            }
        }
        for (IMultinetWizardTask task : this.tasks) {
            task.setDirty(false);
        }
    }

    @Override
    public List<SubnetDescription> getSubnets() {
        return this.subnetMgr.getSubnets();
    }

    @Override
    public void onModelChange(IWizardModel m) {
        MultinetWizardModel model = (MultinetWizardModel)m;
        SubnetDescription subnet = model.getSubnetModel().getSubnet();
        this.view.setSelectedSubnet(subnet);
    }

    @Override
    public String getHostIp(String hostName) {
        String ipAddress = null;
        try {
            ipAddress = this.subnetMgr.getHostIp(hostName);
        }
        catch (SubnetConnectionException e) {
            this.view.showErrorMessage(STLConstants.K0030_ERROR.getValue(), e.getMessage());
        }
        return ipAddress;
    }

    @Override
    public boolean isHostReachable() {
        return this.subnetMgr.isHostReachable(this.wizardModel.getSubnetModel().getSubnet().getCurrentFE().getHost());
    }

    @Override
    public boolean isHostConnectable() {
        boolean result = false;
        try {
            result = this.subnetMgr.isHostConnectable(this.wizardModel.getSubnetModel().getSubnet());
        }
        catch (ConfigurationException e) {
            this.view.showErrorMessage(STLConstants.K2004_CONNECTION.getValue() + " " + STLConstants.K0030_ERROR.getValue(), e.getMessage());
        }
        return result;
    }

    @Override
    public boolean tryToConnect() {
        boolean result = false;
        try {
            result = this.subnetMgr.tryToConnect(this.wizardModel.getSubnetModel().getSubnet());
        }
        catch (SubnetConnectionException e) {
            this.view.showErrorMessage(STLConstants.K2004_CONNECTION.getValue() + " " + STLConstants.K0030_ERROR.getValue(), e.getMessage());
        }
        return result;
    }

    @Override
    public boolean tryToConnect(SubnetDescription subnet) throws SubnetConnectionException {
        boolean result = false;
        try {
            result = this.subnetMgr.tryToConnect(subnet);
        }
        catch (SubnetConnectionException e) {
            this.view.showErrorMessage(STLConstants.K2004_CONNECTION.getValue() + " " + STLConstants.K0030_ERROR.getValue(), e.getMessage());
        }
        return result;
    }

    @Override
    public PMConfigBean getPMConfig() {
        PMConfigBean pmConfigBean = null;
        pmConfigBean = this.subnetMgr.getPMConfig(this.wizardModel.getSubnetModel().getSubnet());
        return pmConfigBean;
    }

    @Override
    public TaskScheduler getTaskScheduler() {
        return this.subnetMgr.getTaskScheduler(this.wizardModel.getSubnetModel().getSubnet());
    }

    @Override
    public void saveUserSettings() {
        this.subnetMgr.saveUserSettings(this.wizardModel.getSubnetModel().getSubnet().getName(), this.userSettings);
    }

    @Override
    public SubnetDescription getSubnet() {
        return this.wizardModel.getSubnetModel().getSubnet();
    }

    protected boolean saveSubnet() {
        boolean result = false;
        try {
            SubnetDescription savedSubnet = this.subnetMgr.saveSubnet(this.wizardModel.getSubnetModel().getSubnet());
            this.wizardModel.getSubnetModel().setSubnet(savedSubnet);
            this.subnet = savedSubnet;
            this.view.resetSubnet(savedSubnet);
            result = true;
        }
        catch (SubnetDataNotFoundException e) {
            this.view.showErrorMessage(STLConstants.K2004_CONNECTION.getValue() + " " + STLConstants.K0030_ERROR.getValue(), e.getMessage());
        }
        return result;
    }

    @Override
    public UserSettings retrieveUserSettings() {
        return this.retrieveUserSettings(this.subnet);
    }

    @Override
    public UserSettings retrieveUserSettings(SubnetDescription subnet) {
        UserSettings userSettings = null;
        try {
            userSettings = this.subnetMgr.getUserSettings(subnet.getName(), this.userName);
        }
        catch (UserNotFoundException e) {
            this.view.showErrorMessage(STLConstants.K0030_ERROR.getValue(), e.getMessage());
        }
        return userSettings;
    }

    @Override
    public SubnetDescription getCurrentSubnet() {
        return this.subnet;
    }

    @Override
    public IWizardTask getCurrentTask() {
        return this.currentTask;
    }

    @Override
    public void setCurrentTask(int taskPosition) {
        if (taskPosition >= 0) {
            this.currentTask = this.tasks.get(taskPosition);
        }
    }

    private void updateModels(SubnetDescription subnet) {
        this.wizardModel.getSubnetModel().setSubnet(subnet);
        UserSettings userSettings = this.retrieveUserSettings(subnet);
        List<EventRule> userEventRules = null;
        Map<String, Properties> preferencesMap = null;
        if (userSettings != null) {
            userEventRules = userSettings.getEventRules();
            preferencesMap = userSettings.getPreferences();
        }
        EventRulesTableModel eventRulesTableModel = this.eventController.updateEventRulesTableModel(userEventRules);
        this.wizardModel.getEventsModel().setEventsRulesModel(eventRulesTableModel);
        this.wizardModel.getPreferencesModel().setPreferencesMap(preferencesMap);
        this.wizardModel.notifyModelChange();
    }

    @Override
    public void clearTasks() {
        for (IMultinetWizardTask task : this.tasks) {
            task.clear();
        }
    }

    @Override
    public boolean isNewWizard() {
        return this.view.getNewWizardStatus();
    }

    @Override
    public SubnetWizardView getSubnetView() {
        return this.subnetView;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.view.enableApply(dirty);
        this.view.enableReset(dirty);
    }

    @Override
    public void onEmailTest(String recipients) {
        this.subnetMgr.onEmailTest(recipients);
    }

    @Override
    public boolean isEmailValid(String email) {
        return this.subnetMgr.isEmailValid(email);
    }

    private class ConfigureSubnetTask
    extends SwingWorker<Void, ConfigTaskStatus> {
        private ConfigureSubnetTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            MultinetWizardController.this.view.setWelcomeOkEnabled(false);
            for (IWizardTask task : MultinetWizardController.this.tasks) {
                task.updateModel();
                task.promoteModel(MultinetWizardController.this.wizardModel);
            }
            MultinetWizardController.this.view.setProgress(ConfigTaskType.CHECK_HOST);
            boolean isConnectable = MultinetWizardController.this.isHostConnectable();
            ConfigTaskStatus connectable = new ConfigTaskStatus(ConfigTaskType.CHECK_HOST, isConnectable, null);
            this.publish(connectable);
            MultinetWizardController.this.view.setProgress(ConfigTaskType.VALIDATE_ENTRY);
            int numPass = 0;
            ArrayList<WizardValidationException> errors = new ArrayList<WizardValidationException>();
            boolean status = false;
            for (IWizardTask task : MultinetWizardController.this.tasks) {
                task.setConnectable(isConnectable);
                try {
                    boolean pass = task.validateUserEntry();
                    if (!pass) continue;
                    ++numPass;
                }
                catch (WizardValidationException e) {
                    e.printStackTrace();
                    errors.add(e);
                }
            }
            status = numPass == MultinetWizardController.this.tasks.size();
            MultinetWizardController.this.currentTask.promoteModel(MultinetWizardController.this.wizardModel);
            ConfigTaskStatus valid = new ConfigTaskStatus(ConfigTaskType.VALIDATE_ENTRY, status, errors);
            this.publish(valid);
            try {
                MultinetWizardController.this.view.setProgress(ConfigTaskType.UPDATE_DATABASE);
                ConfigTaskStatus updated = new ConfigTaskStatus(ConfigTaskType.UPDATE_DATABASE, MultinetWizardController.this.updateDatabase(), null);
                this.publish(updated);
            }
            catch (Exception e) {
                this.publish(new ConfigTaskStatus(ConfigTaskType.UPDATE_DATABASE, false, null));
            }
            return null;
        }

        @Override
        protected void process(List<ConfigTaskStatus> statusList) {
            for (ConfigTaskStatus status : statusList) {
                MultinetWizardController.this.view.updateConfigStatus(status);
            }
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                log.error("Validation Error", (Throwable)e);
            }
            SubnetDescription subnet = MultinetWizardController.this.getCurrentSubnet();
            Context context = MultinetWizardController.this.subnetMgr.getContext(subnet);
            if (context != null) {
                MailNotifier mailNotifier = (MailNotifier)context.getEmailNotifier();
                EventRulesTableModel eventModel = MultinetWizardController.this.wizardModel.getEventsModel().getEventsRulesModel();
                List<EventRule> rulesList = eventModel.getEventRules();
                mailNotifier.setEventRules(rulesList);
                String recipients = MultinetWizardController.this.wizardModel.getPreferencesModel().getMailRecipients();
                List<String> recipientsList = Utils.concatenatedStringToList(recipients, ";");
                mailNotifier.setRecipients(recipientsList);
            }
            for (IMultinetWizardTask task : MultinetWizardController.this.tasks) {
                task.setDirty(false);
            }
            MultinetWizardController.this.view.setDirty(false);
            MultinetWizardController.this.view.enableNavPanel(true);
            MultinetWizardController.this.view.enableSubnetModifiers(true);
            MultinetWizardController.this.view.setWelcomeOkEnabled(true);
        }
    }
}

