/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.impl.preferences;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Validator;
import com.intel.stl.ui.wizards.impl.preferences.PreferencesValidatorError;
import com.intel.stl.ui.wizards.model.preferences.PreferencesModel;
import java.util.concurrent.TimeUnit;

public class PreferencesInputValidator {
    private final int OK = PreferencesValidatorError.OK.getId();
    private final int MAX_REFRESH_RATE = 1800;
    private final int MIN_TIMING_WINDOW = 1;
    private final int MAX_TIMING_WINDOW = 9999;
    private final int MIN_NUM_WORST_NODES = 10;
    private final int MAX_NUM_WORST_NODES = 100;
    private static PreferencesInputValidator instance = null;

    private PreferencesInputValidator() {
    }

    public static synchronized PreferencesInputValidator getInstance() {
        if (instance == null) {
            instance = new PreferencesInputValidator();
        }
        return instance;
    }

    public int validate(PreferencesModel preferencesModel, int sweepInterval) {
        int errorCode = this.OK;
        errorCode = this.validateRefreshRateUnits(preferencesModel);
        if (errorCode == this.OK && (errorCode = this.validateRefreshRate(preferencesModel, sweepInterval)) == this.OK && (errorCode = this.validateTimingWindow(preferencesModel)) == this.OK) {
            errorCode = this.validateNumWorstNodes(preferencesModel);
        }
        return errorCode;
    }

    protected int validateRefreshRate(PreferencesModel preferencesModel, int sweepInterval) {
        int errorCode = this.OK;
        try {
            int refreshRate = Integer.valueOf(preferencesModel.getRefreshRate());
            String str = preferencesModel.getRefreshRateUnits().toUpperCase();
            TimeUnit unit = TimeUnit.valueOf(str);
            int refreshRateInSeconds = (int)TimeUnit.SECONDS.convert(refreshRate, unit);
            if (!Validator.integerInRange(refreshRateInSeconds, sweepInterval, 1800)) {
                PreferencesValidatorError error = PreferencesValidatorError.REFRESH_RATE_OUT_OF_RANGE;
                error.setData(new Object[]{sweepInterval, 1800});
                errorCode = error.getId();
            } else if (refreshRateInSeconds < sweepInterval) {
                PreferencesValidatorError error = PreferencesValidatorError.REFRESH_RATE_THRESHOLD_ERROR;
                error.setData(new Object[]{sweepInterval});
                errorCode = error.getId();
            }
        }
        catch (NumberFormatException e) {
            errorCode = PreferencesValidatorError.REFRESH_RATE_FORMAT_EXCEPTION.getId();
        }
        catch (Exception e) {
            errorCode = PreferencesValidatorError.UNKNOWN_ERROR.getId();
        }
        if (Validator.isBlankOrNull(preferencesModel.getRefreshRate())) {
            errorCode = PreferencesValidatorError.REFRESH_RATE_MISSING.getId();
        }
        return errorCode;
    }

    protected int validateRefreshRateUnits(PreferencesModel preferencesModel) {
        int errorCode = this.OK;
        try {
            if (Validator.isBlankOrNull(preferencesModel.getRefreshRateUnits())) {
                errorCode = PreferencesValidatorError.REFRESH_RATE_UNITS_MISSING.getId();
            } else {
                String str = preferencesModel.getRefreshRateUnits().toUpperCase();
                int refreshRateUnits = TimeUnit.valueOf(str).ordinal();
                if (refreshRateUnits != TimeUnit.SECONDS.ordinal() && refreshRateUnits != TimeUnit.MINUTES.ordinal()) {
                    errorCode = PreferencesValidatorError.REFRESH_RATE_UNITS_OUT_OF_RANGE.getId();
                }
            }
        }
        catch (NumberFormatException e) {
            errorCode = PreferencesValidatorError.REFRESH_RATE_UNITS_FORMAT_EXCEPTION.getId();
        }
        catch (Exception e) {
            errorCode = PreferencesValidatorError.UNKNOWN_ERROR.getId();
        }
        return errorCode;
    }

    protected int validateTimingWindow(PreferencesModel preferencesModel) {
        int errorCode = this.OK;
        try {
            if (Validator.isBlankOrNull(preferencesModel.getTimingWindowInSeconds())) {
                errorCode = PreferencesValidatorError.TIMING_WINDOW_MISSING.getId();
            } else {
                int timingWindow = Integer.parseInt(preferencesModel.getTimingWindowInSeconds());
                if (!(Integer.valueOf(timingWindow) instanceof Integer)) {
                    errorCode = PreferencesValidatorError.TIMING_WINDOW_INVALID_TYPE.getId();
                } else if (!Validator.integerInRange(timingWindow, 1, 9999)) {
                    PreferencesValidatorError error = PreferencesValidatorError.TIMING_WINDOW_OUT_OF_RANGE;
                    error.setData(new Object[]{1, 9999});
                    errorCode = error.getId();
                }
            }
        }
        catch (NumberFormatException e) {
            errorCode = PreferencesValidatorError.TIMING_WINDOW_FORMAT_EXCEPTION.getId();
        }
        catch (Exception e) {
            errorCode = PreferencesValidatorError.UNKNOWN_ERROR.getId();
        }
        return errorCode;
    }

    protected int validateNumWorstNodes(PreferencesModel preferencesModel) {
        int errorCode = this.OK;
        try {
            if (Validator.isBlankOrNull(preferencesModel.getNumWorstNodes())) {
                errorCode = PreferencesValidatorError.NUM_WORST_NODES_MISSING.getId();
            } else {
                int numWorstNodes = Integer.parseInt(preferencesModel.getNumWorstNodes());
                if (!(Integer.valueOf(numWorstNodes) instanceof Integer)) {
                    errorCode = PreferencesValidatorError.NUM_WORST_NODES_INVALID_TYPE.getId();
                } else if (!Validator.integerInRange(numWorstNodes, 10, 100)) {
                    PreferencesValidatorError error = PreferencesValidatorError.NUM_WORST_NODES_OUT_OF_RANGE;
                    error.setData(new Object[]{10, 100});
                    errorCode = error.getId();
                }
            }
        }
        catch (NumberFormatException e) {
            errorCode = PreferencesValidatorError.NUM_WORST_NODES_FORMAT_EXCEPTION.getId();
        }
        catch (Exception e) {
            errorCode = PreferencesValidatorError.UNKNOWN_ERROR.getId();
        }
        return errorCode;
    }

    public static String getTimeUnitString(TimeUnit unit) {
        if (unit == TimeUnit.SECONDS) {
            return STLConstants.K0012_SECONDS.getValue();
        }
        if (unit == TimeUnit.MINUTES) {
            return STLConstants.K0011_MINUTES.getValue();
        }
        throw new RuntimeException("Unsupported time unit " + (Object)((Object)unit));
    }

    public static TimeUnit getTimeUnit(String str) {
        if (str.equals(STLConstants.K0012_SECONDS.getValue())) {
            return TimeUnit.SECONDS;
        }
        if (str.equals(STLConstants.K0011_MINUTES.getValue())) {
            return TimeUnit.MINUTES;
        }
        throw new RuntimeException("Unknown time unit string '" + str + "'");
    }

    public static TimeUnit getTimeUnit(int value) {
        if (value == TimeUnit.SECONDS.ordinal()) {
            return TimeUnit.SECONDS;
        }
        if (value == TimeUnit.MINUTES.ordinal()) {
            return TimeUnit.MINUTES;
        }
        throw new RuntimeException("Unknown time unit value '" + value + "'");
    }

    public static int getTimeUnitNumber(String str) {
        String seconds = STLConstants.K0012_SECONDS.getValue();
        String minutes = STLConstants.K0011_MINUTES.getValue();
        if (str.equals(seconds.toUpperCase())) {
            return TimeUnit.SECONDS.ordinal();
        }
        if (str.equals(minutes.toUpperCase())) {
            return TimeUnit.MINUTES.ordinal();
        }
        throw new RuntimeException("Unknown time unit string '" + str + "'");
    }

    public static String getTimeUnitString(int value) {
        if (value == TimeUnit.SECONDS.ordinal()) {
            return TimeUnit.SECONDS.name();
        }
        if (value == TimeUnit.MINUTES.ordinal()) {
            return TimeUnit.MINUTES.name();
        }
        throw new RuntimeException("Unknown time unit value '" + value + "'");
    }

    public int getMaxTimingLimit() {
        return 9999;
    }

    public int getMinNumWorstNode() {
        return 10;
    }

    public int getMaxNumWorstNode() {
        return 100;
    }
}

