/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view;

import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.impl.InteractionType;
import com.intel.stl.ui.wizards.view.ITaskView;
import com.intel.stl.ui.wizards.view.MultinetWizardView;
import com.intel.stl.ui.wizards.view.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskView
extends JPanel
implements ITaskView {
    private static final long serialVersionUID = 3149874617834752585L;
    private static Logger log = LoggerFactory.getLogger(AbstractTaskView.class);
    private StatusPanel statusPanel;

    public AbstractTaskView() {
    }

    public AbstractTaskView(String title) {
        this.initComponents(title);
    }

    protected void initComponents(String title) {
        this.setOpaque(true);
        this.setBackground(MultinetWizardView.WIZARD_COLOR);
        this.setLayout(new BorderLayout());
        this.statusPanel = new StatusPanel();
        this.statusPanel.getContentPane().setBackground(MultinetWizardView.WIZARD_COLOR);
        JComponent optionComp = this.getOptionComponent();
        this.add((Component)optionComp, "Center");
    }

    protected abstract JComponent getOptionComponent();

    public void setWizardListener(IWizardTask listener) {
        this.statusPanel.setWizardTaskController(listener);
    }

    @Override
    public void openStatusPanel() {
        this.statusPanel.openStatusPanel();
    }

    @Override
    public void closeStatusPanel() {
        this.statusPanel.closeStatusPanel();
    }

    @Override
    public void toggleStatusPanel() {
        this.statusPanel.toggleStatusPanel();
    }

    @Override
    public void showMessage(String message, InteractionType action, int messageType, Object ... data) {
        this.statusPanel.showMessage(message, action, messageType, data);
    }

    @Override
    public void logMessage(String message) {
        log.error(message);
    }
}

