/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view.event;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ButtonPopup;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.model.EventRuleActionViz;
import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.model.event.EventRulesTableModel;
import com.intel.stl.ui.wizards.view.IWizardView;
import com.intel.stl.ui.wizards.view.MultinetWizardView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.JXList;

public class ActionPanel
extends JPanel {
    private static final long serialVersionUID = -2996609094010046773L;
    private JButton btnAction;
    private PopupPanel popupPanel;
    private ButtonPopup popup;
    private final List<JCheckBox> cbActionList = new ArrayList<JCheckBox>();
    private List<EventRule> eventRules;
    private final EventRulesTableModel tableModel;
    private int activeRow = -1;
    private int popupCount;
    private final IWizardView wizardViewListener;
    private IWizardTask eventWizardControlListener;

    public ActionPanel(EventRulesTableModel model, IWizardView wizardViewListener) {
        this.tableModel = model;
        this.wizardViewListener = wizardViewListener;
        this.initComponents();
    }

    protected void initComponents() {
        JPanel mainPanel = new JPanel();
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.btnAction = ComponentFactory.getIntelActionButton(STLConstants.K3004_SELECT.getValue());
        this.btnAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ActionPanel.this.popup.isVisible()) {
                    ActionPanel.this.popup.hide();
                } else {
                    ActionPanel.this.wizardViewListener.enableApply(true);
                    ActionPanel.this.popup.show();
                }
            }
        });
        toolBar.add(this.btnAction);
        mainPanel.add(toolBar);
        this.popupPanel = new PopupPanel();
        this.popup = new ButtonPopup(this.btnAction, this.popupPanel, false){

            @Override
            public void onShow() {
                if (ActionPanel.this.activeRow == -1) {
                    return;
                }
                ActionPanel.this.popupCount += 1;
                List<EventRuleAction> actionList = ((EventRule)ActionPanel.this.tableModel.getEntry(ActionPanel.this.activeRow)).getEventActions();
                for (int i = 0; i < ActionPanel.this.cbActionList.size(); ++i) {
                    ((JCheckBox)ActionPanel.this.cbActionList.get(i)).setSelected(false);
                }
                Iterator it = ActionPanel.this.cbActionList.iterator();
                for (EventRuleAction action : actionList) {
                    EventRuleActionViz actViz = EventRuleActionViz.getEventRuleActionVizFor(action);
                    boolean found = false;
                    while (actViz != null && it.hasNext() && !found) {
                        JCheckBox chkbox = (JCheckBox)it.next();
                        found = actViz.getName().equals(chkbox.getText());
                        chkbox.setSelected(found);
                    }
                }
            }

            @Override
            public void onHide() {
                ActionPanel.this.popupCount -= 1;
                ActionPanel.this.updateModel(ActionPanel.this.activeRow, 3);
            }
        };
    }

    public void updateModel(int row, int column) {
        this.popupPanel.updateModel(row, column);
    }

    public JButton getActionButton() {
        return this.btnAction;
    }

    public void setActiveRow(int activeRow) {
        this.activeRow = activeRow;
    }

    public boolean isReady() {
        return this.popupCount == 0;
    }

    public void setEventWizardControlListener(IWizardTask eventWizardControlListener) {
        this.eventWizardControlListener = eventWizardControlListener;
    }

    class PopupPanel
    extends JPanel
    implements ListCellRenderer<JCheckBox> {
        private static final long serialVersionUID = 5009991107568106318L;
        private DefaultListModel<JCheckBox> listModel;
        private JXList list;

        public PopupPanel() {
            this.initPopupPanel();
        }

        protected void initPopupPanel() {
            this.setLayout(new BoxLayout(this, 3));
            this.listModel = new DefaultListModel();
            this.list = new JXList(this.listModel);
            this.list.setVisibleRowCount(10);
            this.list.setCellRenderer((ListCellRenderer)this);
            JPanel pnlActionList = new JPanel();
            pnlActionList.setLayout(new BoxLayout(pnlActionList, 3));
            for (EventRuleActionViz action : EventRuleActionViz.values()) {
                JCheckBox chkBox = ComponentFactory.getIntelCheckBox(action.getName());
                chkBox.setName(action.getWidgetName().name());
                ActionPanel.this.cbActionList.add(chkBox);
                chkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ActionPanel.this.eventWizardControlListener.setDirty(true);
                    }
                });
                this.listModel.addElement(chkBox);
                pnlActionList.add(chkBox);
            }
            JScrollPane scroll = new JScrollPane(pnlActionList);
            scroll.getViewport().getView().setBackground(MultinetWizardView.WIZARD_COLOR);
            this.add((Component)scroll, "Center");
        }

        protected void updateModel(final int row, int column) {
            Runnable updater = new Runnable(){

                @Override
                public void run() {
                    ActionPanel.this.eventRules = ActionPanel.this.tableModel.getEventRules();
                    ArrayList<EventRuleAction> actions = new ArrayList<EventRuleAction>();
                    for (int i = 0; i < ActionPanel.this.cbActionList.size(); ++i) {
                        if (!((JCheckBox)ActionPanel.this.cbActionList.get(i)).isSelected()) continue;
                        actions.add(EventRuleAction.values()[i]);
                    }
                    ((EventRule)ActionPanel.this.eventRules.get(row)).getEventActions().clear();
                    ((EventRule)ActionPanel.this.eventRules.get(row)).setEventActions(actions);
                    ActionPanel.this.tableModel.updateTable(ActionPanel.this.eventRules);
                }
            };
            Util.runInEDT(updater);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            return (Component)ActionPanel.this.cbActionList.get(index);
        }
    }
}

