/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view.event;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.FVHeaderRenderer;
import com.intel.stl.ui.common.view.FVTableRenderer;
import com.intel.stl.ui.common.view.FVXTableView;
import com.intel.stl.ui.model.EventRuleActionViz;
import com.intel.stl.ui.model.EventTypeViz;
import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.impl.event.EventRulesTableColumns;
import com.intel.stl.ui.wizards.model.event.EventRulesTableModel;
import com.intel.stl.ui.wizards.view.IMultinetWizardView;
import com.intel.stl.ui.wizards.view.IWizardView;
import com.intel.stl.ui.wizards.view.MultinetWizardView;
import com.intel.stl.ui.wizards.view.event.ActionPanel;
import com.intel.stl.ui.wizards.view.event.EventActionEditor;
import com.intel.stl.ui.wizards.view.event.EventSeverityEditor;
import com.intel.stl.ui.wizards.view.event.ITableListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class EventTableView
extends FVXTableView<EventRulesTableModel> {
    private static final long serialVersionUID = 2521825791205609777L;
    private static final boolean ACTION_COLUMN_ENABLE = true;
    private IWizardTask eventWizardControlListener;
    private JComboBox<String> cboxEventSeverity;
    private ActionPanel pnlEventAction;
    private IWizardView wizardViewListener = null;
    private IMultinetWizardView multinetWizardViewListener = null;
    private boolean dirty;

    public EventTableView(EventRulesTableModel model, IWizardView wizardViewListener) {
        super(model);
        this.wizardViewListener = wizardViewListener;
        this.installEditors();
    }

    public EventTableView(EventRulesTableModel model, IMultinetWizardView wizardViewListener) {
        super(model);
        this.multinetWizardViewListener = wizardViewListener;
        this.installEditors();
    }

    @Override
    protected JXTable createTable(final EventRulesTableModel model) {
        final JXTable table = new JXTable((TableModel)model);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                model.setSelectedRow(table.getSelectedRow());
            }
        });
        table.setRowHeight(22);
        table.setHorizontalScrollEnabled(true);
        table.setAutoscrolls(true);
        table.setFillsViewportHeight(true);
        table.setPreferredScrollableViewportSize(this.getMaximumSize());
        table.setAutoCreateColumnsFromModel(true);
        table.setAlignmentX(0.0f);
        table.setBackground(MultinetWizardView.WIZARD_COLOR);
        table.setVisibleRowCount(15);
        table.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.INTEL_WHITE, (Color)UIConstants.INTEL_TABLE_ROW_GRAY)});
        table.getTableHeader().setReorderingAllowed(false);
        table.setSortable(false);
        table.setColumnControlVisible(false);
        return table;
    }

    protected void installEditors() {
        this.cboxEventSeverity = new JComboBox<String>(new String[]{NoticeSeverity.INFO.name(), NoticeSeverity.WARNING.name(), NoticeSeverity.ERROR.name(), NoticeSeverity.CRITICAL.name()});
        this.cboxEventSeverity.setName(WidgetName.SW_E_SEVERITY_OPTION.name());
        this.cboxEventSeverity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventTableView.this.dirty = true;
                    EventTableView.this.eventWizardControlListener.setDone(false);
                    EventTableView.this.multinetWizardViewListener.enableApply(true);
                    EventTableView.this.multinetWizardViewListener.enableReset(true);
                }
            }
        });
        EventSeverityEditor serverityEditor = new EventSeverityEditor(this.cboxEventSeverity, (ITableListener)((Object)this.model));
        this.mTable.getColumn(2).setCellEditor(serverityEditor);
        this.pnlEventAction = new ActionPanel((EventRulesTableModel)this.model, this.multinetWizardViewListener);
        EventActionEditor actionEditor = new EventActionEditor(this.pnlEventAction);
        this.mTable.getColumn(3).setCellEditor(actionEditor);
    }

    @Override
    public void formatTable() {
        FVHeaderRenderer headerRenderer = new FVHeaderRenderer(this.mTable);
        this.mHeader = (JXTableHeader)this.mTable.getTableHeader();
        this.mHeader.setFont(UIConstants.H3_FONT);
        Comparator<Number> numberComparator = new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                return Double.compare(o1.doubleValue(), o2.doubleValue());
            }
        };
        FVTableRenderer tableRenderer = new FVTableRenderer(){
            private static final long serialVersionUID = 2677707405000074070L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
                if (value == null) {
                    ((JLabel)cell).setText(STLConstants.K0383_NA.getValue());
                }
                if (isSelected) {
                    cell.setFont(UIConstants.H5_FONT.deriveFont(1));
                    cell.setForeground(UIConstants.INTEL_WHITE);
                    cell.setBackground(UIConstants.INTEL_MEDIUM_BLUE);
                } else {
                    cell.setFont(UIConstants.H5_FONT);
                    cell.setForeground(UIConstants.INTEL_DARK_GRAY);
                    if (row % 2 == 0) {
                        cell.setBackground(UIConstants.INTEL_WHITE);
                    } else {
                        cell.setBackground(UIConstants.INTEL_TABLE_ROW_GRAY);
                    }
                }
                String cellText = ((JLabel)cell).getText();
                if (column == EventRulesTableColumns.EVENT_CLASS.getId()) {
                    ((JLabel)cell).setToolTipText(cellText);
                } else if (column == EventRulesTableColumns.EVENT_TYPE.getId()) {
                    ((JLabel)cell).setToolTipText(EventTypeViz.getEventTypeDescription(cellText));
                } else {
                    ((JLabel)cell).setToolTipText(null);
                }
                return cell;
            }
        };
        ActionListRenderer actionRenderer = new ActionListRenderer();
        this.mTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.FALSE);
        for (int i = 0; i < this.mTable.getColumnCount(); ++i) {
            this.mTable.getColumnModel().getColumn(i).setHeaderRenderer(headerRenderer);
            TableColumnExt col = this.mTable.getColumnExt(i);
            col.setComparator((Comparator)numberComparator);
            if (i == EventRulesTableColumns.EVENT_ACTION.getId()) {
                this.mTable.getColumnModel().getColumn(i).setCellRenderer(actionRenderer);
                continue;
            }
            this.mTable.setDefaultRenderer(Object.class, (TableCellRenderer)tableRenderer);
        }
        this.mTable.packTable(2);
    }

    public void setWizardListener(IWizardTask listener) {
        this.eventWizardControlListener = listener;
        this.pnlEventAction.setEventWizardControlListener(listener);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    class ActionListRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1294872510853521883L;
        private final JPanel actionPanel;
        private Rectangle desiredBound;

        public ActionListRenderer() {
            super(new BorderLayout());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.actionPanel = new JPanel(new FlowLayout(3, 3, 0));
            this.actionPanel.setOpaque(false);
            this.add((Component)this.actionPanel, "West");
            JLabel label = new JLabel(STLConstants.K3004_SELECT.getValue());
            label.setFont(UIConstants.H6_FONT);
            label.setForeground(UIConstants.INTEL_BLUE);
            label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIConstants.INTEL_BLUE));
            label.setToolTipText(STLConstants.K3000_SELECT_ACTIONS.getValue());
            this.add((Component)label, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            EventRule tableEntry = (EventRule)((EventRulesTableModel)EventTableView.this.model).getEntry(row);
            this.actionPanel.removeAll();
            for (EventRuleAction action : tableEntry.getEventActions()) {
                EventRuleActionViz actionViz = EventRuleActionViz.getEventRuleActionVizFor(action);
                if (actionViz == null) continue;
                JLabel label = new JLabel(actionViz.getImageIcon());
                label.setToolTipText(actionViz.getName());
                this.actionPanel.add(label);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.desiredBound = table.getCellRect(row, column, false);
            return this;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            this.setBounds(this.desiredBound);
            this.validate();
            this.doLayout();
            JComponent comp = (JComponent)this.getComponentAt(event.getPoint());
            if (comp != null) {
                if (comp instanceof JLabel) {
                    return comp.getToolTipText();
                }
                Point p = SwingUtilities.convertPoint(this, event.getX(), event.getY(), this.actionPanel);
                this.actionPanel.validate();
                this.actionPanel.doLayout();
                comp = (JComponent)this.actionPanel.getComponentAt(p);
                if (comp != null) {
                    return comp.getToolTipText();
                }
            }
            return super.getToolTipText(event);
        }
    }
}

