/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view.event;

import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.impl.event.IEventControl;
import com.intel.stl.ui.wizards.model.MultinetWizardModel;
import com.intel.stl.ui.wizards.model.event.EventRulesTableModel;
import com.intel.stl.ui.wizards.view.AbstractTaskView;
import com.intel.stl.ui.wizards.view.IMultinetWizardView;
import com.intel.stl.ui.wizards.view.IWizardView;
import com.intel.stl.ui.wizards.view.event.EventTableView;
import javax.swing.JComponent;

public class EventWizardView
extends AbstractTaskView {
    private static final long serialVersionUID = 5308404765504020477L;
    private EventTableView tableView;
    private EventRulesTableModel model;
    private IWizardView wizardViewListener = null;
    private IMultinetWizardView multinetWizardViewListener = null;
    private IEventControl eventControlListener;

    public EventWizardView(EventRulesTableModel model, IWizardView wizardViewListener) {
        this.model = model;
        this.wizardViewListener = wizardViewListener;
        this.initComponents("");
        this.resetPanel();
    }

    public EventWizardView(EventRulesTableModel model, IMultinetWizardView wizardViewListener) {
        this.model = model;
        this.multinetWizardViewListener = wizardViewListener;
        this.initComponents("");
        this.resetPanel();
    }

    @Override
    protected JComponent getOptionComponent() {
        if (this.tableView == null) {
            this.tableView = new EventTableView(this.model, this.multinetWizardViewListener);
            this.tableView.setName(WidgetName.SW_E_TABBLE.name());
        }
        return this.tableView;
    }

    @Override
    public void setWizardListener(IWizardTask listener) {
        super.setWizardListener(listener);
        this.tableView.setWizardListener(listener);
    }

    public void setEventControlListener(IEventControl listener) {
        this.eventControlListener = listener;
    }

    public EventRulesTableModel getModel() {
        return this.model;
    }

    @Override
    public void resetPanel() {
        if (this.tableView != null) {
            this.tableView.setDirty(false);
        }
    }

    @Override
    public boolean isDirty() {
        return this.tableView.isDirty();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.tableView.setDirty(dirty);
    }

    @Override
    public void setSubnet(SubnetDescription subnet) {
        this.resetPanel();
    }

    @Override
    public void updateView(MultinetWizardModel mwModel) {
        this.model = mwModel.getEventsModel().getEventsRulesModel();
        this.tableView.setModel(this.model);
        this.eventControlListener.updateTable(this.model);
    }

    public boolean isEditValid() {
        return true;
    }
}

