/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view.subnet;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.FieldPair;
import com.intel.stl.ui.common.view.SafeNumberField;
import com.intel.stl.ui.common.view.SafeTextField;
import com.intel.stl.ui.wizards.view.subnet.IHostInfoListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;

public class HostInfoPanel
extends JPanel {
    private static final long serialVersionUID = -7241402810197918958L;
    private final IHostInfoListener hostInfoListener;
    private final HostInfoPanel hostInfoPanel = this;
    private boolean currentMaster;
    private JPanel hostPanel;
    private JButton btnRemove;
    private JFormattedTextField txtFldHostName;
    private JFormattedTextField txtFldPortNum;
    private JCheckBox chkboxSecureConnect;
    private JFormattedTextField txtFldKeyStoreFile;
    private JButton btnKeyStoreBrowser;
    private JFormattedTextField txtFldTrustStoreFile;
    private JButton btnTrustStoreBrowser;
    private JPanel pnlConnection;
    private JPanel pnlSecurity;
    private JPanel pnlHostEntry;
    private final JFileChooser chooser;
    private JLabel lblConnectionStatus;
    private JButton btnConnectionTest;
    private final HostInfoPanel thisPanel = this;
    private final Insets insets = new Insets(3, 2, 3, 2);
    private final Insets widthInsets = new Insets(3, 10, 3, 2);

    public HostInfoPanel(IHostInfoListener hostInfoListener, JFileChooser chooser) {
        this.hostInfoListener = hostInfoListener;
        this.chooser = chooser;
        this.initComponents();
        this.enableCerts(false);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout(10, 5));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 4, UIConstants.INTEL_LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.add((Component)this.getHostPanel(), "Center");
        this.btnRemove = ComponentFactory.getImageButton(UIImages.CLOSE_RED.getImageIcon());
        this.btnRemove.setName(WidgetName.SW_H_REMOVE.name());
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostInfoPanel.this.hostInfoListener.removeHost(HostInfoPanel.this.hostInfoPanel);
            }
        });
        this.add((Component)this.btnRemove, "East");
    }

    protected JPanel getHostPanel() {
        if (this.hostPanel == null) {
            this.hostPanel = new JPanel(new GridBagLayout());
            this.hostPanel.setBackground(UIConstants.INTEL_WHITE);
            this.hostPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 2, 5));
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 1;
            gc.gridwidth = 1;
            gc.insets = new Insets(7, 2, 3, 2);
            JLabel label = ComponentFactory.getH5Label(STLConstants.K3037_FE_CONNECTION.getValue(), 1);
            label.setHorizontalAlignment(11);
            label.setVerticalAlignment(1);
            this.hostPanel.add((Component)label, gc);
            gc.weightx = 1.0;
            gc.gridwidth = 0;
            gc.insets = this.widthInsets;
            JPanel panel = this.getConnectionPanel();
            this.hostPanel.add((Component)panel, gc);
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            gc.insets = this.insets;
            label = ComponentFactory.getH5Label(STLConstants.K3033_CONNECTION_TEST.getValue(), 1);
            label.setHorizontalAlignment(11);
            this.hostPanel.add((Component)label, gc);
            gc.weightx = 1.0;
            gc.gridwidth = 0;
            gc.insets = this.widthInsets;
            panel = this.getConnTestPanel();
            this.hostPanel.add((Component)panel, gc);
        }
        return this.hostPanel;
    }

    protected JPanel getConnectionPanel() {
        if (this.pnlConnection == null) {
            this.pnlConnection = new JPanel(new BorderLayout(5, 5));
            this.pnlConnection.setOpaque(false);
            this.pnlConnection.add((Component)this.getHostEntryPanel(), "North");
            this.pnlConnection.add((Component)this.getSecurityPanel(), "Center");
        }
        return this.pnlConnection;
    }

    protected JPanel getHostEntryPanel() {
        if (this.pnlHostEntry == null) {
            this.pnlHostEntry = new JPanel(new BorderLayout(5, 5));
            this.pnlHostEntry.setOpaque(false);
            JPanel panel = new JPanel(new GridLayout(1, 2, 10, 5));
            panel.setOpaque(false);
            String hostNameChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqsrtuvwxyz-.";
            this.txtFldHostName = new SafeTextField(false, 253);
            this.txtFldHostName.setName(WidgetName.SW_H_HOST_NAME.name());
            ((SafeTextField)this.txtFldHostName).setValidChars(hostNameChars);
            for (DocumentListener listener : this.hostInfoListener.getDocumentListeners()) {
                this.txtFldHostName.getDocument().addDocumentListener(listener);
            }
            FieldPair<JFormattedTextField> fp = new FieldPair<JFormattedTextField>(STLConstants.K0051_HOST.getValue(), this.txtFldHostName);
            panel.add(fp);
            this.txtFldPortNum = new SafeNumberField<Integer>(new DecimalFormat("###"), 0, false, 65535, false);
            this.txtFldPortNum.setName(WidgetName.SW_H_HOST_PORT.name());
            ((SafeNumberField)this.txtFldPortNum).setValidChars("0123456789");
            for (DocumentListener listener : this.hostInfoListener.getDocumentListeners()) {
                this.txtFldPortNum.getDocument().addDocumentListener(listener);
            }
            this.txtFldPortNum.setText(STLConstants.K3015_DEFAULT_PORT.getValue());
            fp = new FieldPair<JFormattedTextField>(STLConstants.K1035_CONFIGURATION_PORT.getValue(), this.txtFldPortNum);
            panel.add(fp);
            this.pnlHostEntry.add((Component)panel, "Center");
            this.chkboxSecureConnect = ComponentFactory.getIntelCheckBox(STLConstants.K2003_SECURE_CONNECT.getValue());
            this.chkboxSecureConnect.setName(WidgetName.SW_H_SECURE_CONN.name());
            this.chkboxSecureConnect.setFont(UIConstants.H5_FONT.deriveFont(1));
            this.chkboxSecureConnect.setForeground(UIConstants.INTEL_DARK_GRAY);
            this.chkboxSecureConnect.setHorizontalAlignment(11);
            this.chkboxSecureConnect.setSelected(false);
            this.chkboxSecureConnect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    HostInfoPanel.this.hostInfoListener.setDirty();
                    boolean isSecureConnect = HostInfoPanel.this.chkboxSecureConnect.isSelected();
                    HostInfoPanel.this.enableCerts(isSecureConnect);
                }
            });
            this.pnlHostEntry.add((Component)this.chkboxSecureConnect, "East");
        }
        return this.pnlHostEntry;
    }

    protected JPanel getSecurityPanel() {
        if (this.pnlSecurity == null) {
            this.pnlSecurity = new JPanel(new GridLayout(1, 2, 10, 5));
            this.pnlSecurity.setOpaque(false);
            this.pnlSecurity.setBorder(BorderFactory.createTitledBorder(STLConstants.K3041_SSL.getValue()));
            this.txtFldKeyStoreFile = ComponentFactory.createTextField(null, false, 4096, this.hostInfoListener.getDocumentListeners());
            this.txtFldKeyStoreFile.setName(WidgetName.SW_H_KEYSTORE_FILE_NAME.name());
            SecureStorage ss = new SecureStorage(STLConstants.K2001_KEY_STORE.getValue(), this.txtFldKeyStoreFile);
            this.btnKeyStoreBrowser = ss.getBtnStoreBrowser();
            if (this.btnKeyStoreBrowser != null) {
                this.btnKeyStoreBrowser.setName(WidgetName.SW_H_KEYSTORE_FILE_BROWSER.name());
            }
            this.pnlSecurity.add(ss);
            this.txtFldTrustStoreFile = ComponentFactory.createTextField(null, false, 4096, this.hostInfoListener.getDocumentListeners());
            this.txtFldTrustStoreFile.setName(WidgetName.SW_H_TRUSTSTORE_FILE_NAME.name());
            ss = new SecureStorage(STLConstants.K2002_TRUST_STORE.getValue(), this.txtFldTrustStoreFile);
            this.btnTrustStoreBrowser = ss.getBtnStoreBrowser();
            if (this.btnTrustStoreBrowser != null) {
                this.btnTrustStoreBrowser.setName(WidgetName.SW_H_TRUSTSTORE_FILE_BROWSER.name());
            }
            this.pnlSecurity.add(ss);
        }
        return this.pnlSecurity;
    }

    protected JPanel getConnTestPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = this.insets;
        gc.gridwidth = 1;
        this.btnConnectionTest = ComponentFactory.getImageButton(UIImages.PLAY.getImageIcon());
        this.btnConnectionTest.setName(WidgetName.SW_H_TEST_CONN.name());
        this.btnConnectionTest.setToolTipText(STLConstants.K3027_TEST_CONNECTION.getValue());
        this.btnConnectionTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!HostInfoPanel.this.txtFldHostName.isEditValid() || !HostInfoPanel.this.txtFldPortNum.isEditValid()) {
                    return;
                }
                if (HostInfoPanel.this.btnConnectionTest.isSelected()) {
                    HostInfoPanel.this.stopConnectionTest();
                } else {
                    HostInfoPanel.this.testConnection();
                }
            }
        });
        panel.add((Component)this.btnConnectionTest, gc);
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        this.lblConnectionStatus = ComponentFactory.getH5Label(STLConstants.K3028_NOT_TESTED.getValue(), 0);
        this.lblConnectionStatus.setName(WidgetName.SW_H_CONN_STATUS.name());
        panel.add((Component)this.lblConnectionStatus, gc);
        return panel;
    }

    protected void testConnection() {
        if (this.txtFldHostName.getText().equals("") || this.txtFldPortNum.getText().equals("")) {
            this.hostInfoListener.showErrorMessage(STLConstants.K3042_HOST_PORT_BLANK.getValue());
            return;
        }
        this.btnConnectionTest.setSelected(true);
        if (this.hostInfoListener.hasDuplicateHosts()) {
            this.hostInfoListener.showErrorMessage(UILabels.STL50086_DUPLICATE_HOSTS.getDescription());
            return;
        }
        this.btnConnectionTest.setIcon(UIImages.STOP.getImageIcon());
        this.lblConnectionStatus.setIcon(UIImages.RUNNING.getImageIcon());
        this.setLabel(this.lblConnectionStatus, STLConstants.K0606_CONNECTING.getValue(), UIConstants.INTEL_DARK_GRAY);
        this.hostInfoListener.runConnectionTest(this.thisPanel);
    }

    public void enableRemove(boolean enable) {
        this.btnRemove.setEnabled(enable);
    }

    public void setFocus() {
        this.txtFldHostName.grabFocus();
    }

    public void stopConnectionTest() {
        this.btnConnectionTest.setIcon(UIImages.PLAY.getImageIcon());
        this.lblConnectionStatus.setIcon(null);
        this.setLabel(this.lblConnectionStatus, STLConstants.K3028_NOT_TESTED.getValue(), UIConstants.INTEL_DARK_GRAY);
        this.btnConnectionTest.setSelected(false);
    }

    public void setConnectionStatus(String status) {
        this.btnConnectionTest.setIcon(UIImages.PLAY.getImageIcon());
        this.btnConnectionTest.setSelected(false);
        this.lblConnectionStatus.setIcon(null);
        Color color = status.equals(STLConstants.K3031_PASS.getValue()) ? UIConstants.DARK_GREEN : UIConstants.INTEL_RED;
        this.setLabel(this.lblConnectionStatus, status, color);
        this.btnConnectionTest.setIcon(UIImages.PLAY.getImageIcon());
    }

    protected void setLabel(JLabel lbl, String value, Color color) {
        lbl.setText(value);
        lbl.setForeground(color);
    }

    protected void enableCerts(boolean enable) {
        this.txtFldKeyStoreFile.setEnabled(enable);
        if (this.btnKeyStoreBrowser != null) {
            this.btnKeyStoreBrowser.setEnabled(enable);
        }
        this.txtFldTrustStoreFile.setEnabled(enable);
        if (this.btnTrustStoreBrowser != null) {
            this.btnTrustStoreBrowser.setEnabled(enable);
        }
        Color color = enable ? UIConstants.INTEL_WHITE : null;
        this.txtFldKeyStoreFile.setBackground(color);
        this.txtFldTrustStoreFile.setBackground(color);
        this.pnlSecurity.setVisible(enable);
    }

    public void setCurrentMaster(boolean currentMaster) {
        this.currentMaster = currentMaster;
    }

    public boolean isCurrentMaster() {
        return this.currentMaster;
    }

    public void setHostName(String hostName) {
        this.txtFldHostName.setText(hostName);
    }

    public String getHostName() {
        return this.txtFldHostName.getText();
    }

    public void setPortNum(String portNum) {
        this.txtFldPortNum.setText(portNum);
    }

    public String getPortNum() {
        return this.txtFldPortNum.getText();
    }

    public void setSecureConnection(boolean b) {
        this.chkboxSecureConnect.setSelected(b);
    }

    public boolean isSecureConnection() {
        return this.chkboxSecureConnect.isSelected();
    }

    public void setKeyStoreFile(String keyStoreFileName) {
        this.txtFldKeyStoreFile.setText(keyStoreFileName);
    }

    public String getKeyStoreFile() {
        return this.txtFldKeyStoreFile.getText();
    }

    public void setTrustFileFile(String trustStoreFileName) {
        this.txtFldTrustStoreFile.setText(trustStoreFileName);
    }

    public String getTrustStoreFile() {
        return this.txtFldTrustStoreFile.getText();
    }

    public boolean isHostNamePopulated() {
        return this.txtFldHostName.getText().length() > 0;
    }

    public boolean isPortNumPopulated() {
        return this.txtFldPortNum.getText().length() > 0;
    }

    public boolean isKeyStorePopulated() {
        return this.txtFldKeyStoreFile.getText().trim().length() > 0;
    }

    public boolean isTrustStorePopulated() {
        return this.txtFldTrustStoreFile.getText().trim().length() > 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostInfoPanel other = (HostInfoPanel)obj;
        if (this.txtFldHostName.getText() == null ? other.txtFldHostName.getText() != null : !this.txtFldHostName.getText().equalsIgnoreCase(other.txtFldHostName.getText())) {
            return false;
        }
        if (this.txtFldPortNum.getText() == null ? other.txtFldPortNum.getText() != null : !this.txtFldPortNum.getText().equalsIgnoreCase(other.txtFldPortNum.getText())) {
            return false;
        }
        if (this.txtFldKeyStoreFile.getText() == null ? other.txtFldKeyStoreFile.getText() != null : !this.txtFldKeyStoreFile.getText().equalsIgnoreCase(other.txtFldKeyStoreFile.getText())) {
            return false;
        }
        if (this.txtFldTrustStoreFile.getText() == null ? other.txtFldTrustStoreFile.getText() != null : !this.txtFldTrustStoreFile.getText().equalsIgnoreCase(other.txtFldTrustStoreFile.getText())) {
            return false;
        }
        if (this.chkboxSecureConnect == null) {
            if (other.chkboxSecureConnect != null) {
                return false;
            }
        } else if (this.chkboxSecureConnect != null && other.chkboxSecureConnect != null) {
            boolean case2;
            boolean case1 = !this.chkboxSecureConnect.isSelected() && other.isSecureConnection();
            boolean bl = case2 = this.chkboxSecureConnect.isSelected() && !other.isSecureConnection();
            if (case1 || case2) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        try {
            int prime = 13;
            result = prime * result + (this.getHostName() == null ? 0 : this.getHostName().toLowerCase().hashCode());
            result = prime * result + (this.getHostName() == null ? 0 : this.getHostName().hashCode());
            result = prime * result + Integer.valueOf(this.getPortNum());
            result = prime * result + (this.getKeyStoreFile() == null ? 0 : this.getKeyStoreFile().hashCode());
            result = prime * result + (this.getTrustStoreFile() == null ? 0 : this.getTrustStoreFile().hashCode());
        }
        catch (NumberFormatException e) {
            this.hostInfoListener.showErrorMessage("Hash Code Error: " + this.getClass().getName());
        }
        return result;
    }

    public boolean isEditValid() {
        return this.txtFldHostName.isEditValid() && this.txtFldPortNum.isEditValid() && this.txtFldKeyStoreFile.isEditValid() && this.txtFldTrustStoreFile.isEditValid();
    }

    protected class SecureStorage
    extends FieldPair<JFormattedTextField> {
        private static final long serialVersionUID = -3358500581251310645L;
        private JButton btnStoreBrowser;

        public SecureStorage(String name, JFormattedTextField textField) {
            super(name, textField);
        }

        @Override
        protected void initComponents(String name, final JFormattedTextField textField) {
            super.initComponents(name, textField);
            this.btnStoreBrowser = ComponentFactory.getImageButton(UIImages.FOLDER_ICON.getImageIcon());
            this.btnStoreBrowser.setMargin(new Insets(2, 2, 2, 2));
            this.btnStoreBrowser.setToolTipText(STLConstants.K0642_BROWSE.getValue());
            this.btnStoreBrowser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newFile = SecureStorage.this.chooseFile(textField.getText());
                    if (newFile != null) {
                        textField.setText(newFile);
                        HostInfoPanel.this.hostInfoListener.setDirty();
                    }
                }
            });
            this.add((Component)this.btnStoreBrowser, "East");
        }

        protected String chooseFile(String iniFile) {
            int returnVal;
            if (!iniFile.isEmpty()) {
                File file = new File(iniFile);
                HostInfoPanel.this.chooser.setCurrentDirectory(file.getParentFile());
            }
            if ((returnVal = HostInfoPanel.this.hostInfoListener.showFileChooser()) == 0) {
                return HostInfoPanel.this.chooser.getSelectedFile().getAbsolutePath();
            }
            return null;
        }

        public JButton getBtnStoreBrowser() {
            return this.btnStoreBrowser;
        }
    }
}

