/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.xml;

import com.intel.stl.xml.EntryType;
import com.intel.stl.xml.Preferences;
import com.intel.stl.xml.SectionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class PreferencesAdapter
extends XmlAdapter<Preferences, Map<String, Properties>> {
    public Map<String, Properties> unmarshal(Preferences preferences) throws Exception {
        List<SectionType> sections = preferences.getSectionTypes();
        HashMap<String, Properties> prefsMap = new HashMap<String, Properties>(sections.size());
        for (SectionType section : sections) {
            String sectionName = section.getName();
            Properties prefProps = new Properties();
            for (EntryType entry : section.getEntry()) {
                prefProps.put(entry.getName(), entry.getValue());
            }
            prefsMap.put(sectionName, prefProps);
        }
        return prefsMap;
    }

    public Preferences marshal(Map<String, Properties> prefsMap) throws Exception {
        Preferences preferences = new Preferences();
        if (prefsMap != null) {
            Set<String> keys = prefsMap.keySet();
            List<SectionType> sections = preferences.getSectionTypes();
            for (String sectionName : keys) {
                SectionType sectionType = new SectionType();
                sectionType.setName(sectionName);
                List<EntryType> entryList = sectionType.getEntry();
                Properties prefProps = prefsMap.get(sectionName);
                Set<Object> propNames = prefProps.keySet();
                for (Object propName : propNames) {
                    Object propValue = prefProps.get(propName);
                    EntryType entry = new EntryType();
                    entry.setName(propName.toString());
                    entry.setValue(propValue.toString());
                    entryList.add(entry);
                }
                sections.add(sectionType);
            }
        }
        return preferences;
    }
}

