"""
The tests in this script will execute the sanity tests integrated in the hwloc
core patch for KNL-SB.

Each test exists in a single binary, then all we have to do is to execute each
binary and check the output. This could change as more tests are being
integrated.
"""

import exec_utils
import os

TEST_PATH,_ = os.path.split(os.path.abspath(__file__))
TEST_DATA_PATH = TEST_PATH + "/tests/linux"
TEST_PATH = TEST_PATH + "/usr/bin"

def get_target():
    # TODO, this function must be on exec_utils lib
    is_sb = True
    if is_sb:
        target = exec_utils.Host()
    else:
        target = exec_utils.Card()
    return target


def run_bin(test, target):
    cmd = "/{0}/{1}".format(TEST_PATH, test)
    output, retcode = target.run(cmd)
    assert retcode == 0, "{0}".format(output)

def run_test(test, target):
    cmd = "/{0}/test-topology.sh /{1}/{2}".format(TEST_PATH, TEST_DATA_PATH, test)
    output, retcode = target.run(cmd)
    assert retcode == 0, "{0}".format(output)

class Test_HwlocTest():

    target = None

    def setup(self):
        self.target = get_target()

    def teardown(self):
        pass

    def test_TC_Miclinux_Hwloc_gl(self):
        run_bin("gl", self.target)

    def test_TC_Miclinux_Hwloc_glibcSched(self):
        run_bin("glibc-sched", self.target)

    def test_TC_Miclinux_Hwloc_backends(self):
        run_bin("hwloc_backends", self.target)

    def test_TC_Miclinux_Hwloc_bind(self):
        run_bin("hwloc_bind ", self.target)

    def test_TC_Miclinux_Hwloc_bitmap(self):
        run_bin("hwloc_bitmap", self.target)

    def test_TC_Miclinux_Hwloc_bitmapCompareInclusion(self):
        run_bin("hwloc_bitmap_compare_inclusion", self.target)

    def test_TC_Miclinux_Hwloc_bitmapFirstLastWeight(self):
        run_bin("hwloc_bitmap_first_last_weight", self.target)

    def test_TC_Miclinux_Hwloc_bitmapSinglify(self):
        run_bin("hwloc_bitmap_singlify", self.target)

    def test_TC_Miclinux_Hwloc_bitmapString(self):
        run_bin("hwloc_bitmap_string", self.target)

    def test_TC_Miclinux_Hwloc_distances(self):
        run_bin("hwloc_distances", self.target)

    def test_TC_Miclinux_Hwloc_getCacheCoveringCpuset(self):
        run_bin("hwloc_get_cache_covering_cpuset", self.target)

    def test_TC_Miclinux_Hwloc_getClosestObjs(self):
        run_bin("hwloc_get_closest_objs", self.target)

    def test_TC_Miclinux_Hwloc_getLargestObjsInsideCpuset(self):
        run_bin("hwloc_get_largest_objs_inside_cpuset", self.target)

    def test_TC_Miclinux_Hwloc_getLastCpuLocation(self):
        run_bin("hwloc_get_last_cpu_location", self.target)

    def test_TC_Miclinux_Hwloc_getNextObjCoveringCpuset(self):
        run_bin("hwloc_get_next_obj_covering_cpuset", self.target)

    def test_TC_Miclinux_Hwloc_getObjBelowArrayByType(self):
        run_bin("hwloc_get_obj_below_array_by_type", self.target)

    def test_TC_Miclinux_Hwloc_getObjCoveringCpuset(self):
        run_bin("hwloc_get_obj_covering_cpuset", self.target)

    def test_TC_Miclinux_Hwloc_getObjInsideCpuset(self):
        run_bin("hwloc_get_obj_inside_cpuset", self.target)

    def test_TC_Miclinux_Hwloc_getSharedCacheCoveringObj(self):
        run_bin("hwloc_get_shared_cache_covering_obj", self.target)

    def test_TC_Miclinux_Hwloc_groups(self):
        run_bin("hwloc_groups", self.target)

    def test_TC_Miclinux_Hwloc_groups2(self):
        run_bin("hwloc_groups2", self.target)

    def test_TC_Miclinux_Hwloc_insert_misc(self):
        run_bin("hwloc_insert_misc", self.target)

    def test_TC_Miclinux_Hwloc_iodevs(self):
        run_bin("hwloc_iodevs", self.target)

    def test_TC_Miclinux_Hwloc_is_thissystem(self):
        run_bin("hwloc_is_thissystem", self.target)

    def test_TC_Miclinux_Hwloc_list_components(self):
        run_bin("hwloc_list_components", self.target)

    def test_TC_Miclinux_Hwloc__objectUserdata(self):
        run_bin("hwloc_object_userdata", self.target)

    def test_TC_Miclinux_Hwloc_objInfos(self):
        run_bin("hwloc_obj_infos", self.target)

    def test_TC_Miclinux_Hwloc_hwloc_pci_backend(self):
        run_bin("hwloc_pci_backend", self.target)

    def test_TC_Miclinux_Hwloc_synthetic(self):
        run_bin("hwloc_synthetic", self.target)

    def test_TC_Miclinux_Hwloc_topologyDiff(self):
        run_bin("hwloc_topology_diff", self.target)

    def test_TC_Miclinux_Hwloc_topologyDup(self):
        run_bin("hwloc_topology_dup", self.target)

    def test_TC_Miclinux_Hwloc_topologyRestrict(self):
        run_bin("hwloc_topology_restrict", self.target)

    def test_TC_Miclinux_Hwloc_hwloc_typeDepth(self):
        run_bin("hwloc_type_depth", self.target)

    def test_TC_Miclinux_Hwloc_intelMic(self):
        run_bin("intel-mic", self.target)

    def test_TC_Miclinux_Hwloc_hwloc_linuxLibnuma(self):
        run_bin("linux-libnuma", self.target)

    def test_TC_Miclinux_Hwloc_xmlbuffer(self):
        run_bin("xmlbuffer", self.target)

    def test_TC_128ia64_17n4s2c(self):
        run_test("128ia64-17n4s2c.output", self.target)

    def test_TC_16amd64_4n4c_cgroup_distance_merge(self):
        run_test("16amd64-4n4c-cgroup-distance-merge.output", self.target)

    def test_TC_16amd64_8n2c_cpusets_noadmin(self):
        run_test("16amd64-8n2c-cpusets_noadmin.output", self.target)

    def test_TC_16amd64_8n2c_cpusets(self):
        run_test("16amd64-8n2c-cpusets.output", self.target)

    def test_TC_16amd64_8n2c_cpusets_xml(self):
        run_test("16amd64-8n2c-cpusets.xml.output", self.target)

    def test_TC_16amd64_8n2c(self):
        run_test("16amd64-8n2c.output", self.target)

    def test_TC_16em64t_2m4c2t(self):
        run_test("16em64t-2m4c2t.output", self.target)

    def test_TC_16em64t_4s2c2t_merge(self):
        run_test("16em64t-4s2c2t_merge.output", self.target)

    def test_TC_16em64t_4s2c2t_ncaches(self):
        run_test("16em64t-4s2c2t_ncaches.output", self.target)

    def test_TC_16em64t_4s2c2t_offlines_noadmin(self):
        run_test("16em64t-4s2c2t-offlines_noadmin.output", self.target)

    def test_TC_16em64t_4s2c2t_offlines(self):
        run_test("16em64t-4s2c2t-offlines.output", self.target)

    def test_TC_16em64t_4s2c2t_offlines_xml(self):
        run_test("16em64t-4s2c2t-offlines.xml.output", self.target)

    def test_TC_16em64t_4s2c2t(self):
        run_test("16em64t-4s2c2t.output", self.target)

    def test_TC_16em64t_4s2c2t_xml(self):
        run_test("16em64t-4s2c2t.xml.output", self.target)

    def test_TC_16em64t_4s2ca2c_cpusetreorder_merge(self):
        run_test("16em64t-4s2ca2c-cpusetreorder-merge.output", self.target)

    def test_TC_16em64t_4s2ca2c_cpusetreorder(self):
        run_test("16em64t-4s2ca2c-cpusetreorder.output", self.target)

    def test_TC_16ia64_8n2s(self):
        run_test("16ia64-8n2s.output", self.target)

    def test_TC_1alpha(self):
        run_test("1alpha.output", self.target)

    def test_TC_20s390_2g6s4c(self):
        run_test("20s390-2g6s4c.output", self.target)

    def test_TC_24em64t_2n6c2t_2mic_olddriver(self):
        run_test("24em64t-2n6c2t+2mic.olddriver.output", self.target)

    def test_TC_256ia64_64n2s2c(self):
        run_test("256ia64-64n2s2c.output", self.target)

    def test_TC_256ppc_8n8s4t_nocache(self):
        run_test("256ppc-8n8s4t-nocache.output", self.target)

    def test_TC_256ppc_8n8s4t_nosys(self):
        run_test("256ppc-8n8s4t-nosys.output", self.target)

    def test_TC_256ppc_8n8s4t(self):
        run_test("256ppc-8n8s4t.output", self.target)

    def test_TC_28em64t_2s2n7c_buggycoresiblings(self):
        run_test("28em64t-2s2n7c-buggycoresiblings.output", self.target)

    def test_TC_2amd64_2n(self):
        run_test("2amd64-2n.output", self.target)

    def test_TC_2arm_2c(self):
        run_test("2arm-2c.output", self.target)

    def test_TC_2i386_2c_nohugepage_xml(self):
        run_test("2i386-2c-nohugepage.xml.output", self.target)

    def test_TC_2i386_2t_hugepagesizecount_xml(self):
        run_test("2i386-2t-hugepagesizecount.xml.output", self.target)

    def test_TC_2ps3_2t(self):
        run_test("2ps3-2t.output", self.target)

    def test_TC_2s390_2c(self):
        run_test("2s390-2c.output", self.target)

    def test_TC_32amd64_4s2n4c_cgroup(self):
        run_test("32amd64-4s2n4c-cgroup.output", self.target)

    def test_TC_32amd64_4s2n4c_cgroup_xml(self):
        run_test("32amd64-4s2n4c-cgroup.xml.output", self.target)

    def test_TC_32em64t_2n8c_1mic(self):
        run_test("32em64t-2n8c+1mic.output", self.target)

    def test_TC_32ppc_4n4c2c(self):
        run_test("32ppc-4n4c2c.output", self.target)

    def test_TC_40intel64_2g2n4c_pci(self):
        run_test("40intel64-2g2n4c+pci.output", self.target)

    def test_TC_40intel64_4n10c_pci_conflicts(self):
        run_test("40intel64-4n10c+pci-conflicts.output", self.target)

    def test_TC_48amd64_4d2n6c_sparse(self):
        run_test("48amd64-4d2n6c-sparse.output", self.target)

    def test_TC_4em64t_2c2t_ignore_reorder(self):
        run_test("4em64t-2c2t-ignore-reorder.output", self.target)

    def test_TC_4ia64_4s(self):
        run_test("4ia64-4s.output", self.target)

    def test_TC_4ppc_4c(self):
        run_test("4ppc-4c.output", self.target)

    def test_TC_4qs22_2s2t(self):
        run_test("4qs22-2s2t.output", self.target)

    def test_TC_64amd64_4s2n4ca2co(self):
        run_test("64amd64-4s2n4ca2co.output", self.target)

    def test_TC_64fake_4n2s2ca2c2t(self):
        run_test("64fake-4n2s2ca2c2t.output", self.target)

    def test_TC_8amd64_4n2c(self):
        run_test("8amd64-4n2c.output", self.target)

    def test_TC_8em64t_2s2ca2c_buggynuma(self):
        run_test("8em64t-2s2ca2c-buggynuma.output", self.target)

    def test_TC_8em64t_2s2ca2c(self):
        run_test("8em64t-2s2ca2c.output", self.target)

    def test_TC_8em64t_2s4c_heterogeneous(self):
        run_test("8em64t-2s4c-heterogeneous.output", self.target)

    def test_TC_8em64t_4c2t(self):
        run_test("8em64t-4c2t.output", self.target)

    def test_TC_8ia64_2n2s2c(self):
        run_test("8ia64-2n2s2c.output", self.target)

    def test_TC_8ia64_2s2c2t(self):
        run_test("8ia64-2s2c2t.output", self.target)

    def test_TC_8ia64_4s2c(self):
        run_test("8ia64-4s2c.output", self.target)

    def test_TC_96em64t_4n4d3ca2co_forcecpuinfo(self):
        run_test("96em64t-4n4d3ca2co-forcecpuinfo.output", self.target)

    def test_TC_96em64t_4n4d3ca2co(self):
        run_test("96em64t-4n4d3ca2co.output", self.target)

    def test_TC_288intel64_2n_knl_a2a_cache_hwdata(self):
        run_test("288intel64-2n-knl-a2a-cache-hwdata.output", self.target)

    def test_TC_288intel64_2n_knl_a2a_cache(self):
        run_test("288intel64-2n-knl-a2a-cache.output", self.target)

    def test_TC_288intel64_2n_knl_a2a_flat(self):
        run_test("288intel64-2n-knl-a2a-flat.output", self.target)

    def test_TC_288intel64_2n_knl_a2a_hyb50_hwdata(self):
        run_test("288intel64-2n-knl-a2a-hyb50-hwdata.output", self.target)

    def test_TC_288intel64_2n_knl_a2a_hyb50(self):
        run_test("288intel64-2n-knl-a2a-hyb50.output", self.target)

    def test_TC_288intel64_2n_knl_snc2_cache_hwdata(self):
        run_test("288intel64-2n-knl-snc2-cache-hwdata.output", self.target)

    def test_TC_288intel64_2n_knl_snc2_cache(self):
        run_test("288intel64-2n-knl-snc2-cache.output", self.target)

    def test_TC_288intel64_2n_knl_snc2_flat(self):
        run_test("288intel64-2n-knl-snc2-flat.output", self.target)

    def test_TC_288intel64_2n_knl_snc2_hyb50_hwdata(self):
        run_test("288intel64-2n-knl-snc2-hyb50-hwdata.output", self.target)

    def test_TC_288intel64_2n_knl_snc2_hyb50(self):
        run_test("288intel64-2n-knl-snc2-hyb50.output", self.target)

    def test_TC_288intel64_2n_knl_snc4_cache_hwdata(self):
        run_test("288intel64-2n-knl-snc4-cache-hwdata.output", self.target)

    def test_TC_288intel64_2n_knl_snc4_cache(self):
        run_test("288intel64-2n-knl-snc4-cache.output", self.target)

    def test_TC_288intel64_2n_knl_snc4_flat(self):
        run_test("288intel64-2n-knl-snc4-flat.output", self.target)

    def test_TC_288intel64_2n_knl_snc4_hyb50_hwdata(self):
        run_test("288intel64-2n-knl-snc4-hyb50-hwdata.output", self.target)

    def test_TC_288intel64_2n_knl_snc4_hyb50(self):
        run_test("288intel64-2n-knl-snc4-hyb50.output", self.target)

    def test_TC_8intel64_2n_knm_a2a_flat(self):
        run_test("8intel64-2n-knm-a2a-flat.output", self.target)
