# Copyright (c) 2017, Intel Corporation.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms and conditions of the GNU General Public License,
# version 2, as published by the Free Software Foundation.
#
# This program is distributed in the hope it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.

# useful documentation
# RedHat:
#    /usr/lib/rpm/redhat/macros
#    /usr/lib/rpm/redhat/kmodtool
#    https://wiki.centos.org/HowTos/BuildingKernelModules
# SUSE:
#   /etc/rpm/macros.kernel-source
#   /usr/lib/rpm/kernel-module-subpackage
#   https://drivers.suse.com/doc/kmpm/Kmpm-code11.pdf

%define include(f:) %{-f:%{expand:%(cd %_sourcedir; cat %{-f*})}}

# disable debug package generation
%define debug_package %{nil}

%{!?kernel_flavor: %global kernel_flavor default}

%{!?kernel_src: %global kernel_src /lib/modules/%(uname -r)/build}
%{!?kernel_version: %global kernel_version %(cat %kernel_src/include/config/kernel.release)}

%if %{_vendor} == redhat
%{!?use_kmp: %global use_kmp 1}
%endif

%if 0%{?suse_version}
%{!?use_kmp: %global use_kmp 1}
%endif

%global kernel_version_main %(kver=%kernel_version; echo ${kver%%-*})
%global kernel_version_extra %(kver=%kernel_version; echo ${kver#*-})

Summary:		Zone free list sorter
Name:			zonesort
Distribution:	Intel(R) Xeon Phi(TM) processor software
Group:			System Environment/Kernel
Version:		%{?version}%{!?version:1.0}
Release:		%{?release}%{!?release:1}
License:		GPLv2
Vendor:			Intel Corporation
URL:			http://www.intel.com
ExclusiveArch:	x86_64
Source0:		zonesort-%version.tar.gz
Source1:		zonesort-preambule
Source2:		zonesort-filelist

%if %use_kmp != 1
%include -f %{SOURCE1} %kernel_version_extra %kernel_version_main
%endif

%if %use_kmp == 1
BuildRequires:	%kernel_module_package_buildreqs

%define kmp_name %name
%define kmod_version %version
%define kmod_release %release

%kernel_module_package -n %{kmp_name} -p %{SOURCE1} -f %{SOURCE2} %kernel_flavor
%endif

%description
The zonesort module provides mechanism to change order in a list of free pages kept
in Linux kernel buddy allocator. The order is changed so to minimize possible
page collisions later when those pages are served to the application.
The algorithm assumes that the system has up to 16GB of direct-mapped cache.

%prep
%setup

%build
%{__make} \
	DESTDIR=%{buildroot} \
	MODULE_VERSION=%{version}-%{release} \
	KERNEL_SRC=%{kernel_src}

%install
%{__make} \
	DESTDIR=%{buildroot} \
	MODULE_VERSION=%{version}-%{release} \
	KERNEL_SRC=%{kernel_src} \
	install

%if %use_kmp == 1
%check
# print a warning if the KMP scripts cannot detect the kernel version
# usually it ends with error during processing files for the package
set +x
if [ "%{_vendor}" = "redhat" ] && [ "%kverrel" != "%kernel_version" ]; then
	echo "" >&2
	echo "********************************************************************************" >&2
	echo "***************** KERNEL MODULE PACKAGE COMPATIBILITY WARNING ******************" >&2
	echo "********************************************************************************" >&2
	echo "Your kernel name does not adhere to Red Hat* specifications enforced by kmodtool" >&2
	echo "at %kmodtool. Please ensure your kernel name ends in $(arch)." >&2
	echo "" >&2
fi
%endif

%if %use_kmp != 1
%files
%include -f %{SOURCE2} %kernel_version_extra %kernel_version_main
%endif

%changelog
