@echo off
::      Windows-micperf do_install.bat script.
::      The purpose of this is to decouple installation
::      from the actual build. The expectation is that
::      environment variable INTEL_MPSS_HOST_DESTDIR
::      will be set to the destination directory
::      Users can set this environment variable
::      themselves if they want to run this script.


:: ---- Set some per-component variables ----
::set BUILDDIR=build\x64\Release\
set ROOTDIR=.

set TOGGLE_MK_DESTDIR=0
if not defined INTEL_MPSS_HOST_DESTDIR (
    if exist "%INTEL_MPSS_HOST_SDK%" (
        set INTEL_MPSS_HOST_DESTDIR=%INTEL_MPSS_HOST_SDK%..\
    ) else (
        set INTEL_MPSS_HOST_DESTDIR=C:\TempMicperfInstall
        set TOGGLE_MK_DESTDIR=1
    )
    )
if not defined INTEL_MPSS_HOST_INCLUDE (
    set INTEL_MPSS_HOST_INCLUDE=%INTEL_MPSS_HOST_DESTDIR%\sdk\include
        )
if not defined INTEL_MPSS_HOST_LIB (
    set INTEL_MPSS_HOST_LIB=%INTEL_MPSS_HOST_DESTDIR%\sdk\lib
        )
if not defined INTEL_MPSS_HOST_BIN (
    set INTEL_MPSS_HOST_BIN=%INTEL_MPSS_HOST_DESTDIR%\bin
        )
if not defined INTEL_MPSS_HOST_DOC (
    set INTEL_MPSS_HOST_DOC=%INTEL_MPSS_HOST_DESTDIR%\docs
        )
if not defined INTEL_MPSS_HOST_DRIVERS (
    set INTEL_MPSS_HOST_DRIVERS=%INTEL_MPSS_HOST_DESTDIR%\drivers
        )
if not defined INTEL_MPSS_HOST_SYSTEM (
    set INTEL_MPSS_HOST_SYSTEM=%INTEL_MPSS_HOST_DESTDIR%\system
        )
if not defined INTEL_MPSS_HOST_SYSTEM32 (
    set INTEL_MPSS_HOST_SYSTEM32=%INTEL_MPSS_HOST_DESTDIR%\system32
        )
if not defined INTEL_MPSS_HOST_TUTORIAL (
    set INTEL_MPSS_HOST_TUTORIAL=%INTEL_MPSS_HOST_SDK%\tutorials
        )



:: ---- Set some useful intermediate directories. These
:: ---- should be set the same for all components.
::set INTEL_MPSS_HOST_INCLUDE=%INTEL_MPSS_HOST_DESTDIR%\sdk\include\
::set INTEL_MPSS_HOST_LIB=%INTEL_MPSS_HOST_DESTDIR%\sdk\lib\
::set INTEL_MPSS_HOST_BIN=%INTEL_MPSS_HOST_DESTDIR%\bin\
::set INTEL_MPSS_HOST_DOC=%INTEL_MPSS_HOST_DESTDIR%\docs\
::set INTEL_MPSS_HOST_TUTORIAL=%INTEL_MPSS_HOST_DESTDIR%\sdk\tutorials\
::set INTEL_MPSS_HOST_SYSTEM32=%INTEL_MPSS_HOST_DESTDIR%\system32\


set INTEL_MPSS_HOST_MICPERF=%INTEL_MPSS_HOST_DESTDIR%\sdk\micperf\
set INTEL_MPSS_HOST_MICPERF_X64=%INTEL_MPSS_HOST_MICPERF%\libexec\x86_64\
set INTEL_MPSS_HOST_MICPERF_K1OM=%INTEL_MPSS_HOST_MICPERF%\libexec\k1om\
set INTEL_MPSS_HOST_MICPERF_MICP=%INTEL_MPSS_HOST_MICPERF%\micp\
set INTEL_MPSS_HOST_MICPERF_DATA=%INTEL_MPSS_HOST_MICPERF%\data
set INTEL_MPSS_HOST_MICPERF_TUTORIAL=%INTEL_MPSS_HOST_TUTORIAL%\micperf\


:: --- This set command can be used for debugging ---
:: --- remove the :: to enable it
::set

:: Set initial error condition to zero
set FAILED=0

echo ---- Make initial directories ----
echo using dest dir: %INTEL_MPSS_HOST_DESTDIR%
if not exist "%INTEL_MPSS_HOST_DESTDIR%" ( mkdir "%INTEL_MPSS_HOST_DESTDIR%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_INCLUDE%" ( mkdir "%INTEL_MPSS_HOST_INCLUDE%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_LIB%" ( mkdir "%INTEL_MPSS_HOST_LIB%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_BIN%" ( mkdir "%INTEL_MPSS_HOST_BIN%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_DOC%" ( mkdir "%INTEL_MPSS_HOST_DOC%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_TUTORIAL%" ( mkdir "%INTEL_MPSS_HOST_TUTORIAL%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_SYSTEM32%" ( mkdir "%INTEL_MPSS_HOST_SYSTEM32%" || set FAILED=%ERRORLEVEL% )

if not exist "%INTEL_MPSS_HOST_MICPERF%" ( mkdir "%INTEL_MPSS_HOST_MICPERF%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_MICPERF_X64%" ( mkdir "%INTEL_MPSS_HOST_MICPERF_X64%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_MICPERF_K1OM%" ( mkdir "%INTEL_MPSS_HOST_MICPERF_K1OM%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_MICPERF_MICP%" ( mkdir "%INTEL_MPSS_HOST_MICPERF_MICP%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_MICPERF_DATA%" ( mkdir "%INTEL_MPSS_HOST_MICPERF_DATA%" || set FAILED=%ERRORLEVEL% )
if not exist "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%" ( mkdir "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%" || set FAILED=%ERRORLEVEL% )


if NOT %FAILED%==0  (
    if %FAILED%==1  (
            set FAILED=0
            goto DirectoryAlreadyExists
    ) 
	echo "Could not make output directories, error %FAILED%"
	exit /b %FAILED%
)
:DirectoryAlreadyExists

echo ---- Install Bins ----
for %%x in (BusSpeedDownload_pragma BusSpeedDownload_scif BusSpeedReadback_pragma BusSpeedReadback_scif dgemm_ofl sgemm_ofl) do (
    xcopy /Y "build\%%x\x64\Release\x86_64\*.exe" "%INTEL_MPSS_HOST_MICPERF_X64%" || set FAILED=%ERRORLEVEL%
)
if NOT %FAILED%==0  (
	echo "Could not copy micperf content, error %FAILED%"
	exit /b %FAILED%
)


for %%x in (BusSpeed_mic dgemm_mic.x sgemm_mic.x stream_mic) do (
    xcopy /Y "build\%%x\x64\Release\k1om\*" "%INTEL_MPSS_HOST_MICPERF_K1OM%" || set FAILED=%ERRORLEVEL%
)
if NOT %FAILED%==0 (
    echo "Could not copy micperf content, error %FAILED%"
    exit /b %FAILED%
)

echo ---- Install Tools ----
xcopy /Y /s "micp-sdist" "%INTEL_MPSS_HOST_MICPERF_MICP%" || set FAILED=%ERRORLEVEL%
if NOT %FAILED%==0 (
    echo "could not copy micp, error %FAILED%"
    exit /b %FAILED%
)

echo ---- Preprocess micp documentation ----
python preprocess_micp.py %INTEL_MPSS_HOST_MICPERF_MICP% knc %MPSS_VERSION% "/usr/share" "/usr/libexec" || set FAILED=%ERRORLEVEL%
if NOT %FAILED%==0 (
    echo "Could not create micp/micprun help %FAILED%"
    exit /b %FAILED%
)

echo ---- Install Data ----
xcopy /Y /s "data" "%INTEL_MPSS_HOST_MICPERF_DATA%" || set FAILED=%ERRORLEVEL%
if NOT %FAILED%==0 (
    echo "could not copy micp data, error %FAILED%"
    exit /b %FAILED%
)

echo ---- Install Tutorials ----
echo "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%"
xcopy /Y ".\micperf.sln" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%" || set FAILED=%ERRORLEVEL%


xcopy /Y ".\gemm\bench.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\getopt_win.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\cross_timer.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\utils.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\gemm\bench.c" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\getopt_win.c" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\main.c" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\utils.c" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\gemm\README.txt" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\redist.txt" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\gemm\dgemm_mic.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\dgemm_ofl.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\sgemm_mic.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\sgemm_ofl.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\gemm\dgemm_mic.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\dgemm_ofl.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\sgemm_mic.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\gemm\sgemm_ofl.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%gemm\" || set FAILED=%ERRORLEVEL%



::xcopy /Y ".\stream\*.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%stream\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\stream\stream.c" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%stream\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\stream\license_stream.txt" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%stream\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\stream\README.txt" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%stream\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\stream\stream_mic.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%stream\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\stream\stream_mic.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%stream\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\shoc\Option.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\OptionParser.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\ResultDatabase.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\cross_timer.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\Utility.h" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\shoc\main_mic.c" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedDownload_pragma.cpp" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedDownload_scif.cpp" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedReadback_pragma.cpp" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedReadback_scif.cpp" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\main.cpp" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\Option.cpp" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\OptionParser.cpp" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\ResultDatabase.cpp" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\shoc\license_shoc.txt" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%

xcopy /Y ".\shoc\BusSpeedDownload_pragma.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedDownload_scif.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedReadback_pragma.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedReadback_scif.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeed_mic.vcxproj" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%


xcopy /Y ".\shoc\BusSpeedDownload_pragma.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedDownload_scif.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedReadback_pragma.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeedReadback_scif.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%
xcopy /Y ".\shoc\BusSpeed_mic.vcxproj.filters" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%shoc\" || set FAILED=%ERRORLEVEL%


::xcopy /Y ".\docs\*.png" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%docs\" || set FAILED=%ERRORLEVEL%
::xcopy /Y ".\docs\*.bib" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%docs\" || set FAILED=%ERRORLEVEL%
::xcopy /Y ".\docs\*.tex" "%INTEL_MPSS_HOST_MICPERF_TUTORIAL%docs\" || set FAILED=%ERRORLEVEL%


if NOT %FAILED%==0  (
	echo "Could not copy tutorials, error %FAILED%"
	exit /b %FAILED%
)
:: Used to generate version.py here, but now we are doing it in the bit bake.  

echo "Completed Installation succesfully!"
