/*******************************************************************************
!   Copyright(C) 2011-2012 Intel Corporation. All Rights Reserved.
!
!   The source code, information  and  material ("Material") contained herein is
!   owned  by Intel Corporation or its suppliers or licensors, and title to such
!   Material remains  with Intel Corporation  or its suppliers or licensors. The
!   Material  contains proprietary information  of  Intel or  its  suppliers and
!   licensors. The  Material is protected by worldwide copyright laws and treaty
!   provisions. No  part  of  the  Material  may  be  used,  copied, reproduced,
!   modified, published, uploaded, posted, transmitted, distributed or disclosed
!   in any way  without Intel's  prior  express written  permission. No  license
!   under  any patent, copyright  or  other intellectual property rights  in the
!   Material  is  granted  to  or  conferred  upon  you,  either  expressly,  by
!   implication, inducement,  estoppel or  otherwise.  Any  license  under  such
!   intellectual  property  rights must  be express  and  approved  by  Intel in
!   writing.
!
!   *Third Party trademarks are the property of their respective owners.
!
!   Unless otherwise  agreed  by Intel  in writing, you may not remove  or alter
!   this  notice or  any other notice embedded  in Materials by Intel or Intel's
!   suppliers or licensors in any way.
!
!*******************************************************************************
!   Content:
!       Utility functions for SGEMM, DGEMM, CGEMM, ZGEMM benchmarks
!******************************************************************************/

#ifndef _UTILS_H_
#define _UTILS_H_

#include "mkl.h"

/* Precision-dependent types */
#if defined(SINGLE_PREC)
#define fptype_t float
#define fptype_mtx_t float
#define fptype_mtx_c_t float
#define larnv slarnv
#elif defined (DOUBLE_PREC)
#define fptype_t double
#define fptype_mtx_t double
#define fptype_mtx_c_t double
#define larnv dlarnv
#elif defined(COMPLEX)
#define fptype_t MKL_Complex8
#define fptype_mtx_t MKL_Complex8
#define fptype_mtx_c_t MKL_Complex8
#define larnv clarnv
#elif defined(INTEGER)
#define fptype_t float
#define fptype_mtx_t MKL_INT16
#define fptype_mtx_c_t MKL_INT32
#define larnv dlarnv
#else
#define fptype_t MKL_Complex16
#define larnv zlarnv
#endif

/* Memory allocation */
#ifndef KNL_SNC_MODE
void *bench_malloc(size_t size);
#else

#define MAX_KNL_NUMA_NODES 8
#define NUMA_DISTANCE_TO_MYSELF 10  // as defined by NUMA
struct numa_neighbour{
	int cpu_node;   /* NUMA node ID of a given numa node with more than 1 CPUs*/
        int hbw_node;   /* NUMA node ID of the closest HBW node to cpu_node */
};

void *bench_malloc(size_t size, int hbw_memory_numa_node);
int closer_numa_nodes(struct numa_neighbour *all_numa_neighbours);
int get_numa_nodes(int *cpu_nodes, size_t *num_cpu_nodes, int *hbw_nodes, size_t *num_hbw_nodes);

#endif

void bench_free(void *ptr, size_t size);

/* Fill matrix with random values */
void fill_matrix(fptype_mtx_t *A, size_t nelems);
void fill_matrix_c(fptype_mtx_c_t *A, size_t nelems);

#endif
