/*
 * Copyright 2012-2017 Intel Corporation.
 * 
 * This file is subject to the Intel Sample Source Code License. A copy
 * of the Intel Sample Source Code License is included.
*/

/*******************************************************************************/
/* BusSpeed scif mic listening server                                          */
/*                                                                             */
/* Authors:  Michael R. Carroll, Chris M. Cantalupo, Steve S. Sylvester        */
/*                                                                             */
/* Copyright: Intel Corporation 2011, 2012, 2013                               */
/*                                                                             */
/*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/mman.h>
#include <scif.h>
#include <string.h>

#define MAXIMUM_MEMORY_SIZE 1<<20

#define START_OFFSET 0x200000

#define SCIFBARRIER(epd, string) { \
        if ((err = scif_send(newepd, &control_msg, sizeof(control_msg), 1)) <= 0) { \
                printf("scif_send failed with err %d\n", err); \
                fflush(stdout); \
                goto close; \
        } \
        if ((err = scif_recv(newepd, &control_msg, sizeof(control_msg), 1)) <= 0) { \
                printf("scif_recv failed with err %d\n", err); \
                fflush(stdout); \
                goto close; \
        } \
}

struct window_info {
    void *self_addr; 
    void *vself_addr;
    off_t offset;
};





int
main (int argc, const char **argv)
{
    off_t offset;
    int err;
    portID_t portID;
    int epd;
    int req_pn = 3010;
    int con_pn;
    int newepd;
    int control_msg;
    int reps = 0;
    int i;
    
    struct window_info buffer;

    if ((epd = scif_open()) < 0) {
        printf("scif_open failed with error %d\n", errno);
        exit(1);
    }

    if ((con_pn = scif_bind(epd, req_pn)) < 0) {
        printf("scif_bind failed with error %d\n", errno);
        exit(2);
    }

    if ((scif_listen(epd, 16)) < 0) {
        printf("Listen ioctl failed with error %d\n", errno);
        exit(3);
    }

    portID.node = 0;
    portID.port = 3011;
    if (((scif_accept(epd, &portID, &newepd, ACCEPT_SYNC)) < 0) && (errno != EAGAIN)) {
        printf("scif_accept failed with errno %d\n", errno);
        exit(4);
    }

    int alloc_size = 1024 * MAXIMUM_MEMORY_SIZE;

    posix_memalign(&(buffer.self_addr), 0x200000, alloc_size);

    offset = START_OFFSET;

    buffer.offset = scif_register(newepd,
                    buffer.self_addr,
                    alloc_size,
                    offset,
                    PROT_READ | PROT_WRITE,
                    MAP_FIXED);

    if(buffer.offset < 1)
    {
        printf("scif_register buffer 0 failed with error: ");
        fflush(NULL);
        perror(NULL);
        goto close;
    }
    
    SCIFBARRIER(epd, "Server: Window Registered\n");

    err = scif_recv(newepd, &reps, sizeof(reps), 1);
    if (err < 0)
    {
        printf("error receiving repetition count\n");
        perror(NULL);
        goto close;
    }

    SCIFBARRIER(epd, "Server: Done\n");

close:

    free(buffer.self_addr);
    scif_close(newepd);
    scif_close(epd);

    return 0;
}
