# Copyright 2010-2017 Intel Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, version 2.1.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
# 
# Disclaimer: The codes contained in these modules may be specific
# to the Intel Software Development Platform codenamed Knights Ferry,
# and the Intel product codenamed Knights Corner, and are not backward
# compatible with other Intel products. Additionally, Intel will NOT
# support the codes or instruction set in future products.
# 
# Intel offers no warranty of any kind regarding the code. This code is
# licensed on an "AS IS" basis and Intel is not obligated to provide
# any support, assistance, installation, training, or other services
# of any kind. Intel is also not obligated to provide any updates,
# enhancements or extensions. Intel specifically disclaims any warranty
# of merchantability, non-infringement, fitness for any particular
# purpose, and any other warranty.
# 
# Further, Intel disclaims all liability of any kind, including but
# not limited to liability for infringement of any proprietary rights,
# relating to the use of the code, even if Intel is notified of the
# possibility of such liability. Except as expressly stated in an Intel
# license agreement provided with this code and agreed upon with Intel,
# no license, express or implied, by estoppel or otherwise, to any
# intellectual property rights is granted herein.

"""Factory to create objects to mock python's Popen for different
software and hardware configurations"""

import sys

import python_mocks
import data

# avaliable objects
NEG_LINUX_HOST_KNC_MICINFO_KNC_CARD = 'neg_linux_host_knc_knc'
LINUX_HOST_KNC_MICINFO_KNC_CARD = 'linux_host_knc_knc'
LINUX_HOST_KNL_MICINFO_KNC_CARD = 'linux_host_knl_knc'
LINUX_HOST_KNL_MICINFO_KNL_CARD = 'linux_host_knl_knl'
LINUX_HOST_NO_MICINFO_KNX_CARD = 'linux_host_no_knx'
WIN_HOST_KNC_MICINFO_KNC_CARD = 'win_host_knc_knc'
WIN_HOST_KNL_MICINFO_KNC_CARD = 'win_knl_knc'
WIN_HOST_KNL_MICINFO_KNL_CARD = 'win_knl_knl'
SB_HOST_VALID_INFO = 'valid_sb_host'
SB_HOST_INVALID_INFO = 'invalid_sb_host'


_OBJECT_ARGS = {}
_OBJECT_ARGS[NEG_LINUX_HOST_KNC_MICINFO_KNC_CARD] = \
        (data.INVALID, data.X86_HOST, data.LINUX_KNC_MICINFO_KNC_CARD)
_OBJECT_ARGS[LINUX_HOST_KNC_MICINFO_KNC_CARD] = \
        (data.VALID, data.X86_HOST, data.LINUX_KNC_MICINFO_KNC_CARD)
_OBJECT_ARGS[LINUX_HOST_KNL_MICINFO_KNC_CARD] = \
        (data.VALID, data.X86_HOST, data.LINUX_KNL_MICINFO_KNC_CARD)
_OBJECT_ARGS[LINUX_HOST_KNL_MICINFO_KNL_CARD] = \
        (data.VALID, data.X86_HOST, data.LINUX_KNL_MICINFO_KNL_CARD)
_OBJECT_ARGS[LINUX_HOST_NO_MICINFO_KNX_CARD] = \
        (data.VALID, data.X86_HOST, data.NO_MICINFO)
_OBJECT_ARGS[WIN_HOST_KNC_MICINFO_KNC_CARD] = \
        (data.VALID, data.X86_HOST, data.WIN_KNC_MICINFO_KNC_CARD)
#_OBJECTS_ARGS[WIN_HOST_KNL_MICINFO_KNC_CARD] = (data.VALID, data.X86_HOST,data.WIN_KNL_MICINFO_KNC_CARD)
#_OBJECTS_ARGS[WIN_HOST_KNL_MICINFO_KNL_CARD] = (data.VALID, data.X86_HOST, data.WIN_KNL_MICINFO_KNL_CARD)
_OBJECT_ARGS[SB_HOST_VALID_INFO] = \
        (data.VALID, data.SB_HOST, data.EMPTY_MICINFO)
_OBJECT_ARGS[SB_HOST_INVALID_INFO] = \
        (data.INVALID, data.SB_HOST, data.EMPTY_MICINFO)


def create(object_name, command):
    """factory receives the object's type (see constants defined in this
    module) and the command that would be passed to python's Popen()"""
    try:
        output_type, target, micinfo_type = _OBJECT_ARGS[object_name]
    except KeyError:
        sys.stderr.write('ERROR: Unknown object type {0}'.format(object_name))
        raise
    return python_mocks.Popen(command, output_type, target, micinfo_type)
