from .. import diag_power
import pytest
import pickle
import random
from ctypes import c_int

NUMBER_PROCESSORS_CROWNPASS = 48

diag_power.UNIT_TEST = True

############### CPU Info section #################

def mock_CPUInformation_init(self):
    self.cpu_info_so_file = ""
    self.cpu_info_lib = 0
    self.num_cpus = c_int(0)
    self.cpus_info = list()
    self.summary = diag_power.CPUInfoT()

def mock_get_cpu_info_data(self):
    """
    Create Mock info for the output of running the get_cpu_info function of the
    cpu-info library
    """
    self.num_cpus = c_int(272)
    self.cpus_info = list()
    self.summary = diag_power.CPUInfoT(0, 0, 0, 1500, 20, 25, 25.5, 1.5, 17.5, 0, 0)
    for i in range(0, self.num_cpus.value):
        c_t = 0
        p_t = 0
        p_e = 0
        r_e = 0
        c_e = 0
        f_c_p = 0
        f_c_c = 0
        if i == 0:
            p_t = 25
            p_e = 25.5
            r_e = 1.5
            f_c_p = 1
        if (i % 4) == 0:
            c_t = random.randint(15, 20)
            c_e = random.uniform(15,17.5)
            f_c_c = 1
        self.cpus_info.append(diag_power.CPUInfoT(i, (i / 4), 0, random.randint(1300, 1500), c_t, p_t, p_e, r_e, c_e, f_c_p, f_c_c))
    return 0

def mock_free_cpu_info_data(self):
    """
    Mock return success value from running the free_cpu_info function of the
    cpu-info library
    """
    return 0

def mock_get_cpu_info_data_fail(self):
    """
    Mock return failed value from running the get_cpu_info function of the
    cpu-info library
    """
    return 1

def mock_free_cpu_info_data_fail(self):
    """
    Mock return failed value from running the free_cpu_info function of the
    cpu-info library
    """
    return 1

def mock_get_cpu_info_data_load_fail(self):
    """
    Mock failed exception when trying to load cpu-info library
    """
    raise OSError("Error: cpu-info library not found.")

def test_cpu_info(monkeypatch):
    """ Test the 'Show CPU detailed information.' option
    """
    monkeypatch.setattr(diag_power.CPUInformation, "__init__", mock_CPUInformation_init)
    monkeypatch.setattr(diag_power.CPUInformation, "get_cpu_info_data", mock_get_cpu_info_data)
    monkeypatch.setattr(diag_power.CPUInformation, "free_cpu_info_data", mock_free_cpu_info_data)
    assert diag_power.test_cpu_info("") == 0

def test_cpu_info_show_power_consumption(monkeypatch):
    """ Test diag_power.CPUInformation.show_power_consumption().
    """
    monkeypatch.setattr(diag_power.CPUInformation, "__init__", mock_CPUInformation_init)
    monkeypatch.setattr(diag_power.CPUInformation, "get_cpu_info_data", mock_get_cpu_info_data)
    cpu_info = diag_power.CPUInformation()
    cpu_info.get_cpu_info_data()
    assert cpu_info.show_power_consumption()

def test_cpu_info_show_temp_core(monkeypatch):
    """ Test diag_power.CPUInformation.show_temperature_per_core().
    """
    monkeypatch.setattr(diag_power.CPUInformation, "__init__", mock_CPUInformation_init)
    monkeypatch.setattr(diag_power.CPUInformation, "get_cpu_info_data", mock_get_cpu_info_data)
    cpu_info = diag_power.CPUInformation()
    cpu_info.get_cpu_info_data()
    assert cpu_info.show_temperature_per_core()

def test_cpu_info_show_temp_package(monkeypatch):
    """ Test diag_power.CPUInformation.show_temperature_per_package().
    """
    monkeypatch.setattr(diag_power.CPUInformation, "__init__", mock_CPUInformation_init)
    monkeypatch.setattr(diag_power.CPUInformation, "get_cpu_info_data", mock_get_cpu_info_data)
    cpu_info = diag_power.CPUInformation()
    cpu_info.get_cpu_info_data()
    assert cpu_info.show_temperature_per_package()

def test_cpu_info_show_core_freq(monkeypatch):
    """ Test diag_power.CPUInformation.show_core_frequency().
    """
    monkeypatch.setattr(diag_power.CPUInformation, "__init__", mock_CPUInformation_init)
    monkeypatch.setattr(diag_power.CPUInformation, "get_cpu_info_data", mock_get_cpu_info_data)
    cpu_info = diag_power.CPUInformation()
    cpu_info.get_cpu_info_data()
    assert cpu_info.show_core_frequency()

def test_cpu_info_load_error(monkeypatch):
    """ Negative testing for a problem when loading the cpu-info.so library
    """
    monkeypatch.setattr(diag_power.CPUInformation, "__init__", mock_get_cpu_info_data_load_fail)
    assert diag_power.test_cpu_info("") == -3

def test_cpu_info_get_data_error(monkeypatch):
    """ Negative testing for a problem when getting the cpu data from the cpu-info.so library
    """
    monkeypatch.setattr(diag_power.CPUInformation, "__init__", mock_CPUInformation_init)
    monkeypatch.setattr(diag_power.CPUInformation, "get_cpu_info_data", mock_get_cpu_info_data_fail)
    assert diag_power.test_cpu_info("") == -2

def test_cpu_info_free_data_error(monkeypatch):
    """ Negative testing for a problem when freeing the cpu data from the cpu-info.so library
    """
    monkeypatch.setattr(diag_power.CPUInformation, "__init__", mock_CPUInformation_init)
    monkeypatch.setattr(diag_power.CPUInformation, "get_cpu_info_data", mock_get_cpu_info_data)
    monkeypatch.setattr(diag_power.CPUInformation, "free_cpu_info_data", mock_free_cpu_info_data_fail)
    assert diag_power.test_cpu_info("") == -2

############### Pstates section #################

class MockCPUPerformanceStates(object):
    def __init__(self):
        self.num_of_cores = NUMBER_PROCESSORS_CROWNPASS
        with open('core_pstates.pickle', 'r') as handler:
            self.core_pstate_info = pickle.load(handler)

        with open('pstates.pickle', 'r') as handler:
            self.pstates = pickle.load(handler)

    def print_pstates(self):
        return self.pstates

    def print_core_pstate_info(self):
        return self.core_pstate_info


class MockCPUPerformanceStatesOSError(object):
    def __init__(self):
        raise OSError


class MockCPUPerformanceStatesValueError(object):
    def __init__(self):
        raise ValueError


class MockDunnoError(object):
    def __init__(self):
        raise


def test_pstates(monkeypatch):
    """ run diag_power.test.p_states with a mock of CPUPerformanceStates.
    """
    monkeypatch.setattr(diag_power, "CPUPerformanceStates", MockCPUPerformanceStates)
    return_value = diag_power.test_pstates("empty")
    assert return_value == 0


def test_pstates_oserror(monkeypatch):
    """ run diag_power.test.p_states with a mock of CPUPerformanceStates.
    """
    monkeypatch.setattr(diag_power, "CPUPerformanceStates", MockCPUPerformanceStatesOSError)
    return_value = diag_power.test_pstates("empty")
    assert return_value == -1


def test_pstates_valuerror(monkeypatch):
    """ run diag_power.test.p_states with a mock of CPUPerformanceStates.
    """
    monkeypatch.setattr(diag_power, "CPUPerformanceStates", MockCPUPerformanceStatesValueError)
    return_value = diag_power.test_pstates("empty")
    assert return_value == -2


def test_pstates_noideaerror(monkeypatch):
    """ run diag_power.test.p_states with a mock of CPUPerformanceStates.
    """
    monkeypatch.setattr(diag_power, "CPUPerformanceStates", MockDunnoError)
    return_value = diag_power.test_pstates("empty")
    assert return_value == -3


def test_cpu_power_states():
    cpu_power_states = diag_power.CPUPerformanceStates()
    assert cpu_power_states.print_core_pstate_info() is None
    assert cpu_power_states.print_pstates() is None
