from .. import diag_system
import pytest

def raise_exc(inst):
    raise Exception

def test_sysm_info_exc(capfd, monkeypatch):
    diag_system.RUNNING_UT = True
    monkeypatch.setattr(diag_system.SystemInfo, "get_all", raise_exc)
    assert diag_system.dump_system_info(None) == 1

def test_sysm_info_valid(capfd):
    diag_system.RUNNING_UT = True
    assert diag_system.dump_system_info(None) == 0

def test_fabric(capfd, monkeypatch):
    diag_system.RUNNING_UT = True
    sys_info = diag_system.SystemInfo(None)
    sys_info.get_ifconfig_info()
    sys_info.get_lsmod_info()
    sys_info.get_mellanox_info()
    sys_info.get_opa_info()
