Summary: User Extensible Heap Manager
Name: xppsl-memkind
Version: 1.5.4
Release: 4478
License: BSD-2-Clause
Group: System Environment/Libraries
URL: http://memkind.github.io/memkind
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: automake libtool gcc-c++ unzip
%if %{defined suse_version}
BuildRequires: libnuma-devel
%else
BuildRequires: numactl-devel
%endif

Prefix: %{_prefix}
Prefix: %{_unitdir}
Obsoletes: memkind
Provides: memkind libmemkind0

%define namespace memkind

%if %{defined suse_version}
%define docdir %{_defaultdocdir}/%{namespace}
%else
%define docdir %{_defaultdocdir}/%{namespace}-%{version}
%endif

# x86_64 is the only arch memkind will build due to its
# current dependency on SSE4.2 CRC32 instruction which
# is used to compute thread local storage arena mappings
# with polynomial accumulations via GCC's intrinsic _mm_crc32_u64
# For further info check:
# - /lib/gcc/<target>/<version>/include/smmintrin.h
# - https://gcc.gnu.org/bugzilla/show_bug.cgi?id=36095
# - http://en.wikipedia.org/wiki/SSE4
ExclusiveArch: x86_64

# default values if version is a tagged release on github
%{!?commit: %define commit %{version}}
%{!?buildsubdir: %define buildsubdir %{namespace}-%{commit}}
Source0: https://github.com/%{namespace}/%{namespace}/archive/v%{commit}/%{buildsubdir}.tar.gz

%description
The memkind library is an user extensible heap manager built on top of
jemalloc which enables control of memory characteristics and a
partitioning of the heap between kinds of memory. The kinds of memory
are defined by operating system memory policies that have been applied
to virtual address ranges. Memory characteristics supported by
memkind without user extension include control of NUMA and page size
features. The jemalloc non-standard interface has been extended to
enable specialized arenas to make requests for virtual memory from the
operating system through the memkind partition interface. Through the
other memkind interfaces the user can control and extend memory
partition features and allocate memory while selecting enabled
features. This software is being made available for early evaluation.
Feedback on design or implementation is greatly appreciated.

%package devel
Summary: Memkind User Extensible Heap Manager development lib and tools
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Obsoletes: memkind-devel
Provides: memkind-devel

%description devel
Install header files and development aids to link memkind library into
applications.

%package tests
Summary: Extention to libnuma for kinds of memory - validation
Group: Validation/Libraries
Requires: %{name} = %{version}-%{release}

%description tests
memkind functional tests

%prep
%setup -q -a 0 -n xppsl-memkind-%{version}

%build
# It is required that we configure and build the jemalloc subdirectory
# before we configure and start building the top level memkind directory.
# To ensure the memkind build step is able to discover the output
# of the jemalloc build we must create an 'obj' directory, and build
# from within that directory.

cd %{_builddir}/%{buildsubdir}
echo %{version} > %{_builddir}/%{buildsubdir}/VERSION
./build.sh --prefix=%{_prefix} --includedir=%{_includedir} --libdir=%{_libdir} --bindir=%{_bindir} --docdir=%{_docdir}/%{namespace} --mandir=%{_mandir} --sbindir=%{_sbindir}

%install
cd %{_builddir}/%{buildsubdir}
%{__make} DESTDIR=%{buildroot} install
%{__install} -d %{buildroot}/usr/share/mpss/test/memkind-dt
%{__install} -d %{buildroot}/%{_unitdir}
%{__install} -d %{buildroot}//usr/share/mpss/test/memkind-dt/python_framework
%{__install} test/.libs/* test/*.sh test/*.ts test/*.py %{buildroot}/usr/share/mpss/test/memkind-dt
%{__install} test/python_framework/*.py %{buildroot}//usr/share/mpss/test/memkind-dt/python_framework
rm -f %{buildroot}/usr/share/mpss/test/memkind-dt/libautohbw.*
rm -f %{buildroot}/%{_libdir}/lib%{namespace}.{l,}a
rm -f %{buildroot}/%{_libdir}/libautohbw.{l,}a

%pre

%post
/sbin/ldconfig

%preun

%postun
/sbin/ldconfig

%files
%defattr(-,root,root,-)
%license %{_docdir}/%{namespace}/COPYING
%doc %{_docdir}/%{namespace}/README
%doc %{_docdir}/%{namespace}/VERSION
%dir %{_docdir}/%{namespace}
%{_libdir}/lib%{namespace}.so.*
%{_libdir}/libautohbw.so.*
%{_bindir}/%{namespace}-hbw-nodes

%define internal_include memkind/internal

%files devel
%defattr(-,root,root,-)
%{_includedir}
%{_includedir}/hbwmalloc.h
%{_includedir}/hbw_allocator.h
%{_libdir}/lib%{namespace}.so
%{_libdir}/libautohbw.so
%{_includedir}/%{namespace}.h
%{_includedir}/%{internal_include}
%{_includedir}/%{internal_include}/%{namespace}*.h
%{_mandir}/man3/hbwmalloc.3.*
%{_mandir}/man3/hbwallocator.3.*
%{_mandir}/man3/%{namespace}*.3.*

%exclude %{_includedir}/%{internal_include}/%{namespace}_log.h

%files tests
%defattr(-,root,root,-)
/usr/share/mpss/test/memkind-dt/all_tests
/usr/share/mpss/test/memkind-dt/bat_bind_tests
/usr/share/mpss/test/memkind-dt/environ_err_hbw_malloc_test
/usr/share/mpss/test/memkind-dt/decorator_test
/usr/share/mpss/test/memkind-dt/freeing_memory_segfault_test
/usr/share/mpss/test/memkind-dt/gb_page_tests_bind_policy
/usr/share/mpss/test/memkind-dt/gb_page_tests_preferred_policy
/usr/share/mpss/test/memkind-dt/filter_memkind
/usr/share/mpss/test/memkind-dt/hello_hbw
/usr/share/mpss/test/memkind-dt/hello_memkind
/usr/share/mpss/test/memkind-dt/hello_memkind_debug
/usr/share/mpss/test/memkind-dt/memkind_allocated
/usr/share/mpss/test/memkind-dt/autohbw_candidates
/usr/share/mpss/test/memkind-dt/pmem
/usr/share/mpss/test/memkind-dt/allocator_perf_tool_tests
/usr/share/mpss/test/memkind-dt/perf_tool
/usr/share/mpss/test/memkind-dt/autohbw_test_helper
/usr/share/mpss/test/memkind-dt/trace_mechanism_test_helper
/usr/share/mpss/test/memkind-dt/memkind-afts.ts
/usr/share/mpss/test/memkind-dt/memkind-afts-ext.ts
/usr/share/mpss/test/memkind-dt/memkind-slts.ts
/usr/share/mpss/test/memkind-dt/memkind-perf.ts
/usr/share/mpss/test/memkind-dt/memkind-perf-ext.ts
/usr/share/mpss/test/memkind-dt/memkind-pytests.ts
/usr/share/mpss/test/memkind-dt/check.sh
/usr/share/mpss/test/memkind-dt/test.sh
/usr/share/mpss/test/memkind-dt/hbw_detection_test.py
/usr/share/mpss/test/memkind-dt/autohbw_test.py
/usr/share/mpss/test/memkind-dt/trace_mechanism_test.py
/usr/share/mpss/test/memkind-dt/python_framework
/usr/share/mpss/test/memkind-dt/python_framework/cmd_helper.py
/usr/share/mpss/test/memkind-dt/python_framework/__init__.py
/usr/share/mpss/test/memkind-dt/draw_plots.py
/usr/share/mpss/test/memkind-dt/run_alloc_benchmark.sh
/usr/share/mpss/test/memkind-dt/alloc_benchmark_hbw
/usr/share/mpss/test/memkind-dt/alloc_benchmark_glibc
/usr/share/mpss/test/memkind-dt/alloc_benchmark_tbb

%exclude /usr/share/mpss/test/memkind-dt/*.pyo
%exclude /usr/share/mpss/test/memkind-dt/*.pyc
%exclude /usr/share/mpss/test/memkind-dt/python_framework/*.pyo
%exclude /usr/share/mpss/test/memkind-dt/python_framework/*.pyc

%changelog
