#
#  Copyright (2014) Intel Corporation All Rights Reserved.
#
#  This software is supplied under the terms of a license
#  agreement or nondisclosure agreement with Intel Corp.
#  and may not be copied or disclosed except in accordance
#  with the terms of that agreement.
#

# Overriding built-in __find_requires macro with filter_find_requires
# this works on both RHEL and SUSE
%define filter_find_requires %{_builddir}/%{?buildsubdir}/filter-requires.sh
%define _use_internal_dependency_generator 0
%define __find_requires %{filter_find_requires}

Summary: Performance benchmarks for the Intel(R) Xeon Phi(TM) X200 Processor.
Name: xppsl-micperf
Version: 1.5.4
Release: 4478
License: See LICENSE.txt
Group: Applications/Engineering
Vendor: Intel Corporation
URL: http://www.intel.com
Source0: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: numactl

%define debug_package %{nil}
%global __os_install_post %(echo '%{__os_install_post}' | sed -e %'s!/usr/lib[^[:space:]]*/brp-python-bytecompile[[:space:]].*$!!g')

%description
This software package provides users with industry standard benchmarks for
measuring the performance of the Intel(R) Xeon Phi(TM) X200 Processor.
In addition to providing compiled executable versions of the benchmarks,
there is also a Python automation infrastructure that will run the benchmarks
and provide analysis of the results. Some benchmark source code is provided.

%prep
%setup

%build
# shoc_download and shoc_readback are not supported on KNL SB remove before building micperf
rm %{_builddir}/%{buildsubdir}/micp/micp/kernels/shoc_download.py
rm %{_builddir}/%{buildsubdir}/micp/micp/kernels/shoc_readback.py
rm %{_builddir}/%{buildsubdir}/ut/micp_ut/micp_kernels_shoc_test.py

%{__make} VERSION=%{version} knlsb libexecdir=%{_libexecdir} datarootdir=%{_datarootdir}

%pre
test -d /usr/share/micperf/micp/micp/kernels && rmdir /usr/share/micperf/micp/micp/kernels || true
test -d /usr/share/micperf/micp/micp/kernels && rmdir /usr/share/micperf/micp/micp/ || true
test -d /usr/share/micperf/micp/ && rmdir /usr/share/micperf/micp/ || true

%install
%if %{defined suse_version}
%define docdir %{_defaultdocdir}/micperf
%else
%define docdir %{_defaultdocdir}/micperf-%{version}
%endif

%{__make} prefix=%{_prefix} libdir=%{_libdir} \
    includedir=%{_includedir} bindir=%{_bindir} \
    mandir=%{_mandir} docdir=%{docdir} \
    libexecdir=%{_libexecdir} DESTDIR=%{buildroot} \
    VERSION=%{version} srcinstalldir=%{_datarootdir}/micperf/ install-knlsb

%clean

%post

%preun

%postun

%files
%defattr(-,root,root,-)
%{_bindir}/micpinfo
%{_bindir}/micpcsv
%{_bindir}/micpprint
%{_bindir}/micpplot
%{_bindir}/micprun
%dir %{_libexecdir}/micperf/
%dir %{_libexecdir}/micperf/x86_64_AVX512/
%{_libexecdir}/micperf/x86_64_AVX512/stream
%{_libexecdir}/micperf/x86_64_AVX512/stream_mpi
%{_libexecdir}/micperf/x86_64_AVX512/dgemm_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/sgemm_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/sgemm_mcdram_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/dgemm_mcdram_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/sgemm_mpi_snc_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/dgemm_mpi_snc_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/layer_example_f32
%{_libexecdir}/micperf/x86_64_AVX512/std_conv_bench
%dir %{docdir}
%{docdir}/EULA
%{docdir}/user_guide.pdf
%{docdir}/LICENSE.txt
%{docdir}/README.txt
%{docdir}/license_stream.txt
%{docdir}/CHANGES.txt
%{docdir}/INSTALL.txt
%{docdir}/micperf_faqs.txt
%dir %{_datarootdir}/micperf/
%dir %{_datarootdir}/micperf/micp-%{version}/
%dir %{_datarootdir}/micperf/micp-%{version}/micp/
%dir %{_datarootdir}/micperf/micp-%{version}/micp/kernels/
%{_datarootdir}/micperf/micp
%{_datarootdir}/micperf/micp-%{version}/setup.py
%{_datarootdir}/micperf/micp-%{version}/micpinfo
%{_datarootdir}/micperf/micp-%{version}/LICENSE.txt
%{_datarootdir}/micperf/micp-%{version}/README.txt
%{_datarootdir}/micperf/micp-%{version}/micpcsv
%{_datarootdir}/micperf/micp-%{version}/CHANGES.txt
%{_datarootdir}/micperf/micp-%{version}/INSTALL.txt
%{_datarootdir}/micperf/micp-%{version}/micperf_faqs.txt
%{_datarootdir}/micperf/micp-%{version}/micpprint
%{_datarootdir}/micperf/micp-%{version}/micp/stats.py
%{_datarootdir}/micperf/micp-%{version}/micp/version.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernel.py
%{_datarootdir}/micperf/micp-%{version}/micp/__init__.py
%{_datarootdir}/micperf/micp-%{version}/micp/params.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/stream.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/dgemm.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/__init__.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/sgemm.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/linpack.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/hplinpack.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/hpcg.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/std_conv_bench.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/libxsmm_layer.py
%{_datarootdir}/micperf/micp-%{version}/micp/kernels/fio.py
%{_datarootdir}/micperf/micp-%{version}/micp/common.py
%{_datarootdir}/micperf/micp-%{version}/micp/info.py
%{_datarootdir}/micperf/micp-%{version}/micp/connect.py
%{_datarootdir}/micperf/micp-%{version}/micp/run.py
%{_datarootdir}/micperf/micp-%{version}/micp/offload.py
%{_datarootdir}/micperf/micp-%{version}/PKG-INFO
%{_datarootdir}/micperf/micp-%{version}/micpplot
%{_datarootdir}/micperf/micp-%{version}/micprun
%{_datarootdir}/micperf/micp-%{version}/INSTALL_WIN.txt
%dir %{_datarootdir}/micperf/data
%{_datarootdir}/micperf/data
%{_datarootdir}/micperf/data/README.txt
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7210_redhat-7.2_micperf-1.5.2_local_optimal.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7210_SuSE-12_micperf-1.5.2_local_optimal.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7230_redhat-7.2_micperf-1.5.2_local_optimal.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7230_SuSE-12_micperf-1.5.2_local_optimal.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7250_redhat-7.2_micperf-1.5.2_local_optimal.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7250_SuSE-12_micperf-1.5.2_local_optimal.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7210_redhat-7.2_micperf-1.5.2_local_scaling.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7210_SuSE-12_micperf-1.5.2_local_scaling.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7230_redhat-7.2_micperf-1.5.2_local_scaling.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7230_SuSE-12_micperf-1.5.2_local_scaling.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7250_redhat-7.2_micperf-1.5.2_local_scaling.pkl
%{_datarootdir}/micperf/data/micp_run_stats_mcdram_7250_SuSE-12_micperf-1.5.2_local_scaling.pkl
