#
#  Copyright (2014) Intel Corporation All Rights Reserved.
#
#  This software is supplied under the terms of a license
#  agreement or nondisclosure agreement with Intel Corp.
#  and may not be copied or disclosed except in accordance
#  with the terms of that agreement.
#

%global lname libhwloc5
%global xppsllname xppsl-%{lname}
%define sversion 1.11
Name:           %{name}
Version:        %{version}
Release:        %{release}
Summary:        Portable Hardware Locality
License:        BSD-3-Clause
Group:          Productivity/Clustering/Computing
Url:            http://www.open-mpi.org/projects/hwloc/
Source0:        %{name}-%{version}.tar.gz
Source1: test_hwloc-ft.py
Source2: hwloc-afts.ts
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  doxygen
BuildRequires:  fdupes
BuildRequires:  gcc-c++
BuildRequires:  libtool
BuildRequires:  ncurses-devel
BuildRequires:  w3m
BuildRequires:  cairo-devel
BuildRequires:  libxml2-devel
BuildRequires:  ncurses-devel
BuildRequires:  xorg-x11-libICE-devel
BuildRequires:  xorg-x11-libSM-devel
BuildRequires:  xorg-x11-libX11-devel
BuildRequires:  libnuma-devel
Requires:       %{xppsllname} >= %{version}-%{release}
Obsoletes: hwloc
Provides: hwloc

%description
The Portable Hardware Locality (hwloc) software package provides
a portable abstraction (across OS, versions, architectures, ...)
of the hierarchical topology of modern architectures, including
NUMA memory nodes,  shared caches, processor sockets, processor cores
and processing units (logical processors or "threads"). It also gathers
various system attributes such as cache and memory information. It primarily
aims at helping applications with gathering information about modern
computing hardware so as to exploit it accordingly and efficiently.

hwloc may display the topology in multiple convenient formats.
It also offers a powerful programming interface (C API) to gather information
about the hardware, bind processes, and much more.

%package lstopo
Summary:        Shows the topology in various formats
Group:          Productivity/Clustering/Computing
Obsoletes: lstopo
Provides: lstopo

%description lstopo
Lstopo shows the topology of the system in various formats.

%package devel
Summary:        Headers and shared development libraries for hwloc
Group:          Development/Libraries/C and C++
Requires:       %{xppsllname} >= %{version}
Obsoletes:      libhwloc-devel
Provides:       libhwloc-devel = %{version}-%{release}

%description devel
Headers and shared object symbolic links for the hwloc.

%package -n %{xppsllname}
Summary:        Run time libraries for the hwloc
Group:          System/Libraries
Requires:       hwloc-data
Obsoletes: 		%{lname}
Provides: 		%{lname}

%description -n %{xppsllname}
Run time libraries for the %{name}.

%package data
Summary:        Run time data for hwloc
Group:          Development/Libraries/C and C++
Obsoletes: hwloc-data
Provides: hwloc-data

%description data
Run time data for the hwloc.

%package sbin
Summary: Hwloc sbin files
Group: Development/Libraries
Requires: %{xppsllname} >= %{version}-%{release}
Obsoletes: %{name}-init
%{?systemd_requires}

%description sbin
Hwloc sbin files to read root privileged hardware data.

%package doc
Summary:        Documentation for hwloc
Group:          Documentation/Other
Obsoletes: hwloc-doc
Provides: hwloc-doc

%description doc
Package contains documentation for hwloc.

%package tests
Summary:Portable Hardware Locality Tests
Requires: %{xppsllname} >= %{version}-%{release}
Requires: %{name}-lstopo >= %{version}-%{release}

%description tests
The Portable Hardware Locality Tests (hwloc-tests) software package provides
the test included in the hwloc repo.

%prep
%setup -q -D -c -T -a 0

%build
autoreconf --force --install
sed -i "s;(LN_S) lstopo-no-graphics;(LN_S) lstopo;g" utils/lstopo/Makefile.in
%configure
##sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
##sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
make all %{?_smp_mflags} V=1

# call make check to build tests, ignore tests results for now.
# the build will fail at later stage when test build fail.
%{__make} check %{?_smp_mflags} ||

%install
make install DESTDIR=%{buildroot} INSTALL="%{__install} -p"
#evil stuff need to check autotools for installing systemd service
%{__install} -d %{buildroot}/%{_unitdir}
#move unit file from datadir to unitdir.
%{__mv} %{buildroot}/%{_datadir}/hwloc/hwloc-dump-hwdata.service %{buildroot}/%{_unitdir}/hwloc-dump-hwdata.service
# We don't ship .la files.
# And netloc
%{__rm} -f %{buildroot}%{_datadir}/applications/lstopo.desktop
%{__rm} -f %{buildroot}%{_libdir}/libhwloc.la

# documentation will be handled by % doc macro
rm -rf %{buildroot}%{_datadir}/doc/
%fdupes -s %{buildroot}/%{_mandir}/man1
%fdupes -s %{buildroot}/%{_mandir}/man3
%fdupes -s %{buildroot}/%{_mandir}/man7
%fdupes -s doc/doxygen-doc

install -d %{buildroot}%{test_destdir}/usr/bin/
install -m755 %{_topdir}/BUILD/%{name}-%{version}/tests/.libs/* %{buildroot}%{test_destdir}/usr/bin/
install -m755 %{SOURCE1} %{buildroot}%{test_destdir}/test_hwloc-ft.py
install -m666 %{SOURCE2} %{buildroot}%{test_destdir}/hwloc-afts.ts

#replace lstopo with system lstopo
sed -i 's|lstopo=.*|lstopo=\"%{_bindir}/lstopo-no-graphics\"|' %{_topdir}/BUILD/%{name}-%{version}/tests/linux/test-topology.sh
#replace source dir
sed -i "s|HWLOC_top_srcdir=.*|HWLOC_top_srcdir=\"%{test_destdir}\"|" %{_topdir}/BUILD/%{name}-%{version}/tests/linux/test-topology.sh
rm -rf %{_topdir}/BUILD/%{name}-%{version}/tests/linux/gather
install -m755 %{_topdir}/BUILD/%{name}-%{version}/tests/linux/test-topology.sh %{buildroot}%{test_destdir}/usr/bin/test-topology.sh
rm -f test-topology.sh*
mkdir -p %{buildroot}%{test_destdir}/tests/linux
install -m666 -D %{_topdir}/BUILD/%{name}-%{version}/tests/linux/* %{buildroot}%{test_destdir}/tests/linux/

%check
#XXX: this is weird, but make check got broken by removing doxygen-doc/man above
#     the only one fix is to install documentation by hand, or to ignore check error
#make %{?_smp_mflags} check || :

%post -n %{xppsllname} -p /sbin/ldconfig

%postun -n %{xppsllname} -p /sbin/ldconfig

%pre sbin
%{service_add_pre hwloc-dump-hwdata.service}

%post sbin
%{service_add_post hwloc-dump-hwdata.service}
systemctl enable hwloc-dump-hwdata.service

%preun sbin
%{service_del_preun hwloc-dump-hwdata.service}

%postun sbin
systemctl disable hwloc-dump-hwdata.service
%{service_del_postun hwloc-dump-hwdata.service}

%files
%defattr(-, root, root, -)
%doc AUTHORS COPYING NEWS README VERSION
%doc %{_mandir}/man1/hwloc*
%{_bindir}/hwloc*

%files lstopo
%defattr(-,root,root)
%{_bindir}/lstopo*
%doc %{_mandir}/man1/lstopo.1*
%doc %{_mandir}/man1/lstopo-no-graphics.1.*

%files devel
%defattr(-, root, root, -)
%doc %{_mandir}/man3/*
%doc %{_mandir}/man7/hwloc*
%{_includedir}/hwloc
%{_includedir}/hwloc.h
%{_libdir}/libhwloc.so
%{_libdir}/pkgconfig/hwloc.pc

%files -n %{xppsllname}
%defattr(-, root, root, -)
%{_libdir}/libhwloc*so.*

%files data
%defattr(-, root, root, -)
%dir %{_datadir}/hwloc
%{_datadir}/hwloc/hwloc.dtd
%{_datadir}/hwloc/hwloc-valgrind.supp

%files sbin
%defattr(-, root, root, -)
%{_sbindir}/hwloc-dump-hwdata
%{_unitdir}/hwloc-dump-hwdata.service

%files doc
%defattr(-, root, root, -)
%doc doc/

%files tests
%defattr(-, root, root, -)
%attr(0755,root,root) %{test_destdir}

%changelog
