Summary:   Portable Hardware Locality - portable abstraction of hierarchical architectures
Name:      hwloc
Version:   1.11.5+xpps
Release:   %{?release}%{!?release:1}
License:   BSD
Group:     Applications/System
URL:       http://www.open-mpi.org/projects/hwloc
Source0: %{name}-%{version}.tar.gz
Source1: test_hwloc-ft.py
Source2: hwloc-afts.ts
Requires:  %{name}-libs >= %{version}-%{release}
Obsoletes: xppsl-hwloc
Provides: hwloc

BuildRequires: libX11-devel libxml2-devel cairo-devel ncurses-devel libpciaccess-devel libtool-ltdl-devel autoconf automake libtool
BuildRequires: libibverbs-devel

%if %{undefined suse_version}
BuildRequires: numactl-devel
%endif

%description
The Portable Hardware Locality (hwloc) software package provides
a portable abstraction (across OS, versions, architectures, ...)
of the hierarchical topology of modern architectures, including
NUMA memory nodes,  shared caches, processor sockets, processor cores
and processing units (logical processors or "threads"). It also gathers
various system attributes such as cache and memory information. It primarily
aims at helping applications with gathering information about modern
computing hardware so as to exploit it accordingly and efficiently.

hwloc may display the topology in multiple convenient formats.
It also offers a powerful programming interface (C API) to gather information
about the hardware, bind processes, and much more.

%package devel
Summary:   Headers and shared development libraries for hwloc
Group:     Development/Libraries
Requires:  %{name}-libs >= %{version}-%{release}
Obsoletes: xppsl-hwloc-devel
Provides: hwloc-devel

%description devel
Headers and shared object symbolic links for the hwloc.

%package libs
Summary:   Run time libraries for the hwloc
Group:     Development/Libraries
Obsoletes: xppsl-hwloc-libs
Provides: hwloc-libs

%description libs
Run time libraries for the hwloc

%package gui
Summary:   The gui-based hwloc program(s)
Group:     Development/Libraries
Requires:  %{name}-libs >= %{version}-%{release}
Obsoletes: xppsl-hwloc-gui
Provides: hwloc-gui

%description gui
GUI-based tool for displaying system topology information.

%package sbin
Summary: Hwloc sbin files
Group: Development/Libraries
Requires: %{name}-libs >= %{version}-%{release}
Obsoletes: xppsl-hwloc-sbin
%{?systemd_requires}

%description sbin
Hwloc sbin files to read root privileged hardware data.

%package tests
Summary:Portable Hardware Locality Tests
Requires: %{name}-libs >= %{version}-%{release}
Requires: %{name}-gui >= %{version}-%{release}

%description tests
The Portable Hardware Locality Tests (hwloc-tests) software package provides
the test included in the hwloc repo.

%prep
%setup -q

%build
autoreconf --force --install
%configure --docdir=%{_defaultdocdir}/hwloc

##sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
##sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%{__make} all %{?_smp_mflags} V=1

# call make check to build tests, ignore tests results for now.
# the build will fail at later stage when test build fail.
%{__make} check %{?_smp_mflags} ||

%install
%{__make} install DESTDIR=%{buildroot} INSTALL="%{__install} -p"
#Fix wrong permition on file hwloc-assembler-remote => I have reported this to upstream already
#%{__chmod} 0755 %{buildroot}%{_bindir}/hwloc-assembler-remote

# We don't ship .la files.
# and desktop link
%{__rm} -f %{buildroot}%{_datadir}/applications/lstopo.desktop
%{__rm} -f %{buildroot}%{_libdir}/libhwloc.la

#%{__mkdir} -p %{buildroot}%{_docdir}/hwloc-%{version}
%{__mv} %{buildroot}%{_defaultdocdir}/hwloc %{buildroot}%{_defaultdocdir}/hwloc-%{version}
%{__cp} -p AUTHORS COPYING NEWS README VERSION %{buildroot}%{_defaultdocdir}/hwloc-%{version}
%{__cp} -p doc/examples/hwloc-hello.c %{buildroot}%{_defaultdocdir}/hwloc-%{version}

%{__mkdir} -p %{buildroot}/%{_unitdir}
#move unit file from datadir to unitdir
%{__mv} %{buildroot}/%{_datadir}/hwloc/hwloc-dump-hwdata.service %{buildroot}/%{_unitdir}/hwloc-dump-hwdata.service

install -d %{buildroot}%{test_destdir}/usr/bin/
install -m755 %{_topdir}/BUILD/%{name}-%{version}/tests/.libs/* %{buildroot}%{test_destdir}/usr/bin/
install -m755 %{SOURCE1} %{buildroot}%{test_destdir}/test_hwloc-ft.py
install -m666 %{SOURCE2} %{buildroot}%{test_destdir}/hwloc-afts.ts
#replace lstopo with system lstopo
sed -i 's|lstopo=.*|lstopo=\"%{_bindir}/lstopo-no-graphics\"|' %{_topdir}/BUILD/%{name}-%{version}/tests/linux/test-topology.sh
#replace source dir
sed -i "s|HWLOC_top_srcdir=.*|HWLOC_top_srcdir=\"%{test_destdir}\"|" %{_topdir}/BUILD/%{name}-%{version}/tests/linux/test-topology.sh
rm -rf %{_topdir}/BUILD/%{name}-%{version}/tests/linux/gather
install -m755 %{_topdir}/BUILD/%{name}-%{version}/tests/linux/test-topology.sh %{buildroot}%{test_destdir}/usr/bin/test-topology.sh
rm -f test-topology.sh*
mkdir -p %{buildroot}%{test_destdir}/tests/linux
install -m666 -D %{_topdir}/BUILD/%{name}-%{version}/tests/linux/* %{buildroot}%{test_destdir}/tests/linux/


%check
#%{__make} check

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%pre sbin
%post sbin
%systemd_post hwloc-dump-hwdata.service
systemctl enable hwloc-dump-hwdata.service
%preun sbin
%systemd_preun hwloc-dump-hwdata.service
%postun sbin
systemctl disable hwloc-dump-hwdata.service
%systemd_postun hwloc-dump-hwdata.service

%files
%defattr(-, root, root, -)
%{_bindir}/hwloc*
%{_bindir}/lstopo-no-graphics
%{_mandir}/man1/hwloc*
%{_mandir}/man1/lstopo-no-graphics*

%files devel
%defattr(-, root, root, -)
%{_libdir}/pkgconfig/*
%{_mandir}/man3/*
%dir %{_includedir}/hwloc
%{_includedir}/hwloc/*
%{_includedir}/hwloc.h
%{_docdir}/hwloc-%{version}/*c
%{_libdir}/*.so

%files libs
%defattr(-, root, root, -)
%{_mandir}/man7/hwloc*
%dir %{_datadir}/hwloc
%{_datadir}/hwloc/hwloc.dtd
%{_datadir}/hwloc/hwloc-valgrind.supp
%dir %{_docdir}/hwloc-%{version}
%{_docdir}/hwloc-%{version}/*[^c]
%{_libdir}/libhwloc*so.*

%files gui
%defattr(-, root, root, -)
%{_bindir}/lstopo
%{_mandir}/man1/lstopo.*

%files sbin
%defattr(-, root, root, -)
%{_sbindir}/hwloc-dump-hwdata
%{_unitdir}/hwloc-dump-hwdata.service

%files tests
%defattr(-, root, root, -)
%attr(0755,root,root) %{test_destdir}

%changelog
