#
#  Copyright (2017) Intel Corporation All Rights Reserved.
#
#  This software is supplied under the terms of a license
#  agreement or nondisclosure agreement with Intel Corp.
#  and may not be copied or disclosed except in accordance
#  with the terms of that agreement.
#

# Overriding built-in __find_requires macro with filter_find_requires
# this works on both RHEL and SUSE
%define filter_find_requires %{_builddir}/%{?buildsubdir}/filter-requires.sh
%define _use_internal_dependency_generator 0
%define __find_requires %{filter_find_requires}

Summary: Performance benchmarks for the Intel(R) Xeon Phi(TM) X200 Processor.
Name:    micperf
Version: 2.3.0+xpps
Release: %{?release}%{!?release:1}
License: See LICENSE.txt
Group: Applications/Engineering
Vendor: Intel Corporation
URL: http://www.intel.com
Source0: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: numactl
Prefix: %{_prefix}
Provides: micperf
Obsoletes: xppsl-micperf xppsm-micperf

%description
This software package provides users with industry standard benchmarks for
measuring the performance of the Intel(R) Xeon Phi(TM) X200 Processor.
In addition to providing compiled executable versions of the benchmarks,
there is also a Python automation infrastructure that will run the benchmarks
and provide analysis of the results. Some benchmark source code is provided.

%define debug_package %{nil}

%define docdir %{_defaultdocdir}/micperf

%prep
%setup -q

%build
%{__make} VERSION=%{version} knlsb libexecdir=%{_libexecdir} datarootdir=%{_datarootdir}

%install
%{__make} prefix=%{_prefix} libdir=%{_libdir} \
    includedir=%{_includedir} bindir=%{_bindir} \
    mandir=%{_mandir} docdir=%{docdir} \
    libexecdir=%{_libexecdir} DESTDIR=%{buildroot} \
    VERSION=%{version} install-knlsb

%if 0%{?suse_version}
%py_compile %{buildroot}
%py_compile -O %{buildroot}
%endif

%files
%defattr(-,root,root,-)
%{_bindir}/micpcsv
%{_bindir}/micpinfo
%{_bindir}/micpplot
%{_bindir}/micpprint
%{_bindir}/micprun

%dir %{_libexecdir}/micperf/
%dir %{_libexecdir}/micperf/x86_64_AVX512/
%{_libexecdir}/micperf/x86_64_AVX512/*gemm_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/*gemm_mcdram_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/*gemm_mpi_snc_cpu.x
%{_libexecdir}/micperf/x86_64_AVX512/layer_example_f32
%{_libexecdir}/micperf/x86_64_AVX512/std_conv_bench
%{_libexecdir}/micperf/x86_64_AVX512/stream
%{_libexecdir}/micperf/x86_64_AVX512/stream_mpi

%dir %{docdir}
%doc %{docdir}/EULA
%doc %{docdir}/INSTALL.txt
%doc %{docdir}/license_stream.txt
%doc %{docdir}/LICENSE.txt
%doc %{docdir}/micperf_faqs.txt
%doc %{docdir}/README.txt
%doc %{docdir}/micperf_users_guide.pdf

%dir %{_datarootdir}/micperf/
%dir %{_datarootdir}/micperf/micp/
%{_datarootdir}/micperf/micp/micpcsv
%{_datarootdir}/micperf/micp/micpinfo
%{_datarootdir}/micperf/micp/micpplot
%{_datarootdir}/micperf/micp/micpprint
%{_datarootdir}/micperf/micp/micprun
%{_datarootdir}/micperf/micp/setup.py
%{_datarootdir}/micperf/micp/setup.py?
%{_datarootdir}/micperf/micp/virsh-kvm-xeon-phi

%dir %{_datarootdir}/micperf/micp/micp/
%{_datarootdir}/micperf/micp/micp/common.py
%{_datarootdir}/micperf/micp/micp/common.py?
%{_datarootdir}/micperf/micp/micp/connect.py
%{_datarootdir}/micperf/micp/micp/connect.py?
%{_datarootdir}/micperf/micp/micp/info.py
%{_datarootdir}/micperf/micp/micp/info.py?
%{_datarootdir}/micperf/micp/micp/__init__.py
%{_datarootdir}/micperf/micp/micp/__init__.py?
%{_datarootdir}/micperf/micp/micp/kernel.py
%{_datarootdir}/micperf/micp/micp/kernel.py?
%{_datarootdir}/micperf/micp/micp/offload.py
%{_datarootdir}/micperf/micp/micp/offload.py?
%{_datarootdir}/micperf/micp/micp/params.py
%{_datarootdir}/micperf/micp/micp/params.py?
%{_datarootdir}/micperf/micp/micp/run.py
%{_datarootdir}/micperf/micp/micp/run.py?
%{_datarootdir}/micperf/micp/micp/stats.py
%{_datarootdir}/micperf/micp/micp/stats.py?
%{_datarootdir}/micperf/micp/micp/version.py
%{_datarootdir}/micperf/micp/micp/version.py?

%dir %{_datarootdir}/micperf/micp/micp/kernels/
%{_datarootdir}/micperf/micp/micp/kernels/fio.py
%{_datarootdir}/micperf/micp/micp/kernels/fio.py?
%{_datarootdir}/micperf/micp/micp/kernels/*gemm.py
%{_datarootdir}/micperf/micp/micp/kernels/*gemm.py?
%{_datarootdir}/micperf/micp/micp/kernels/hpcg.py
%{_datarootdir}/micperf/micp/micp/kernels/hpcg.py?
%{_datarootdir}/micperf/micp/micp/kernels/hplinpack.py
%{_datarootdir}/micperf/micp/micp/kernels/hplinpack.py?
%{_datarootdir}/micperf/micp/micp/kernels/__init__.py
%{_datarootdir}/micperf/micp/micp/kernels/__init__.py?
%{_datarootdir}/micperf/micp/micp/kernels/libxsmm_conv.py
%{_datarootdir}/micperf/micp/micp/kernels/libxsmm_conv.py?
%{_datarootdir}/micperf/micp/micp/kernels/linpack.py
%{_datarootdir}/micperf/micp/micp/kernels/linpack.py?
%{_datarootdir}/micperf/micp/micp/kernels/mkl_conv.py
%{_datarootdir}/micperf/micp/micp/kernels/mkl_conv.py?
%{_datarootdir}/micperf/micp/micp/kernels/stream.py
%{_datarootdir}/micperf/micp/micp/kernels/stream.py?

%dir %{_datarootdir}/micperf/data
%{_datarootdir}/micperf/data/README.txt
%{_datarootdir}/micperf/data/*.pkl

%changelog

