/*******************************************************************************
!   Copyright(C) 2011-2012 Intel Corporation. All Rights Reserved.
!
!   The source code, information  and  material ("Material") contained herein is
!   owned  by Intel Corporation or its suppliers or licensors, and title to such
!   Material remains  with Intel Corporation  or its suppliers or licensors. The
!   Material  contains proprietary information  of  Intel or  its  suppliers and
!   licensors. The  Material is protected by worldwide copyright laws and treaty
!   provisions. No  part  of  the  Material  may  be  used,  copied, reproduced,
!   modified, published, uploaded, posted, transmitted, distributed or disclosed
!   in any way  without Intel's  prior  express written  permission. No  license
!   under  any patent, copyright  or  other intellectual property rights  in the
!   Material  is  granted  to  or  conferred  upon  you,  either  expressly,  by
!   implication, inducement,  estoppel or  otherwise.  Any  license  under  such
!   intellectual  property  rights must  be express  and  approved  by  Intel in
!   writing.
!
!   *Third Party trademarks are the property of their respective owners.
!
!   Unless otherwise  agreed  by Intel  in writing, you may not remove  or alter
!   this  notice or  any other notice embedded  in Materials by Intel or Intel's
!   suppliers or licensors in any way.
!
!*******************************************************************************
!   Content:
!       Some common definitions for SGEMM, DGEMM, CGEMM, ZGEMM benchmarks
!******************************************************************************/

#ifndef _BENCH_H_
#define _BENCH_H_

#include "utils.h"

/* The default benhcmark parameters */
#define DEF_FIRST_IND 512
#define DEF_STEP 512
#define DEF_MIN_NITERS 4
#define DEF_MIN_T 3.0
#define DEF_COPROCESSOR 0
#define DEF_NUM_THREADS -1
#define THREADS_PER_CORE 4

/* Precision-dependent last indices for the default problem sets */
#if defined(SINGLE_PREC)
#define DEF_LAST_IND 16384
#elif defined (DOUBLE_PREC)
#define DEF_LAST_IND 10240
#elif defined(COMPLEX)
#define DEF_LAST_IND 10240
#else
#define DEF_LAST_IND 8192
#endif

/* Maximum index size allowed */
#define MAX_ALLOWED_IND 163840

/* Precision-dependent benchmarking functions */
#if defined(SINGLE_PREC)
#define xgemm sgemm
#elif defined (DOUBLE_PREC)
#define xgemm dgemm
#elif defined(COMPLEX)
#define xgemm cgemm
#else
#define xgemm zgemm
#endif

/* Initialize the benchmarking driver: allocate memory, fill matrices, etc */
#ifndef KNL_SNC_MODE
void initialize_bench(int firstInd, int lastInd, int step,
		int num_threads, const char transa, const char transb);
#else
void initialize_bench(int firstInd, int lastInd, int step,
			int num_threads, const char transa, const char transb,
			int hbw_memory_numa_node, int rank, int world_size);

int is_bench_initialized();
#endif

/* Finalize the benchmarking driver: free memory, etc */
void finalize_bench();

/* Run the benchmark driver: call xGEMM and return its execution time */
double xgemm_bench(char transa, char transb,
		int M, int N, int K, fptype_t alpha, fptype_t beta);

#endif

