/*
 * Copyright 2012-2017 Intel Corporation.
 * 
 * This file is subject to the Intel Sample Source Code License. A copy
 * of the Intel Sample Source Code License is included.
*/


// cross_timer.h
//
// Platform independent timer macros
//
//
// Maintainter: Michael R. Carroll
// michael dot r dot carroll at intel dot com

#ifndef CROSS_TIMER_H
#define CROSS_TIMER_H
#ifdef __cplusplus
extern "C" {
#endif
#ifndef _WIN32


#include <stdlib.h>
#include <time.h>
typedef struct timespec cross_timer_t;
static inline double cross_timer_diff(cross_timer_t timeStart, cross_timer_t timeStop)
{
    return (double)(timeStop.tv_sec - timeStart.tv_sec) +
           (double)(timeStop.tv_nsec - timeStart.tv_nsec) * 1e-9;
}

static inline int cross_timer_sample(cross_timer_t *time)
{
    return clock_gettime(CLOCK_REALTIME, time);
}


#else


#include <Windows.h>
typedef LARGE_INTEGER cross_timer_t;
static __inline double cross_timer_diff(cross_timer_t timeStart, cross_timer_t timeStop)
{
    LARGE_INTEGER timePerfFreq;
    QueryPerformanceFrequency(&timePerfFreq);
    return (double)(timeStop.QuadPart - timeStart.QuadPart) /
           (double)(timePerfFreq.QuadPart);
}

static __inline int cross_timer_sample(cross_timer_t *time)
{
    return QueryPerformanceCounter(time);
}


#endif
#ifdef __cplusplus
}
#endif
#endif
