std_conv_bench_out_good = ''' FWD Convolution
W=48, H=48, C=1, N=16, K=16, R=3, S=3 | FWD w/ padding in flops min(ms) 2.14; max(gflop/s) 4.95;avg(ms) 2.17; avg(gflop/s) 4.88;
 BWD_F Convolution
W=48, H=48, C=1, N=16, K=16, R=3, S=3 | BWD_F w/ padding in flops min(ms) 2.28; max(gflop/s) 4.67;avg(ms) 2.31; avg(gflop/s) 4.60;
 BWD_D Convolution
W=48, H=48, C=1, N=16, K=16, R=3, S=3 | BWD_D w/ padding in flops min(ms) 7.49; max(gflop/s) 1.42;avg(ms) 7.57; avg(gflop/s) 1.40;'''

std_conv_bench_out_good_desc = "W=48, H=48, C=1, N=16, K=16, R=3, S=3"

std_conv_bench_out_good_perf = {}
std_conv_bench_out_good_perf['Computation.Avg.BWD_D'] = {'value':'1.40', 'units':'GFlops', 'rollup':True}
std_conv_bench_out_good_perf['Computation.Avg.BWD_F'] = {'value':'4.60', 'units':'GFlops', 'rollup':True}
std_conv_bench_out_good_perf['Computation.Avg.FWD'] = {'value':'4.88', 'units':'GFlops', 'rollup':True}

libxsmm_layer_out_good = '''##########################################
#          Setting Up (Common)           #
##########################################
PARAMS: W:7  H:7  N:16  C:832  K:128  R:5  S:5  P:7  Q:7  STRIDE:1
PARAMS: ITERS:100  Threads:68
 InImg 7x7 Padded (7x7)
OutImg 7x7 Padded (7x7)
SIZE Input  (MB):       2.49 MiB
SIZE Output (MB):       0.38 MiB
SIZE Input   (1):       0.16 MiB
SIZE Output  (1):       0.02 MiB
SIZE Weight     :      10.16 MiB
##########################################
#         Computing Reference ...        #
##########################################
##########################################
#      Computing Reference ... done      #
##########################################

##########################################
#      Setting Up  (custom-Storage)      #
##########################################
##########################################
#   Correctness - FWD (custom-Storage)   #
##########################################
             1-norm of reference: 7.998677
              1-norm of JIT-code: 7.998661
       L2-error-norm of JIT-code: 0.000062
    inf-norm of comp. rel. error: 0.609274
    inf-norm of comp. abs. error: 0.000002
##########################################
#   Correctness - BWD (custom-Storage)   #
##########################################
             1-norm of reference: 2.563039
              1-norm of JIT-code: 2.563094
       L2-error-norm of JIT-code: 0.000024
    inf-norm of comp. rel. error: 31.766355
    inf-norm of comp. abs. error: 0.000000
##########################################
#   Correctness - UPD (custom-Storage)   #
##########################################
             1-norm of reference: -30.270126
              1-norm of JIT-code: -30.270086
       L2-error-norm of JIT-code: 0.000041
    inf-norm of comp. rel. error: 1.797117
    inf-norm of comp. abs. error: 0.000000
##########################################
#   Performance - FWD (custom-Storage)   #
##########################################
GFLOP  = 4.1746
fp time = 0.0018381
GFLOPS  = 2271.2
PERFDUMP,FP,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.0018381,2271.2,0.609274,0.000002,0.000062,7.998677,7.998661
##########################################
#   Performance - BWD (custom-Storage)   #
##########################################
GFLOP  = 4.1746
bp time = 0.0024684
GFLOPS  = 1691.2
PERFDUMP,BP,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.0024684,1691.2,31.766355,0.000000,0.000024,2.563039,2.563094
##########################################
#   Performance - UPD (custom-Storage)   #
##########################################
GFLOP  = 4.1746
wu time = 0.0014938
GFLOPS  = 2794.7
PERFDUMP,WU,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.0014938,2794.7,1.797117,0.000000,0.000041,-30.270126,-30.270086

##########################################
#    Setting Up - (NHWC/RSCK-Storage)    #
##########################################
##########################################
#  Correctness - FWD (NHWC/RSCK-Storage) #
##########################################
             1-norm of reference: 7.998677
              1-norm of JIT-code: 7.998661
       L2-error-norm of JIT-code: 0.000062
    inf-norm of comp. rel. error: 0.609274
    inf-norm of comp. abs. error: 0.000002
##########################################
# Correctness - BWD (NHWC/RSCK-Storage)  #
##########################################
             1-norm of reference: 2.563039
              1-norm of JIT-code: 2.563044
       L2-error-norm of JIT-code: 0.000024
    inf-norm of comp. rel. error: 63.136607
    inf-norm of comp. abs. error: 0.000000
##########################################
# Correctness - UPD (NHWC/RSCK-Storage)  #
##########################################
             1-norm of reference: -30.270126
              1-norm of JIT-code: -30.270153
       L2-error-norm of JIT-code: 0.000041
    inf-norm of comp. rel. error: 2.481935
    inf-norm of comp. abs. error: 0.000000
##########################################
#  Performance - FWD (NHWC/RSCK-Storage) #
##########################################
GFLOP (NHWC,RSCK)  = 4.1746
fp time (NHWC,RSCK) = 0.0025334
GFLOPS (NHWC,RSCK) = 1647.9
PERFDUMP-NHWC-RSCK,FP,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.0025334,1647.9,0.609274,0.000002,0.000062,7.998677,7.998661
##########################################
#  Performance - BWD (NHWC/RSCK-Storage) #
##########################################
GFLOP (NHWC,RSCK)  = 4.1746
fp time (NHWC,RSCK) = 0.029839
GFLOPS (NHWC,RSCK) = 139.91
PERFDUMP-NHWC-RSCK,BP,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.029839,139.91,63.136607,0.000000,0.000024,2.563039,2.563044
##########################################
#  Performance - UPD (NHWC/RSCK-Storage) #
##########################################
GFLOP (NHWC,RSCK)  = 4.1746
fp time (NHWC,RSCK) = 0.0092587
GFLOPS (NHWC,RSCK) = 450.89
PERFDUMP-NHWC-RSCK,WU,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.0092587,450.89,2.481935,0.000000,0.000041,-30.270126,-30.270153

##########################################
#   Setting Up - (NHWC/custom-Storage)   #
##########################################
##########################################
# Correctness - FWD(NHWC/custom-Storage) #
##########################################
             1-norm of reference: 7.998677
              1-norm of JIT-code: 7.998661
       L2-error-norm of JIT-code: 0.000062
    inf-norm of comp. rel. error: 0.609274
    inf-norm of comp. abs. error: 0.000002
##########################################
# Correctness - BWD(NHWC/custom-Storage) #
##########################################
             1-norm of reference: 2.563039
              1-norm of JIT-code: 2.563044
       L2-error-norm of JIT-code: 0.000024
    inf-norm of comp. rel. error: 63.136607
    inf-norm of comp. abs. error: 0.000000
##########################################
# Correctness - UPD(NHWC/custom-Storage) #
##########################################
             1-norm of reference: -30.270126
              1-norm of JIT-code: -30.270153
       L2-error-norm of JIT-code: 0.000041
    inf-norm of comp. rel. error: 2.481935
    inf-norm of comp. abs. error: 0.000000
##########################################
# Performance - FWD(NHWC/custom-Storage) #
##########################################
GFLOP (NHWC,custom)  = 4.1746
fp time (NHWC,custom) = 0.0018631
GFLOPS (NHWC,custom) = 2240.7
PERFDUMP-NHWC-custom,FP,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.0018631,2240.7,0.609274,0.000002,0.000062,7.998677,7.998661
##########################################
# Performance - BWD(NHWC/custom-Storage) #
##########################################
GFLOP (NHWC,custom)  = 4.1746
fp time (NHWC,custom) = 0.0054192
GFLOPS (NHWC,custom) = 770.34
PERFDUMP-NHWC-custom,BP,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.0054192,770.34,63.136607,0.000000,0.000024,2.563039,2.563044
##########################################
# Performance - UPD(NHWC/custom-Storage) #
##########################################
GFLOP (NHWC,custom)  = 4.1746
fp time (NHWC,custom) = 0.0083403
GFLOPS (NHWC,custom) = 500.54
PERFDUMP-NHWC-custom,WU,1.7.1-36,68,16,832,128,7,7,5,5,1,2,0.0083403,500.54,2.481935,0.000000,0.000041,-30.270126,-30.270153'''

libxsmm_layer_out_good_desc = '''W=7 H=7 C=832 N=16 K=128 R=5 S=5'''

libxsmm_layer_out_good_perf = {}

libxsmm_layer_out_good_perf['Computation.Avg.NHWC/RSCK-Storage.BWD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 139.91}
libxsmm_layer_out_good_perf['Computation.Avg.NHWC/RSCK-Storage.FWD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 1647.9}
libxsmm_layer_out_good_perf['Computation.Avg.NHWC/RSCK-Storage.UPD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 450.89}
libxsmm_layer_out_good_perf['Computation.Avg.NHWC/custom-Storage.BWD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 770.34}
libxsmm_layer_out_good_perf['Computation.Avg.NHWC/custom-Storage.FWD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 2240.7}
libxsmm_layer_out_good_perf['Computation.Avg.NHWC/custom-Storage.UPD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 500.54}
libxsmm_layer_out_good_perf['Computation.Avg.custom-Storage.BWD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 1691.2}
libxsmm_layer_out_good_perf['Computation.Avg.custom-Storage.FWD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 2271.2}
libxsmm_layer_out_good_perf['Computation.Avg.custom-Storage.UPD'] = \
        {'rollup': True, 'units': 'GFlops', 'value': 2794.7}

fio_out_good_1 = """{
  "fio version" : "fio-2.18",
  "timestamp" : 1491292060,
  "timestamp_ms" : 1491292060088,
  "time" : "Tue Apr  4 03:47:40 2017",
  "global options" : {
    "iodepth" : "32",
    "direct" : "1",
    "size" : "1MB",
    "description" : "/dev/sda6",
    "filename" : "/dev/sda6"
  },
  "jobs" : [
    {
      "jobname" : "Read-4k-bw",
      "groupid" : 0,
      "error" : 0,
      "eta" : 2147483647,
      "elapsed" : 1,
      "job options" : {
        "rw" : "read",
        "bs" : "4k"
      },
      "read" : {
        "io_bytes" : 10240,
        "bw" : 19883,
        "iops" : 4970.873786,
        "runtime" : 515,
        "total_ios" : 2560,
        "short_ios" : 0,
        "drop_ios" : 0,
        "slat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.000000,
          "stddev" : 0.000000
        },
        "clat" : {
          "min" : 108,
          "max" : 191096,
          "mean" : 1273.121875,
          "stddev" : 6566.354918,
          "percentile" : {
            "1.000000" : 114,
            "5.000000" : 227,
            "10.000000" : 318,
            "20.000000" : 442,
            "30.000000" : 548,
            "40.000000" : 652,
            "50.000000" : 724,
            "60.000000" : 780,
            "70.000000" : 860,
            "80.000000" : 924,
            "90.000000" : 1192,
            "95.000000" : 1432,
            "99.000000" : 9280,
            "99.500000" : 43776,
            "99.900000" : 83456,
            "99.950000" : 89600,
            "99.990000" : 191488,
            "0.00" : 0,
            "0.00" : 0,
            "0.00" : 0
          }
        },
        "lat" : {
          "min" : 108,
          "max" : 191097,
          "mean" : 1274.418359,
          "stddev" : 6566.421998
        },
        "bw_min" : 0,
        "bw_max" : 0,
        "bw_agg" : 0.000000,
        "bw_mean" : 0.000000,
        "bw_dev" : 0.000000
      },
      "write" : {
        "io_bytes" : 0,
        "bw" : 0,
        "iops" : 0.000000,
        "runtime" : 0,
        "total_ios" : 0,
        "short_ios" : 0,
        "drop_ios" : 0,
        "slat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.000000,
          "stddev" : 0.000000
        },
        "clat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.000000,
          "stddev" : 0.000000,
          "percentile" : {
            "1.000000" : 0,
            "5.000000" : 0,
            "10.000000" : 0,
            "20.000000" : 0,
            "30.000000" : 0,
            "40.000000" : 0,
            "50.000000" : 0,
            "60.000000" : 0,
            "70.000000" : 0,
            "80.000000" : 0,
            "90.000000" : 0,
            "95.000000" : 0,
            "99.000000" : 0,
            "99.500000" : 0,
            "99.900000" : 0,
            "99.950000" : 0,
            "99.990000" : 0,
            "0.00" : 0,
            "0.00" : 0,
            "0.00" : 0
          }
        },
        "lat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.000000,
          "stddev" : 0.000000
        },
        "bw_min" : 0,
        "bw_max" : 0,
        "bw_agg" : 0.000000,
        "bw_mean" : 0.000000,
        "bw_dev" : 0.000000
      },
      "trim" : {
        "io_bytes" : 0,
        "bw" : 0,
        "iops" : 0.000000,
        "runtime" : 0,
        "total_ios" : 0,
        "short_ios" : 0,
        "drop_ios" : 0,
        "slat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.000000,
          "stddev" : 0.000000
        },
        "clat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.000000,
          "stddev" : 0.000000,
          "percentile" : {
            "1.000000" : 0,
            "5.000000" : 0,
            "10.000000" : 0,
            "20.000000" : 0,
            "30.000000" : 0,
            "40.000000" : 0,
            "50.000000" : 0,
            "60.000000" : 0,
            "70.000000" : 0,
            "80.000000" : 0,
            "90.000000" : 0,
            "95.000000" : 0,
            "99.000000" : 0,
            "99.500000" : 0,
            "99.900000" : 0,
            "99.950000" : 0,
            "99.990000" : 0,
            "0.00" : 0,
            "0.00" : 0,
            "0.00" : 0
          }
        },
        "lat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.000000,
          "stddev" : 0.000000
        },
        "bw_min" : 0,
        "bw_max" : 0,
        "bw_agg" : 0.000000,
        "bw_mean" : 0.000000,
        "bw_dev" : 0.000000
      },
      "usr_cpu" : 1.375943,
      "sys_cpu" : 13.027075,
      "ctx" : 2758,
      "majf" : 0,
      "minf" : 35,
      "iodepth_level" : {
        "1" : 100.000000,
        "2" : 0.000000,
        "4" : 0.000000,
        "8" : 0.000000,
        "16" : 0.000000,
        "32" : 0.000000,
        ">=64" : 0.000000
      },
      "latency_us" : {
        "2" : 0.000000,
        "4" : 0.000000,
        "10" : 0.000000,
        "20" : 0.000000,
        "50" : 0.000000,
        "100" : 0.000000,
        "250" : 6.640625,
        "500" : 18.789062,
        "750" : 30.039062,
        "1000" : 29.648438
      },
      "latency_ms" : {
        "2" : 12.343750,
        "4" : 0.820312,
        "10" : 0.781250,
        "20" : 0.312500,
        "50" : 0.195312,
        "100" : 0.390625,
        "250" : 0.039062,
        "500" : 0.000000,
        "750" : 0.000000,
        "1000" : 0.000000,
        "2000" : 0.000000,
        ">=2000" : 0.000000
      },
      "latency_depth" : 32,
      "latency_target" : 0,
      "latency_percentile" : 100.000000,
      "latency_window" : 0,
      "desc" : "Test of paralell read from multiple files"
    }
  ],
  "disk_util" : [
    {
      "name" : "sda",
      "read_ios" : 1826,
      "write_ios" : 28,
      "read_merges" : 70,
      "write_merges" : 7,
      "read_ticks" : 2102,
      "write_ticks" : 118,
      "in_queue" : 2423,
      "util" : 75.959596
    }
  ]
}"""

fio_out_good_desc_1 = """fio-2.18; Test of paralell read from multiple files; total size: 10240 kB"""

fio_out_good_perf_1 = {}
fio_out_good_perf_1['Computation.Avg'] = {'rollup': True, 'units': 'kB/s', 'value': 19883}

fio_out_good_2 = """{
  "fio version" : "fio-2.2.7",
  "timestamp" : 1491311082,
  "time" : "Tue Apr  4 09:04:42 2017",
  "jobs" : [
    {
      "jobname" : "Read-4k-bw",
      "groupid" : 0,
      "error" : 0,
      "read" : {
        "io_bytes" : 20240,
        "bw" : 21113,
        "iops" : 5278.35,
        "runtime" : 485,
        "total_ios" : 2560,
        "short_ios" : 0,
        "drop_ios" : 0,
        "slat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.00,
          "stddev" : 0.00
        },
        "clat" : {
          "min" : 215,
          "max" : 32966,
          "mean" : 1005.92,
          "stddev" : 2398.12,
          "percentile" : {
            "1.000000" : 494,
            "5.000000" : 612,
            "10.000000" : 636,
            "20.000000" : 652,
            "30.000000" : 668,
            "40.000000" : 684,
            "50.000000" : 700,
            "60.000000" : 716,
            "70.000000" : 748,
            "80.000000" : 836,
            "90.000000" : 980,
            "95.000000" : 1192,
            "99.000000" : 15424,
            "99.500000" : 20096,
            "99.900000" : 31360,
            "99.950000" : 31872,
            "99.990000" : 33024,
            "0.00" : 0,
            "0.00" : 0,
            "0.00" : 0
          }
        },
        "lat" : {
          "min" : 216,
          "max" : 32968,
          "mean" : 1006.96,
          "stddev" : 2398.15
        },
        "bw_min" : 0,
        "bw_max" : 0,
        "bw_agg" : 0.00,
        "bw_mean" : 0.00,
        "bw_dev" : 0.00
      },
      "write" : {
        "io_bytes" : 0,
        "bw" : 0,
        "iops" : 0.00,
        "runtime" : 0,
        "total_ios" : 0,
        "short_ios" : 0,
        "drop_ios" : 0,
        "slat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.00,
          "stddev" : 0.00
        },
        "clat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.00,
          "stddev" : 0.00,
          "percentile" : {
            "1.000000" : 0,
            "5.000000" : 0,
            "10.000000" : 0,
            "20.000000" : 0,
            "30.000000" : 0,
            "40.000000" : 0,
            "50.000000" : 0,
            "60.000000" : 0,
            "70.000000" : 0,
            "80.000000" : 0,
            "90.000000" : 0,
            "95.000000" : 0,
            "99.000000" : 0,
            "99.500000" : 0,
            "99.900000" : 0,
            "99.950000" : 0,
            "99.990000" : 0,
            "0.00" : 0,
            "0.00" : 0,
            "0.00" : 0
          }
        },
        "lat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.00,
          "stddev" : 0.00
        },
        "bw_min" : 0,
        "bw_max" : 0,
        "bw_agg" : 0.00,
        "bw_mean" : 0.00,
        "bw_dev" : 0.00
      },
      "trim" : {
        "io_bytes" : 0,
        "bw" : 0,
        "iops" : 0.00,
        "runtime" : 0,
        "total_ios" : 0,
        "short_ios" : 0,
        "drop_ios" : 0,
        "slat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.00,
          "stddev" : 0.00
        },
        "clat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.00,
          "stddev" : 0.00,
          "percentile" : {
            "1.000000" : 0,
            "5.000000" : 0,
            "10.000000" : 0,
            "20.000000" : 0,
            "30.000000" : 0,
            "40.000000" : 0,
            "50.000000" : 0,
            "60.000000" : 0,
            "70.000000" : 0,
            "80.000000" : 0,
            "90.000000" : 0,
            "95.000000" : 0,
            "99.000000" : 0,
            "99.500000" : 0,
            "99.900000" : 0,
            "99.950000" : 0,
            "99.990000" : 0,
            "0.00" : 0,
            "0.00" : 0,
            "0.00" : 0
          }
        },
        "lat" : {
          "min" : 0,
          "max" : 0,
          "mean" : 0.00,
          "stddev" : 0.00
        },
        "bw_min" : 0,
        "bw_max" : 0,
        "bw_agg" : 0.00,
        "bw_mean" : 0.00,
        "bw_dev" : 0.00
      },
      "usr_cpu" : 0.76,
      "sys_cpu" : 27.04,
      "ctx" : 2753,
      "majf" : 0,
      "minf" : 33,
      "iodepth_level" : {
        "1" : 100.00,
        "2" : 0.00,
        "4" : 0.00,
        "8" : 0.00,
        "16" : 0.00,
        "32" : 0.00,
        ">=64" : 0.00
      },
      "latency_us" : {
        "2" : 0.00,
        "4" : 0.00,
        "10" : 0.00,
        "20" : 0.00,
        "50" : 0.00,
        "100" : 0.00,
        "250" : 0.08,
        "500" : 0.94,
        "750" : 70.47,
        "1000" : 19.65
      },
      "latency_ms" : {
        "2" : 7.38,
        "4" : 0.31,
        "10" : 0.00,
        "20" : 0.43,
        "50" : 0.74,
        "100" : 0.00,
        "250" : 0.00,
        "500" : 0.00,
        "750" : 0.00,
        "1000" : 0.00,
        "2000" : 0.00,
        ">=2000" : 0.00
      },
      "latency_depth" : 32,
      "latency_target" : 0,
      "latency_percentile" : 100.00,
      "latency_window" : 0,
      "desc" : "Test of paralell read from multiple files"
    }
  ],
  "disk_util" : [
    {
      "name" : "sda",
      "read_ios" : 1247,
      "write_ios" : 29,
      "read_merges" : 0,
      "write_merges" : 3,
      "read_ticks" : 1588,
      "write_ticks" : 237,
      "in_queue" : 1854,
      "util" : 79.03
    }
  ]
}"""

fio_out_good_desc_2 = """fio-2.2.7; Test of paralell read from multiple files; total size: 20240 kB"""

fio_out_good_perf_2 = {}
fio_out_good_perf_2['Computation.Avg'] = {'rollup': True, 'units': 'kB/s', 'value': 21113}
