%define version this_version
%define release this_release
Vendor:        lsi
Name:          megaraid_sas
BuildRequires: kernel-source kernel-syms
License:       GPL
Group:         System/Kernel
Summary:       LSI Megaraid_sas Kernel Module Package
Version:       %{version}
Release:       %{release}
Source0:       %name-%version.tar.bz2
BuildRoot:     %{_tmppath}/{%name}-%{version}-build

%suse_kernel_module_package kdump um

%description
This is a Kernel Module Package for the LSI Megaraid_SAS driver.

%package KMP
Summary: LSI Megaraid_SAS Driver Module
Group: System/Kernel

%description KMP
This is a Kernel Module Package for the LSI Megaraid_SAS  driver.

%prep
%setup
set -- *
mkdir source
mv "$@" source/
mkdir obj

%build
export EXTRA_CFLAGS='-DVERSION=\"%version\"'
for flavor in %flavors_to_build; do
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	make -C /usr/src/linux-obj/%_target_cpu/$flavor modules \
	M=$PWD/obj/$flavor
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules_install \
         M=$PWD/obj/$flavor
done

%changelog -n %name
