# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2018, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  updatefru.nsh  - FRU fix

#  Abstract:  UEFI Script file for invoking system software updates.

# + ============================================================== +
#    
# + ============================================================== +

cls

load ipmi.efi > NUL

echo Reading current data from FRU area.
cmdtool.efi 20 28 11 0A 00 00 70 > fullFRU.txt
Grepx64.efi fullFRU.txt "00 70 " fru.txt 335 > NUL
echo cmdtool.efi 20 28 12 0A 00 00 %grepvalue1% > restore.nsh
echo %grepvalue1% > FRU.old

# FRUTEST
Echo Checking board to determine if fix is required.
cmdtool.efi 20 28 11 0A 20 00 0B > currentfru.txt
comp currentfru.txt Grantleyfrusig.ref 
if %lasterror% == 0 then

echo Signature match.  Required FRU update beginning.

# start at offset 0b save 3 bytes SAVE Date
cmdtool.efi 20 28 11 0A 0B 00 03 > Date.txt
Grepx64.efi date.txt "00 03 " temp.txt 9 > NUL
set -v date %grepvalue1%

# start at offset 2e save 0Ch bytes Board Serial Number
cmdtool.efi 20 28 11 0A 2E 00 0C > SN.txt
Grepx64.efi SN.txt "00 0C " temp.txt 36 > NUL
set -v SN %grepvalue1%

# start at offset 3b save 0Ah bytes SAVE IPN
cmdtool.efi 20 28 11 0A 3b 00 0A > IPN.txt
GrepX64.efi IPN.txt "00 0A " temp.txt 30 > NUL
set -v IPN %grepvalue1%

# start at offset 48 save 0Ch bytes SAVE OEM1 field
cmdtool.efi 20 28 11 0A 48 00 0C > OEM1.txt
GrepX64.efi oem1.txt "00 0c " temp.txt 36 > NUL
set -v OEM1 %grepvalue1%

# start at offset 55 save 0Ah bytes OEM2 Field
cmdtool.efi 20 28 11 0A 55 00 0A > OEM2.txt
GrepX64.efi oem2.txt "00 0a " temp.txt 30 > NUL
set -v OEM2 %grepvalue1%

# start at offset 67 save 01h byte crc Field
cmdtool.efi 20 28 11 0A 67 00 01 > crc.txt
GrepX64.efi crc.txt "00 01 " temp.txt 3 > NUL
set -v crc %grepvalue1%

# Repairing FRU
del update.nsh > NUL
echo Writing NEW FRU format and restoring data.
echo cmdtool.efi 20 28 12 0A 00 00 01 00 00 01 00 00 00 FE 01 0B 00 > update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 0b 00 %date% >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 0e 00 D1 49 6E 74 65 6C 20 43 6F 72 70 6F 72 61 74 69 6F 6E >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 20 00 C9 52 4D 53 33 56 43 31 36 30 CC >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 2b 00 %SN% >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 37 00 CA >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 38 00 %IPN% >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 42 00 C0 CC >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 44 00 %OEM1% >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 50 00 CA >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 51 00 %OEM2% >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 5b 00 C1 00 00 FB >> update.nsh
echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 5F 00 %crc% >> update.nsh
echo echo . >> update.nsh
update.nsh

echo Fru updating is complete.

cmdtool.efi 20 28 11 0A 00 00 60 > finishFRU.txt
Grepx64.efi finishFRU.txt "00 60 " fru.txt 287 > NUL
echo %grepvalue1% > FRU.new

goto END
endif

echo The Current FRU indicates an update is not required.

:END
# cleanup
del *.txt > NUL
echo Please remove USB drive and restart your system.