# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2018, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  updatefru.nsh  - FRU fix

#  Abstract:  UEFI Script file for invoking system software updates.

# + ============================================================== +
#    
# + ============================================================== +

cls

load ipmi.efi > NUL

echo Reading current data from FRU area.
cmdtool.efi 20 28 11 0A 00 00 70 > fullFRU.txt
Grepx64.efi fullFRU.txt "00 70 " fru.txt 335 > NUL
echo cmdtool.efi 20 28 12 0A 00 00 %GREPVALUE1% > restore.nsh
echo %GREPVALUE1% > FRU.old

# FRUTEST
echo Checking board to determine if fix is required.
cmdtool.efi 20 28 11 0A 20 00 0B > currentfru.txt
comp currentfru.txt Purfrusig.ref 
if %lasterror% == 0 then

echo Signature match.  Required FRU update beginning.

# start at offset 0b save 3 bytes SAVE Date
cmdtool.efi 20 28 11 0A 0B 00 03 > Date.txt
Grepx64.efi date.txt "00 03 " temp.txt 9 > NUL
set -v date "%GREPVALUE1%"

# start at offset 2e save 06h bytes Board Serial Number
cmdtool.efi 20 28 11 0A 2E 00 06 > SN1.txt
Grepx64.efi SN1.txt "00 06 " temp.txt 18 > NUL
set -v SN1 "%GREPVALUE1%"

# start at offset 2e save 06h bytes Board Serial Number
cmdtool.efi 20 28 11 0A 34 00 06 > SN2.txt
Grepx64.efi SN2.txt "00 06 " temp.txt 18 > NUL
set -v SN2 "%GREPVALUE1%"

# start at offset 3b save 05h bytes SAVE IPN1
cmdtool.efi 20 28 11 0A 3b 00 05 > IPN1.txt
GrepX64.efi IPN1.txt "00 05 " temp.txt 15 > NUL
set -v IPN1 "%GREPVALUE1%"

# start at offset 40 save 05h bytes SAVE IPN2
cmdtool.efi 20 28 11 0A 40 00 05 > IPN2.txt
GrepX64.efi IPN2.txt "00 05 " temp.txt 15 > NUL
set -v IPN2 "%GREPVALUE1%"

# start at offset 48 save 06h bytes SAVE OEM11 field
cmdtool.efi 20 28 11 0A 48 00 06 > OEM11.txt
GrepX64.efi oem11.txt "00 06 " temp.txt 18 > NUL
set -v OEM11 "%GREPVALUE1%"

# start at offset 4E save 06h bytes SAVE OEM12 field
cmdtool.efi 20 28 11 0A 4E 00 06 > OEM12.txt
GrepX64.efi oem12.txt "00 06 " temp.txt 18 > NUL
set -v OEM12 "%GREPVALUE1%"

# start at offset 55 save 05h bytes OEM21 Field
cmdtool.efi 20 28 11 0A 55 00 05 > OEM21.txt
GrepX64.efi oem21.txt "00 05 " temp.txt 15 > NUL
set -v OEM21 "%GREPVALUE1%"

# start at offset 5A save 05h bytes OEM22 Field
cmdtool.efi 20 28 11 0A 5A 00 05 > OEM22.txt
GrepX64.efi oem22.txt "00 05 " temp.txt 15 > NUL
set -v OEM22 "%GREPVALUE1%"

# start at offset 67 save 01h byte crc Field
cmdtool.efi 20 28 11 0A 67 00 01 > crc.txt
GrepX64.efi crc.txt "00 01 " temp.txt 3 > NUL
set -v crc "%GREPVALUE1%"

# Repairing FRU 
del update.nsh > NUL
echo Writing NEW FRU format and restoring data.
echo cmdtool.efi 20 28 12 0A 00 00 01 00 00 01 00 00 00 FE  > update.nsh
echo cmdtool.efi 20 28 12 0A 00 08 01 0B 00 > update.nsh
echo cmdtool.efi 20 28 11 0A 00 00 08 >> update.nsh
echo cmdtool.efi 20 28 11 0A 00 08 03 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 0B 00 %date% D1 49 >> update.nsh
echo cmdtool.efi 20 28 11 0A 0B 00 05 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 10 00 6E 74 65 6C 20 43 6F 72 >> update.nsh
echo cmdtool.efi 20 28 12 0A 18 00 70 6F 72 61 74 69 6F 6E >> update.nsh
echo cmdtool.efi 20 28 11 0A 10 00 08 >> update.nsh
echo cmdtool.efi 20 28 11 0A 18 00 08 >> update.nsh


echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 20 00 C9 52 4D 53 33 56 43 31 >> update.nsh
echo cmdtool.efi 20 28 12 0A 28 00 36 30 CC >> update.nsh
echo cmdtool.efi 20 28 11 0A 20 00 08 >> update.nsh
echo cmdtool.efi 20 28 11 0A 28 00 03 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 2B 00 %SN1% >> update.nsh
echo cmdtool.efi 20 28 11 0A 2B 00 06 >> update.nsh
echo cmdtool.efi 20 28 12 0A 31 00 %SN2% >> update.nsh
echo cmdtool.efi 20 28 11 0A 31 00 06 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 37 00 CA >> update.nsh
echo cmdtool.efi 20 28 11 0A 37 00 01 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 37 00 CA %IPN1% >> update.nsh
echo cmdtool.efi 20 28 11 0A 37 00 05 >> update.nsh
echo cmdtool.efi 20 28 12 0A 3D 00 CA %IPN2% >> update.nsh
echo cmdtool.efi 20 28 11 0A 3D 00 05 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 42 00 C0 CC >> update.nsh
echo cmdtool.efi 20 28 11 0A 42 00 02 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 44 00 %OEM11% >> update.nsh
echo cmdtool.efi 20 28 11 0A 44 00 06 >> update.nsh
echo cmdtool.efi 20 28 12 0A 4A 00 %OEM12% >> update.nsh
echo cmdtool.efi 20 28 11 0A 4A 00 06 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 50 00 CA >> update.nsh
echo cmdtool.efi 20 28 11 0A 50 00 01 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 51 00 %OEM21% >> update.nsh
echo cmdtool.efi 20 28 11 0A 51 00 05 >> update.nsh
echo cmdtool.efi 20 28 12 0A 56 00 %OEM22% >> update.nsh
echo cmdtool.efi 20 28 11 0A 56 00 05 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 5B 00 C1 00 00 FB >> update.nsh
echo cmdtool.efi 20 28 11 0A 5B 00 04 >> update.nsh

echo echo . >> update.nsh
echo cmdtool.efi 20 28 12 0A 5F 00 %crc% >> update.nsh
echo cmdtool.efi 20 28 11 0A 5F 00 01 >> update.nsh

echo echo . >> update.nsh
update.nsh

cmdtool.efi 20 28 11 0A 00 00 60 > finishFRU.txt
Grepx64.efi finishFRU.txt "00 60 " fru.txt 287 > NUL
echo %GREPVALUE1% > FRU.new

echo Fru update process is complete.
echo Verifying new FRU.

cmdtool.efi 20 28 11 0A 20 00 08 > frustart.txt
comp frustart.txt Purfrustart.ref 
if %lasterror% == 1B then
  echo FRU did not update correctly.  Restoring to previous FRU
  restore.nsh
  goto SKIPCLEANUP
  endif

echo Fru heading verified.

goto END
endif


echo The Current FRU indicates an update is not required.


:END
# cleanup
del *.txt > NUL

:SKIPCLEANUP
echo Please remove USB drive and restart your system.