@echo off
cls
REM # B057 update script
REM # Update.bat $
REM #

REM # Pass in device name from arg
set dn=%~1
set mf="B010"

REM # Print device name to screen
REM #echo.
REM #echo "%dn%"

REM # Check minimum firmware level is on expander
sg_inq "%dn%" | findstr %mf% >NUL

if %errorlevel% equ 0 (
	echo.
	echo "The expander doesn't meet the minimum firmware version required."
	echo "Flash the expander firmware up to B011 before updating any further"
	goto :eof
)

REM # Update firmware
echo Updating expander firmware...
echo.
storcli -adpsetprop exposeEnclDevicesEnbl 1 -aall > NULL
call fw_tool2.bat --fw_update ..\..\binary\firmware_image.bin "%dn%"
TIMEOUT 10 /NOBREAK
call sg_ses.exe --page=0x04 --control --data=02,02 "%dn%" 
storcli -adpsetprop exposeEnclDevicesEnbl 0 -aall > NULL
REM # Power cycle expander after firmware update
REM # echo.
REM # echo "Power cycle the expander or JBOD"

:eof
