
%if "%dist" >= ".el7"
%define with_systemd 1
%define install_target systemd
%else
%define with_systemd 0
%define install_target no_systemd
%endif

Summary: Intel (R) VCA Management Daemon

%if "%dist" == ".el7.centos"
Name: daemon-vca
%else
Name: daemon-vca%dist
%endif
Version: %{_version}
Release: 0
License: See COPYING
Group: base
Vendor: Intel Corporation
URL: http://www.intel.com
Source0: daemon-vca-%{version}.tar.gz
%if ! %{defined module_headers_installed}
BuildRequires: vcass-modules-headers
%endif
Requires: mtools
Requires: pciutils
Requires: libxml2 >= 2.7
Requires: initscripts
%description
vcactl-daemon provides the device management daemon and its control tool. The
daemon is responsible for booting the device, capturing crash dumps, etc.

%prep
%setup -D -q -c -T -a 0

%clean

%build
%{__make} 

%install
%{__make} install_%{install_target} DESTDIR=%{buildroot} sysconfdir=/etc
mkdir -p %{buildroot}/var/run/lock/vca


%pre
if [ $1 == 1 ]; then
    if [ -z `getent group vcausers` ] ; then
        groupadd vcausers
    fi

    if [ -z `getent passwd vcausers_default` ] ; then
        adduser -r vcausers_default -g vcausers
    fi
fi

%post
if [ $1 == 1 ]; then
%if %with_systemd
	systemctl enable vcactl
%else
	chkconfig --add vcactl
%endif
	ln -s /usr/sbin/vcactl /usr/sbin/vcactrl
fi

%preun
if [ $1 == 0 ]; then
%if %with_systemd
	systemctl disable vcactl
%else
	chkconfig --del vcactl
%endif
	rm /usr/sbin/vcactrl
fi

%files
%defattr(-,-,-,-)
%defattr(750,root,vcausers,-)
"/usr/sbin/vcactld"
"/usr/sbin/vcactl"
%defattr(774,root,vcausers,-)
"/usr/sbin/vca_start_card_domu.sh"
"/usr/sbin/vca_start_host_domu.sh"
"/usr/sbin/vca_start_card_kvm.sh"
/etc/vca_config.d/vca_auto_boot.sh

%defattr(774,root,root,-)
/usr/sbin/vca_eth_ifup.sh
%defattr(664,root,vcausers,-)
%config /etc/vca_config.d/vca_config.xml
%config /etc/vca_config.d/vca_xen_multicast_config.xml
%defattr(774,root,vcausers,775)
/etc/vca_config.d/vca_daemon_default.sh
%defattr(660,root,vcausers,-)
/etc/vca_config.d/MACUpdateImage.img
/etc/vca_config.d/ClearSMBiosEventLogImage.img
%defattr(644,root,root,744)
/etc/udev/rules.d/95-vca.rules
/etc/udev/rules.d/96-vop.rules
/etc/udev/rules.d/97-host_eth_up.rules
/etc/udev/rules.d/98-vca_mgr.rules
/etc/udev/rules.d/99-vca_mgr_extd.rules
%attr(775,root,vcausers) /var/run/lock/vca
%defattr(660,root,vcausers,775)
/usr/lib/vca/
/usr/lib/vca/images/
%attr(770,root,vcausers) /usr/lib/vca/domUsetup.sh
%attr(770,root,vcausers) /usr/lib/vca/kvmsetup.sh
%defattr(664,root,vcausers,-)
/usr/share/bash-completion/completions/vcactl
%defattr(644,root,root,-)
/usr/lib/tmpfiles.d/vca.conf
%if %with_systemd
%defattr(664,root,root,755)
/usr/lib/systemd/
/usr/lib/systemd/system
/usr/lib/systemd/system/vcactl.service
%else
%defattr(755,root,root,-)
/etc/rc.d/init.d/vcactl
%endif
%changelog

