Name: kernel
Summary: The Linux Kernel
Version: 4.4.115_1.1.5.39.MSS.6.VCA
Release: 1
License: GPL
Group: System Environment/Kernel
Vendor: The Linux Community
URL: http://www.kernel.org
Source: kernel-4.4.115_1.1.5.39.MSS.6.VCA.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{PACKAGE_VERSION}-root
Provides:  kernel-4.4.115-1.1.5.39.MSS.6.VCA
%define __spec_install_post /usr/lib/rpm/brp-compress || :
%define debug_package %{nil}

%description
The Linux Kernel, the operating system core itself

%package headers
Summary: Header files for the Linux kernel for use by glibc
Group: Development/System
Obsoletes: kernel-headers
Provides: kernel-headers = %{version}
%description headers
Kernel-headers includes the C header files that specify the interface
between the Linux kernel and userspace libraries and programs.  The
header files define structures and constants that are needed for
building most standard programs and are also needed for rebuilding the
glibc package.

%package devel
Summary: Development package for building kernel modules to match the 4.4.115_1.1.5.39.MSS.6.VCA kernel
Group: System Environment/Kernel
AutoReqProv: no
%description -n kernel-devel
This package provides kernel headers and makefiles sufficient to build modules
against the 4.4.115_1.1.5.39.MSS.6.VCA kernel package.

%package debug
Summary: Debug package with unstripped 4.4.115_1.1.5.39.MSS.6.VCA kernel
Group: System Environment/Kernel
AutoReqProv: no
%description -n kernel-debug
This package provides unstripped 4.4.115_1.1.5.39.MSS.6.VCA kernel

%prep
%setup -q

%build
make clean && make %{?_smp_mflags}

%install
KBUILD_IMAGE=$(make image_name)
%ifarch ia64
mkdir -p $RPM_BUILD_ROOT/boot/efi $RPM_BUILD_ROOT/lib/modules
%else
mkdir -p $RPM_BUILD_ROOT/boot $RPM_BUILD_ROOT/lib/modules
%endif
mkdir -p $RPM_BUILD_ROOT/lib/firmware/4.4.115-1.1.5.39.MSS.6.VCA
INSTALL_MOD_PATH=$RPM_BUILD_ROOT make %{?_smp_mflags} KBUILD_SRC= mod-fw= modules_install
INSTALL_FW_PATH=$RPM_BUILD_ROOT/lib/firmware/4.4.115-1.1.5.39.MSS.6.VCA
make INSTALL_FW_PATH=$INSTALL_FW_PATH firmware_install
%ifarch ia64
cp $KBUILD_IMAGE $RPM_BUILD_ROOT/boot/efi/vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA
ln -s efi/vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA $RPM_BUILD_ROOT/boot/
%else
%ifarch ppc64
cp vmlinux arch/powerpc/boot
cp arch/powerpc/boot/$KBUILD_IMAGE $RPM_BUILD_ROOT/boot/vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA
%else
cp $KBUILD_IMAGE $RPM_BUILD_ROOT/boot/vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA
%endif
%endif
make %{?_smp_mflags} INSTALL_HDR_PATH=$RPM_BUILD_ROOT/usr KBUILD_SRC= headers_install
cp System.map $RPM_BUILD_ROOT/boot/System.map-4.4.115-1.1.5.39.MSS.6.VCA
cp .config $RPM_BUILD_ROOT/boot/config-4.4.115-1.1.5.39.MSS.6.VCA
%ifnarch ppc64
bzip2 -9 --keep vmlinux
mv vmlinux.bz2 $RPM_BUILD_ROOT/boot/vmlinux-4.4.115-1.1.5.39.MSS.6.VCA.bz2
%endif
rm -f $RPM_BUILD_ROOT/lib/modules/4.4.115-1.1.5.39.MSS.6.VCA/{build,source}
mkdir -p $RPM_BUILD_ROOT/usr/src/kernels/4.4.115-1.1.5.39.MSS.6.VCA
EXCLUDES="--exclude SCCS --exclude BitKeeper --exclude .svn --exclude CVS --exclude .pc --exclude .hg --exclude .git --exclude .tmp_versions --exclude=*vmlinux* --exclude=*.o --exclude=*.ko --exclude=*.cmd --exclude=Documentation --exclude=firmware --exclude .config.old --exclude .missing-syscalls.d"
tar $EXCLUDES -cf- . | (cd $RPM_BUILD_ROOT/usr/src/kernels/4.4.115-1.1.5.39.MSS.6.VCA;tar xvf -)
cd $RPM_BUILD_ROOT/lib/modules/4.4.115-1.1.5.39.MSS.6.VCA
ln -sf /usr/src/kernels/4.4.115-1.1.5.39.MSS.6.VCA build
ln -sf /usr/src/kernels/4.4.115-1.1.5.39.MSS.6.VCA source

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ -x /sbin/installkernel -a -r /boot/vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA -a -r /boot/System.map-4.4.115-1.1.5.39.MSS.6.VCA ]; then
cp /boot/vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA /boot/.vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA-rpm
cp /boot/System.map-4.4.115-1.1.5.39.MSS.6.VCA /boot/.System.map-4.4.115-1.1.5.39.MSS.6.VCA-rpm
rm -f /boot/vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA /boot/System.map-4.4.115-1.1.5.39.MSS.6.VCA
/sbin/installkernel 4.4.115-1.1.5.39.MSS.6.VCA /boot/.vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA-rpm /boot/.System.map-4.4.115-1.1.5.39.MSS.6.VCA-rpm
rm -f /boot/.vmlinuz-4.4.115-1.1.5.39.MSS.6.VCA-rpm /boot/.System.map-4.4.115-1.1.5.39.MSS.6.VCA-rpm
fi

%files
%defattr (-, root, root)
/lib/modules/4.4.115-1.1.5.39.MSS.6.VCA
%exclude /lib/modules/4.4.115-1.1.5.39.MSS.6.VCA/build
%exclude /lib/modules/4.4.115-1.1.5.39.MSS.6.VCA/source
/lib/firmware/4.4.115-1.1.5.39.MSS.6.VCA
/boot/config*
/boot/System.map*
/boot/vmlinuz*

%files headers
%defattr (-, root, root)
/usr/include

%files debug
%defattr (-, root, root)
/boot/vmlinux*bz2

%files devel
%defattr (-, root, root)
/usr/src/kernels/4.4.115-1.1.5.39.MSS.6.VCA
/lib/modules/4.4.115-1.1.5.39.MSS.6.VCA/build
/lib/modules/4.4.115-1.1.5.39.MSS.6.VCA/source

