
%if "%dist" >= ".el7"
%define with_systemd 1
%define install_target systemd
%else
%define with_systemd 0
%define install_target no_systemd
%endif

Summary: Intel (R) VCA Management Daemon

%if "%dist" == ".el7.centos"
Name: daemon-vca
%else
Name: daemon-vca%dist
%endif
Version: %{_version}
Release: 0
License: See COPYING
Group: base
Vendor: Intel Corporation
URL: http://www.intel.com
Source0: daemon-vca-%{version}.tar.gz
%if ! %{defined module_headers_installed}
BuildRequires: vcass-modules-headers
%endif
Requires: mtools
Requires: pciutils
Requires: boost-regex boost-filesystem boost-date-time boost-thread boost-system
Requires: initscripts
Requires: bridge-utils
%description
vcactl-daemon provides the device management daemon and its control tool.
The daemon is responsible for booting the device, capturing crash dumps, etc.

%prep
%setup -D -q -c -T -a 0
%clean

%build
cmake -DDESTDIR=%{buildroot} -DBUILDNO=%{version} -DMODULES_SRC=/quickbuild/workspace/10350/ValleyVistaApps/../ValleyVistaModules -G "Unix Makefiles"
%{__make} 
%install
# installation depends on existence of systemd service, so first need to build additional targets
# (install_systemd for CentOS7X, install_no_systemd for CentOS6X), which install appropriate files,
# then install rest of required files
%{__make} install_%{install_target} install sysconfdir=/etc
mkdir -p %{buildroot}/var/run/lock/vca


%pre
if [ $1 == 1 ]; then
    if [ -z `getent group vcausers` ] ; then
        groupadd vcausers
    fi

    if [ -z `getent passwd vcausers_default` ] ; then
        adduser -r vcausers_default -g vcausers
    fi
fi

%post
if [ $1 == 1 ]; then
%if %with_systemd
	systemctl enable vcactl
%else
	chkconfig --add vcactl
%endif
	ln -s /usr/sbin/vcactl /usr/sbin/vcactrl
	chgrp vcausers /etc/vca_config.d/
	chmod 775 /etc/vca_config.d/
fi
if [ -a /etc/vca_config.d/vca_config.old_user.xml ]; then
	cp /etc/vca_config.d/vca_config.xml /etc/vca_config.d/vca_config.new_default.xml
	echo "Running configuration update. This may take a while."
	vca_config_upgrade.sh
fi

%preun
rm /etc/vca_config.d/vca_config.old_user.xml /etc/vca_config.d/vca_config.old_default.xml
cp /etc/vca_config.d/vca_config.xml /etc/vca_config.d/vca_config.old_user.xml
vcactl config-default
cp /etc/vca_config.d/vca_config.xml /etc/vca_config.d/vca_config.old_default.xml
if [ $1 == 0 ]; then
%if %with_systemd
	systemctl disable vcactl
%else
	chkconfig --del vcactl
%endif
	rm /usr/sbin/vcactrl
fi

%files
%exclude /usr/lib/vca/*.pyc
%exclude /usr/lib/vca/*.pyo
%defattr(-,-,-,-)
%defattr(750,root,vcausers,-)
"/usr/sbin/vcactld"
"/usr/sbin/vcactl"
%defattr(774,root,vcausers,-)
/etc/vca_config.d/vca_auto_boot.sh
/usr/sbin/vca_config_upgrade.sh

%defattr(774,root,root,-)
/usr/sbin/vca_eth_ifup.sh
%defattr(664,root,vcausers,-)
%config /etc/vca_config.d/vca_config.xml
%defattr(774,root,vcausers,775)
/etc/vca_config.d/vca_daemon_default.sh
%defattr(660,root,vcausers,-)
/etc/vca_config.d/MACUpdateImage.img
/etc/vca_config.d/ClearSMBiosEventLogImage.img
%defattr(644,root,root,744)
/lib/udev/rules.d/95-vca.rules
/lib/udev/rules.d/96-vop.rules
/lib/udev/rules.d/97-host_eth_up.rules
/lib/udev/rules.d/98-vca_mgr.rules
/lib/udev/rules.d/99-vca_mgr_extd.rules
/lib/udev/rules.d/99-vca_blk_bcknd.rules
%attr(775,root,vcausers) /var/run/lock/vca
%defattr(660,root,vcausers,775)
/usr/lib/vca/
%attr(774,root,vcausers) /usr/lib/vca/make_config.py
%defattr(664,root,vcausers,-)
/usr/share/bash-completion/completions/vcactl
%defattr(644,root,root,-)
/usr/lib/tmpfiles.d/vca.conf
%if %with_systemd
%defattr(664,root,root,755)
/usr/lib/systemd/
/usr/lib/systemd/system
/usr/lib/systemd/system/vcactl.service
%else
%defattr(755,root,root,-)
/etc/rc.d/init.d/vcactl
%endif
%changelog

