echo -off
# + ============================================================== +
#  Copyright (c) 2018, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  startup.nsh

#  Abstract:  Script file for invoking iflash.

# + ============================================================== +
#    Program all blocks of BIOS from capsule file 
# + ============================================================== +

echo Flashing BIOS...
iflash32.efi -u RB_03.04.0006.cap -ni
if not %lasterror% == 0 then
  echo Flashing BIOS failed, abort ME FW and Flash Descriptor update.
  goto END
endif

echo Flashing ME FW...
iflash32.efi -u MEComplete_03.00.07.024.cap -ni
if not %lasterror% == 0 then
  echo Flashing ME FW failed, abort Flash Descriptor update.
  goto END
endif

:END
echo -on

