/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SafeCountDownLatch
extends CountDownLatch {
    private int timeout = 50;

    public SafeCountDownLatch(int count) {
        super(count);
    }

    public void setTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be a positive value!");
        }
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void await() throws InterruptedException {
        if (!super.await(this.timeout, TimeUnit.SECONDS)) {
            throw new RuntimeException("Time out after " + this.timeout + " seconds!");
        }
    }
}

