/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum FocusStatus {
    OK(0),
    PMA_IGNORE(1),
    PMA_NORESP(2),
    TOPO_NORESP(3);

    private static final Map<Byte, FocusStatus> focusStatusMap;
    private final byte code;

    private FocusStatus(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static FocusStatus getFocusStatus(byte code) {
        FocusStatus res = focusStatusMap.get(code);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Unsupported FocusFlag " + StringUtils.byteHexString(code));
    }

    static {
        focusStatusMap = new HashMap<Byte, FocusStatus>(){
            private static final long serialVersionUID = 1L;
            {
                for (FocusStatus ff : FocusStatus.values()) {
                    this.put(ff.code, ff);
                }
            }
        };
    }
}

