/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum LinkWidthMask {
    STL_LINK_WIDTH_NOP(0, -1),
    STL_LINK_WIDTH_1X(1, 1),
    STL_LINK_WIDTH_2X(2, 2),
    STL_LINK_WIDTH_3X(4, 3),
    STL_LINK_WIDTH_4X(8, 4);

    private final short val;
    private final int width;

    private LinkWidthMask(short inval, int width) {
        this.val = inval;
        this.width = width;
    }

    public short getWidthMask() {
        return this.val;
    }

    public int getWidth() {
        return this.width;
    }

    public static LinkWidthMask getLinkWidthMask(short inval) {
        for (LinkWidthMask spd : LinkWidthMask.values()) {
            if (spd.getWidthMask() != inval) continue;
            return spd;
        }
        throw new IllegalArgumentException("Unsupported Link Width " + StringUtils.shortHexString(inval));
    }

    public static List<LinkWidthMask> getWidthMasks(short inval) {
        if (inval == STL_LINK_WIDTH_NOP.getWidthMask()) {
            return Collections.singletonList(STL_LINK_WIDTH_NOP);
        }
        ArrayList<LinkWidthMask> res = new ArrayList<LinkWidthMask>();
        for (LinkWidthMask mask : LinkWidthMask.values()) {
            if (mask == STL_LINK_WIDTH_NOP || (inval & mask.getWidthMask()) != mask.getWidthMask()) continue;
            res.add(mask);
        }
        return res;
    }
}

