/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;

public enum MTUSize {
    INVALID(0, "0"),
    IB_MTU_2048(4, "2048"),
    IB_MTU_4096(5, "4096"),
    STL_MTU_8192(6, "8192"),
    STL_MTU_10240(7, "10240");

    private final byte sz;
    private final String name;

    private MTUSize(byte val, String name) {
        this.sz = val;
        this.name = name;
    }

    public byte getSize() {
        return this.sz;
    }

    public String getName() {
        return this.name;
    }

    public static MTUSize getMTUSize(byte inval) {
        for (MTUSize mtu : MTUSize.values()) {
            if (mtu.getSize() != inval) continue;
            return mtu;
        }
        throw new IllegalArgumentException("Unsupported MTUSize " + StringUtils.byteHexString(inval));
    }

    public static MTUSize getMTUSize(String name) {
        for (MTUSize mtu : MTUSize.values()) {
            if (!mtu.getName().equalsIgnoreCase(name)) continue;
            return mtu;
        }
        throw new IllegalArgumentException("Unsupported MTUSize '" + name + "'");
    }
}

