/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.Arrays;

public enum PacketFormat {
    NOP(0),
    FORMAT_8B(1),
    FORMAT_9B(2),
    FORMAT_10B(4),
    FORMAT_16B(8);

    private final byte value;

    private PacketFormat(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static PacketFormat getPacketFormat(short value) {
        byte bValue = (byte)(value & 0xFF);
        for (PacketFormat format : PacketFormat.values()) {
            if (format.value != bValue) continue;
            return format;
        }
        throw new IllegalArgumentException("Unsupported Packet Format " + StringUtils.shortHexString(value));
    }

    public static PacketFormat[] getPacketFormats(short value) {
        byte bValue = (byte)(value & 0xFF);
        if (PacketFormat.isNoneSupported(bValue)) {
            return new PacketFormat[]{NOP};
        }
        PacketFormat[] allPacketFormats = PacketFormat.values();
        PacketFormat[] formats = new PacketFormat[allPacketFormats.length];
        int numFormats = 0;
        for (PacketFormat pfv : allPacketFormats) {
            if (pfv == NOP || (pfv.value & bValue) != pfv.value) continue;
            formats[numFormats] = pfv;
            ++numFormats;
        }
        return Arrays.copyOf(formats, numFormats);
    }

    public static boolean isNoneSupported(byte value) {
        return value == PacketFormat.NOP.value;
    }
}

