/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum PhysicalState {
    NO_ST_CHANGE(0),
    SLEEP(1),
    POLLING(2),
    DISABLED(3),
    PORT_CONFIG_TRAINING(4),
    LINKUP(5),
    LINK_ERROR_RECOVERY(6),
    OFFLINE(9),
    TEST(11);

    private static final Map<Byte, PhysicalState> _map;
    private final byte id;

    private PhysicalState(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static PhysicalState getPhysicalState(byte id) {
        PhysicalState res = _map.get(id);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Unsupported PhysicalState " + StringUtils.byteHexString(id));
    }

    static {
        _map = new HashMap<Byte, PhysicalState>(){
            private static final long serialVersionUID = 1L;
            {
                for (PhysicalState type : PhysicalState.values()) {
                    this.put(type.id, type);
                }
            }
        };
    }
}

