/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration.impl;

import com.intel.stl.api.configuration.MailProperties;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSender {
    private static Logger log = LoggerFactory.getLogger(MailSender.class);
    private static boolean DEBUG = true;
    private static int QUEUE_SIZE = 4096;
    private MailProperties properties;
    private final ExecutorService service;
    private final BlockingQueue<MessageItem> items;
    private Future<?> future;
    private Session session;
    private Transport transport;
    private final Object synchronizeUpdateObject = new Object();

    public MailSender(MailProperties properties) throws NoSuchProviderException, MessagingException {
        log.debug("MailSender: constructor called.");
        this.service = Executors.newSingleThreadExecutor();
        this.items = new LinkedBlockingQueue<MessageItem>(QUEUE_SIZE);
        this.initSender(properties);
    }

    private MailSender() {
        log.debug("MailSender: temoprary test constructor called.");
        this.service = null;
        this.items = null;
    }

    public static void sendTestMail(MailProperties properties, String recipient, String messageSubject, String messageBody) throws AddressException, MessagingException {
        MailSender mailSender = new MailSender();
        Session session = mailSender.createSession(properties);
        Transport transport = mailSender.createTransport(session);
        MessageItem messageItem = mailSender.createMessageItem(properties.getFromAddr(), recipient, messageSubject, messageBody);
        mailSender.sendMailMessage(session, transport, messageItem);
    }

    protected void initSender(MailProperties properties) throws NoSuchProviderException, MessagingException {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.updateTransport(properties);
        Runnable task = this.createSenderTask();
        this.future = this.service.submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransport(MailProperties properties) throws NoSuchProviderException, MessagingException {
        if (properties != null) {
            Object object = this.synchronizeUpdateObject;
            synchronized (object) {
                this.properties = properties;
                this.session = this.createSession(properties);
                this.transport = this.createTransport(this.session);
            }
        }
    }

    protected Transport createTransport(Session session) throws NoSuchProviderException, MessagingException {
        Transport transport = null;
        transport = session.getTransport("smtp");
        transport.connect();
        return transport;
    }

    protected Runnable createSenderTask() throws MessagingException {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block13: while (true) {
                    try {
                        try {}
                        catch (InterruptedException e) {
                            log.error("MailSender: createSenderTask exception: " + e.getMessage());
                            log.info("To close transport (" + MailSender.this.transport + ") for " + MailSender.this.properties);
                            try {
                                MailSender.this.transport.close();
                                log.info("Closed transport (" + MailSender.this.transport + ") for " + MailSender.this.properties);
                                return;
                            }
                            catch (MessagingException e2) {
                                e2.printStackTrace();
                                log.error("MailSender: createSenderTask exception: " + e2.getMessage());
                                return;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        log.info("To close transport (" + MailSender.this.transport + ") for " + MailSender.this.properties);
                        try {
                            MailSender.this.transport.close();
                            log.info("Closed transport (" + MailSender.this.transport + ") for " + MailSender.this.properties);
                            throw throwable;
                        }
                        catch (MessagingException e) {
                            e.printStackTrace();
                            log.error("MailSender: createSenderTask exception: " + e.getMessage());
                        }
                        throw throwable;
                    }
                    while (true) {
                        MessageItem item = (MessageItem)MailSender.this.items.take();
                        try {
                            Object object = MailSender.this.synchronizeUpdateObject;
                            synchronized (object) {
                                MailSender.this.sendMailMessage(MailSender.this.session, MailSender.this.transport, item);
                                continue block13;
                            }
                        }
                        catch (AddressException e) {
                            e.printStackTrace();
                            log.error("MailSender: createSenderTask exception: " + e.getMessage());
                            continue;
                        }
                        catch (MessagingException e) {
                            e.printStackTrace();
                            log.error("MailSender: createSenderTask exception: " + e.getMessage());
                            continue;
                        }
                        break;
                    }
                }
            }
        };
        return task;
    }

    protected Session createSession(MailProperties properties) {
        final MailProperties mailProperties = properties;
        Properties props = new Properties();
        props.put("mail.smtp.auth", (Object)properties.isAuthEnabled());
        props.put("mail.smtp.starttls.enable", (Object)properties.isTlsEnabled());
        props.put("mail.smtp.host", properties.getSmtpServer());
        props.put("mail.smtp.port", (Object)properties.getSmtpPort());
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(mailProperties.getUserName(), new String(mailProperties.getPassword()));
            }
        });
        session.setDebug(DEBUG);
        return session;
    }

    protected void sendMailMessage(Session session, Transport transport, MessageItem item) throws AddressException, MessagingException {
        MimeMessage message = new MimeMessage(session);
        if (item.from != null && !item.from.isEmpty() && item.to != null && !item.to.isEmpty()) {
            message.setFrom((Address)new InternetAddress(item.from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(item.to)};
            message.setRecipients(Message.RecipientType.TO, (Address[])address);
            message.setSubject(item.subject);
            message.setText(item.body);
            transport.sendMessage((Message)message, (Address[])address);
            if (DEBUG) {
                System.out.println("Send Message " + message + " to " + address[0]);
            }
            log.debug("MailSender: sendMailMessage: " + message + " to " + address[0]);
        }
    }

    public void submitMessage(String to, String subject, String body) {
        MessageItem item = new MessageItem(this.properties.getFromAddr(), to, subject, body);
        this.items.add(item);
    }

    public void shutdown() {
        log.debug("MailSender: shutdown called.");
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.service.shutdownNow();
                if (!this.service.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.warn("ExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            log.error("MailSender: shutdown exception: " + ie.getMessage());
            this.service.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public MessageItem createMessageItem(String from, String to, String subject, String body) {
        return new MessageItem(from, to, subject, body);
    }

    class MessageItem {
        String from;
        String to;
        String subject;
        String body;

        public MessageItem(String from, String to, String subject, String body) {
            this.from = from;
            this.to = to;
            this.subject = subject;
            this.body = body;
        }
    }
}

