/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.logs;

import com.intel.stl.api.logs.IResponseListener;
import com.intel.stl.api.logs.LogCommand;
import com.intel.stl.api.logs.LogErrorType;
import com.intel.stl.api.logs.LogMessageType;
import com.intel.stl.api.logs.LogResponse;
import com.intel.stl.api.logs.LogThreadFactory;
import com.intel.stl.common.STLMessages;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSession;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCommandProcessor {
    private static Logger log = LoggerFactory.getLogger(LogCommandProcessor.class);
    private final boolean DEBUG = false;
    private final boolean DEBUG_COMMANDS = false;
    private final ExecutorService service;
    private Future<LogResponse> future;
    private final JSchSession jschSession;
    private boolean initialized;
    private ChannelExec execChannel;
    private BufferedReader inputBuffer = null;
    private IResponseListener responseListener;
    private LogMessageType msgType;
    private long timeoutInMs;
    private final String identifier;
    private final LogCommandProcessor cmdProc = this;
    private boolean processingDone = false;
    private boolean shutdown = false;

    public LogCommandProcessor(JSchSession jschSession, int timeoutInMs, String id) {
        this.identifier = id + ":commandProcessingTask";
        this.service = Executors.newSingleThreadExecutor(new LogThreadFactory(id));
        this.jschSession = jschSession;
        this.timeoutInMs = timeoutInMs;
    }

    public void setResponseListener(IResponseListener listener) {
        this.responseListener = listener;
    }

    public void setTimeoutInMs(long timeoutMs) {
        this.timeoutInMs = timeoutMs;
    }

    public void stop() {
        this.shutdown = true;
        this.shutdown();
    }

    protected boolean initializeChannel() throws JSchException, IOException {
        boolean initialized = false;
        this.execChannel = this.jschSession.getExecChannel();
        this.inputBuffer = new BufferedReader(new InputStreamReader(this.execChannel.getInputStream()));
        this.execChannel.setErrStream((OutputStream)System.err);
        long currentTime = System.currentTimeMillis();
        long expiredTime = currentTime + this.timeoutInMs;
        while (this.execChannel.isClosed() && !this.execChannel.isConnected() && currentTime < expiredTime) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            currentTime = System.currentTimeMillis();
        }
        initialized = !this.execChannel.isClosed();
        return initialized;
    }

    protected String getLine() {
        String inputLine = null;
        try {
            inputLine = this.inputBuffer.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return inputLine;
    }

    protected boolean inputReady() {
        boolean ready = false;
        try {
            long currentTime = System.currentTimeMillis();
            long expireTime = currentTime + this.timeoutInMs;
            while (!(ready = this.inputBuffer.ready()) && currentTime < expireTime) {
                Thread.sleep(200L);
                currentTime = System.currentTimeMillis();
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return ready;
    }

    public void executeCommand(LogMessageType msgType, String cmd) {
        try {
            this.future = this.service.submit(new LogCommandTask(new LogCommand(msgType, cmd)));
            if (this.future != null && !this.future.isCancelled()) {
                LogResponse response = this.future.get();
                if (response.getEntries().size() > 0) {
                    if (response.getEntries().get(0).equals(STLMessages.STL50014_ESM_COMMAND_NOT_FOUND.getDescription())) {
                        this.responseListener.onResponseError(LogErrorType.SYSLOG_ACCESS_ERROR, response.getMsgType(), new Object[0]);
                    } else {
                        this.responseListener.onResponseReceived(response);
                    }
                } else {
                    LogErrorType errorCode;
                    switch (msgType) {
                        case CHECK_FOR_FILE: {
                            errorCode = LogErrorType.LOG_FILE_NOT_FOUND;
                            break;
                        }
                        case LAST_LINES: {
                            errorCode = LogErrorType.EMPTY_LOG_FILE;
                            break;
                        }
                        default: {
                            errorCode = LogErrorType.RESPONSE_TIMEOUT;
                        }
                    }
                    this.responseListener.onResponseError(errorCode, response.getMsgType(), new Object[0]);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error(e.getCause().getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void shutdown() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.service.shutdownNow();
                if (!this.service.awaitTermination(10L, TimeUnit.SECONDS)) {
                    log.warn("ExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.service.shutdownNow();
            Thread.currentThread().interrupt();
        }
        try {
            this.execChannel.getInputStream().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void debug(String ... msgs) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        System.out.println(formatter.format(new Date()) + ": " + this.identifier + ": " + msgs[0] + " " + msgs[1]);
    }

    protected class LogCommandTask
    implements Callable<LogResponse> {
        private final LogCommand logMsg;

        public LogCommandTask(LogCommand logMsg) {
            this.logMsg = logMsg;
        }

        @Override
        public LogResponse call() throws Exception {
            LogCommandProcessor.this.cmdProc.msgType = this.logMsg.getMsgType();
            LogResponse response = new LogResponse(LogCommandProcessor.this.msgType);
            try {
                if (!this.logMsg.getMsgType().equals((Object)LogMessageType.EXIT)) {
                    if (LogCommandProcessor.this.execChannel == null || LogCommandProcessor.this.execChannel.isClosed()) {
                        LogCommandProcessor.this.initialized = LogCommandProcessor.this.initializeChannel();
                    }
                    if (LogCommandProcessor.this.initialized) {
                        LogCommandProcessor.this.execChannel.setCommand(this.logMsg.getCommand());
                        LogCommandProcessor.this.execChannel.connect();
                        LogCommandProcessor.this.execChannel.getOutputStream().flush();
                    }
                    LogCommandProcessor.this.processingDone = false;
                    String entry = new String("");
                    while (!LogCommandProcessor.this.shutdown && !Thread.currentThread().isInterrupted() && !LogCommandProcessor.this.processingDone && LogCommandProcessor.this.inputReady()) {
                        entry = LogCommandProcessor.this.getLine();
                        if (entry != null) {
                            LogCommandProcessor.this.processingDone = entry.equals("intel-inside");
                        }
                        if (LogCommandProcessor.this.processingDone) continue;
                        response.addEntry(entry);
                    }
                }
            }
            catch (JSchException e) {
                log.error(e.getMessage(), (Throwable)e);
                LogCommandProcessor.this.shutdown();
            }
            return response;
        }
    }
}

