/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.logs;

import com.intel.stl.api.logs.FileInfoBean;
import com.intel.stl.api.logs.ILogErrorListener;
import com.intel.stl.api.logs.IResponseListener;
import com.intel.stl.api.logs.LogCommandProcessor;
import com.intel.stl.api.logs.LogCommander;
import com.intel.stl.api.logs.LogErrorType;
import com.intel.stl.api.logs.LogMessageType;
import com.intel.stl.api.logs.LogResponse;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSession;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStatusTask
extends TimerTask
implements IResponseListener,
ILogErrorListener {
    private static final Logger log = LoggerFactory.getLogger(LogStatusTask.class);
    private static final boolean DEBUG = false;
    private static final long DELAY_MS = 2000L;
    private static final long TIME_BETWEEN_EXEC = 1000L;
    private static final int RESPONSE_TIMEOUT = 10000;
    private static final int NUM_ARGS = 2;
    public static final int FILE_SIZE_POSITION = 0;
    public static final int NUM_LINE_POSITION = 1;
    private final FileInfoBean fileInfo;
    private final Timer timer;
    private final LogCommandProcessor fileStatusProcessor;
    private IResponseListener responseListener;
    private ILogErrorListener errorListener;
    private final LogCommander logCommander;
    private final LogMessageType msgType;
    private final LogResponse response = new LogResponse(LogMessageType.NUM_LINES);

    public LogStatusTask(String fileName, LogMessageType msgType, JSchSession jschSession, FileInfoBean fileInfo) {
        this.msgType = msgType;
        this.timer = new Timer();
        this.fileInfo = fileInfo;
        this.logCommander = new LogCommander(fileInfo);
        this.fileStatusProcessor = new LogCommandProcessor(jschSession, 10000, this.getClass().getSimpleName());
        this.fileStatusProcessor.setResponseListener(this);
    }

    public void setResponseListener(IResponseListener listener) {
        this.responseListener = listener;
    }

    public void setErrorListener(ILogErrorListener listener) {
        this.errorListener = listener;
    }

    @Override
    public void run() {
        String cmd = this.logCommander.getCommand(this.msgType, 0L);
        this.fileStatusProcessor.executeCommand(this.msgType, cmd);
    }

    protected void stop() {
        this.timer.purge();
        this.timer.cancel();
        this.fileStatusProcessor.stop();
    }

    public void start() {
        this.timer.schedule((TimerTask)this, 2000L, 1000L);
    }

    public void start(long delay, long timeBetweenExecutions) {
        this.timer.schedule((TimerTask)this, delay, timeBetweenExecutions);
    }

    public LogResponse getResponse() {
        return this.response;
    }

    @Override
    public void onResponseReceived(LogResponse response) {
        List<String> entries = response.getEntries();
        int numEntries = entries.size();
        long newFileSize = 0L;
        long numLines = 0L;
        long currentTotal = this.fileInfo.getTotalNumLines();
        if (numEntries == 2) {
            newFileSize = Long.valueOf(entries.get(0).split("=")[1]);
            numLines = Long.valueOf(entries.get(1).split("=")[1]);
            long totalLines = currentTotal + numLines;
            this.debugResponse(currentTotal, numLines, totalLines);
            entries.clear();
            entries.add(String.valueOf(newFileSize));
            entries.add(String.valueOf(totalLines));
            this.responseListener.onResponseReceived(response);
        } else {
            log.error(this.getClass().getSimpleName() + ": Unexepected number of arguments (" + numEntries + ") in response message!");
            this.onResponseError(LogErrorType.INVALID_RESPONSE_FORMAT, LogMessageType.NUM_LINES, numEntries);
        }
    }

    public void debugResponse(long currentTotal, long numLines, long totalNumLines) {
    }

    @Override
    public void onResponseError(LogErrorType errorCode, LogMessageType type, Object ... data) {
        this.responseListener.onResponseError(errorCode, type, data);
    }

    @Override
    public void stopLog() {
        this.errorListener.stopLog();
    }
}

