/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management;

import com.intel.stl.api.Utils;
import com.intel.stl.api.management.FMConfHelper;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.HostType;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.SshSession;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmpFmConfHelper
extends FMConfHelper {
    private static final Logger log = LoggerFactory.getLogger(TmpFmConfHelper.class);

    public TmpFmConfHelper(HostInfo host) {
        super(new SubnetDescription("TMP"));
        this.subnet.setFEList(Collections.singletonList(host));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchConfigFile(char[] password) throws Exception {
        HostInfo hostInfo = this.subnet.getCurrentFE();
        Session session = this.createSession(hostInfo, password);
        session.connect();
        this.fmVersion = Utils.getFMVersion(new SshSession(session));
        this.tmpConfFile = File.createTempFile("~FV", null);
        this.tmpConfFile.deleteOnExit();
        if (!session.isConnected()) {
            session = this.createSession(hostInfo, password);
            session.connect();
        }
        try {
            Channel channel = session.openChannel("sftp");
            channel.connect();
            try {
                ChannelSftp channelSftp = (ChannelSftp)channel;
                HostType hostType = this.determineHostType(channelSftp);
                hostInfo.setHostType(hostType);
                channelSftp.cd(this.getConfigLocation(hostType));
                channelSftp.get("opafm.xml", this.tmpConfFile.getAbsolutePath());
                log.info("Download " + hostInfo.getHost() + ":" + "opafm.xml" + " to " + this.tmpConfFile.getAbsolutePath() + " (size=" + this.tmpConfFile.length() + ")");
                this.subnet.setCurrentUser(hostInfo.getSshUserName());
            }
            finally {
                channel.disconnect();
            }
        }
        finally {
            session.disconnect();
        }
    }
}

