/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.applications;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.Utils;
import com.intel.stl.api.management.applications.MGID;

public class MGIDRange
extends MGID {
    private static final long serialVersionUID = -5917419318702635265L;
    private long maxLower;
    private long maxUpper;

    public MGIDRange() {
    }

    public MGIDRange(long lower, long upper, long maxLower, long maxUpper) {
        super("MGIDRange", lower, upper);
        this.maxLower = maxLower;
        this.maxUpper = maxUpper;
    }

    public long getMaxLower() {
        return this.maxLower;
    }

    public long getMaxUpper() {
        return this.maxUpper;
    }

    public long getMinLower() {
        return this.lower;
    }

    public long getMinUpper() {
        return this.upper;
    }

    @Override
    public void setVal(String val) {
        String[] segs = val.split("-");
        super.setVal(segs[0]);
        if (segs.length > 0) {
            segs = segs[1].split(":");
            this.maxLower = Utils.toLong(segs[0]);
            if (segs.length > 0) {
                this.maxUpper = Utils.toLong(segs[1]);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxLower ^ this.maxLower >>> 32);
        result = 31 * result + (int)(this.maxUpper ^ this.maxUpper >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MGIDRange other = (MGIDRange)obj;
        if (this.maxLower != other.maxLower) {
            return false;
        }
        return this.maxUpper == other.maxUpper;
    }

    @Override
    public MGIDRange copy() {
        return new MGIDRange(this.lower, this.upper, this.maxLower, this.maxUpper);
    }

    @Override
    public String toString() {
        return super.toString() + "-" + StringUtils.longHexString(this.maxLower) + ":" + StringUtils.longHexString(this.maxUpper);
    }
}

