/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.applications;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.Utils;
import com.intel.stl.api.management.applications.ServiceID;

public class ServiceIDMasked
extends ServiceID {
    private static final long serialVersionUID = -4356224962567422639L;
    private long mask;

    public ServiceIDMasked() {
        this(0L, 0L);
    }

    public ServiceIDMasked(long id, long mask) {
        super("ServiceIDMasked", id);
        this.mask = mask;
    }

    public long getMask() {
        return this.mask;
    }

    @Override
    public void setValue(String val) {
        String[] segs = val.split("\\*");
        super.setValue(segs[0]);
        if (segs.length > 0) {
            this.mask = Utils.toLong(segs[1]);
        }
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceIDMasked other = (ServiceIDMasked)obj;
        return this.mask == other.mask;
    }

    @Override
    public ServiceIDMasked copy() {
        ServiceIDMasked res = new ServiceIDMasked(this.getId(), this.mask);
        return res;
    }

    @Override
    public String toString() {
        return super.toString() + "*" + StringUtils.longHexString(this.mask);
    }
}

