/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.virtualfabrics.impl;

import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.management.ChangeManager;
import com.intel.stl.api.management.DuplicateNameException;
import com.intel.stl.api.management.FMConfHelper;
import com.intel.stl.api.management.XMLUtils;
import com.intel.stl.api.management.virtualfabrics.IVirtualFabricManagement;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import com.intel.stl.api.management.virtualfabrics.VirtualFabricException;
import com.intel.stl.api.management.virtualfabrics.VirtualFabrics;
import com.intel.stl.common.STLMessages;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualFabricManagement
implements IVirtualFabricManagement {
    private static final Logger log = LoggerFactory.getLogger(VirtualFabricManagement.class);
    private static final Set<String> RESERVED = new HashSet<String>(){
        private static final long serialVersionUID = -8507198541424973196L;
        {
            this.add("Admin");
        }
    };
    private final FMConfHelper confHelp;
    private final ChangeManager changeMgr = new ChangeManager();

    public VirtualFabricManagement(FMConfHelper confHelp) {
        this.confHelp = confHelp;
    }

    @Override
    public Set<String> getReservedVirtualFabrics() {
        return RESERVED;
    }

    @Override
    public List<VirtualFabric> getVirtualFabrics() throws VirtualFabricException {
        try {
            File confFile = this.confHelp.getConfFile();
            VirtualFabrics vfs = this.unmarshal(confFile);
            log.info("Fetch " + vfs.getVFs().size() + " Device Groups from host '" + this.confHelp.getHost() + "'");
            return vfs.getVFs();
        }
        catch (Exception e) {
            throw this.createVirtualFabricException(STLMessages.STL63021_GET_VFS_ERR, e, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    @Override
    public VirtualFabric getVirtualFabric(String name) throws VirtualFabricException {
        try {
            File confFile = this.confHelp.getConfFile();
            VirtualFabrics vfs = this.unmarshal(confFile);
            return vfs.getVF(name);
        }
        catch (Exception e) {
            throw this.createVirtualFabricException(STLMessages.STL63026_GET_VF_ERR, e, name, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    private VirtualFabrics unmarshal(File xmlFile) throws Exception {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        StreamSource xml = new StreamSource(xmlFile);
        XMLStreamReader xsr = xif.createXMLStreamReader(xml);
        while (!(!xsr.hasNext() || xsr.isStartElement() && xsr.getLocalName().equals("VirtualFabrics"))) {
            xsr.next();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{VirtualFabrics.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        JAXBElement jb = unmarshaller.unmarshal(xsr, VirtualFabrics.class);
        xsr.close();
        return (VirtualFabrics)jb.getValue();
    }

    @Override
    public void addVirtualFabric(VirtualFabric vf) throws VirtualFabricException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.uniqueNameCheck(null, vf.getName());
            this.addVirtualFabric(confFile, confFile, vf);
            log.info("Added Virtual Fabric " + vf);
            this.changeMgr.addChange(vf.getName());
        }
        catch (Exception e) {
            throw this.createVirtualFabricException(STLMessages.STL63022_ADD_VF_ERR, e, vf.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void addVirtualFabric(File srcXml, File dstXml, VirtualFabric vf) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{vf.getClass()});
        context.createMarshaller().marshal((Object)vf, (Result)res);
        Document groupsDoc = (Document)res.getNode();
        Node newGroup = groupsDoc.getFirstChild();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        Node groupsNode = doc.getElementsByTagName("VirtualFabrics").item(0);
        Node matchedGroup = this.getVFByName(groupsNode, vf.getName());
        if (matchedGroup != null) {
            throw new IllegalArgumentException("Virtual Fabric '" + vf.getName() + "' alreday exist!");
        }
        XMLUtils.appendNode(doc, groupsNode, newGroup);
        XMLUtils.writeDoc(doc, dstXml);
    }

    @Override
    public void removeVirtualFabric(String name) throws VirtualFabricException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.removeVirtualFabric(confFile, confFile, name);
            log.info("Removed application '" + name + "'");
            this.changeMgr.addChange(name);
        }
        catch (Exception e) {
            throw this.createVirtualFabricException(STLMessages.STL63023_REMOVE_VF_ERR, e, name, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void removeVirtualFabric(File srcXml, File dstXml, String name) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        Node vfsNode = doc.getElementsByTagName("VirtualFabrics").item(0);
        Node matchedVf = this.getVFByName(vfsNode, name);
        if (matchedVf != null) {
            XMLUtils.removeNode(doc, vfsNode, matchedVf, name);
            XMLUtils.writeDoc(doc, dstXml);
        } else {
            log.warn("Couldn't find Virtual Fabric '" + name + "'");
        }
    }

    @Override
    public void updateVirtualFabric(String oldName, VirtualFabric vf) throws VirtualFabricException {
        try {
            File confFile = this.confHelp.getConfFile();
            if (!oldName.equals(vf.getName())) {
                VirtualFabrics groups = this.unmarshal(confFile);
                this.uniqueNameCheck(groups, vf.getName());
            }
            this.updateVirtualFabric(confFile, confFile, oldName, vf, false);
            log.info("Updated Virtual Fabric " + vf);
            this.changeMgr.addChange(oldName);
            this.changeMgr.addChange(vf.getName());
        }
        catch (Exception e) {
            throw this.createVirtualFabricException(STLMessages.STL63024_UPDATE_VF_ERR, e, vf.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    @Override
    public void addOrUpdateVirtualFabric(String oldName, VirtualFabric vf) throws VirtualFabricException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.updateVirtualFabric(confFile, confFile, oldName, vf, true);
            log.info("Added or updated Virtual Fabric " + vf);
            this.changeMgr.addChange(oldName);
            this.changeMgr.addChange(vf.getName());
        }
        catch (Exception e) {
            throw this.createVirtualFabricException(STLMessages.STL63025_ADDUPDATE_VF_ERR, e, vf.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateVirtualFabric(File srcXml, File dstXml, String oldName, VirtualFabric vf, boolean allowAdd) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{vf.getClass()});
        context.createMarshaller().marshal((Object)vf, (Result)res);
        Document vfsDoc = (Document)res.getNode();
        Node newVf = vfsDoc.getFirstChild();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        doc.adoptNode(newVf);
        Node vfsNode = doc.getElementsByTagName("VirtualFabrics").item(0);
        Node matchedVf = this.getVFByName(vfsNode, oldName);
        if (matchedVf == null) {
            if (!allowAdd) throw new IllegalArgumentException("Couldn't find Virtual Fabric '" + oldName + "'");
            XMLUtils.appendNode(doc, vfsNode, newVf);
        } else {
            XMLUtils.replaceNode(doc, vfsNode, matchedVf, newVf);
        }
        XMLUtils.writeDoc(doc, dstXml);
    }

    protected void uniqueNameCheck(VirtualFabrics vfs, String name) throws Exception {
        if (vfs == null) {
            File confFile = this.confHelp.getConfFile();
            vfs = this.unmarshal(confFile);
        }
        for (VirtualFabric group : vfs.getVFs()) {
            if (!group.getName().equals(name)) continue;
            throw new DuplicateNameException(name);
        }
    }

    private Node getVFByName(Node appsNode, String name) {
        NodeList children = appsNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node nameNode;
            Node child = children.item(i);
            if (!child.getNodeName().equals("VirtualFabric") || (nameNode = XMLUtils.getNodeByName(child, "Name")) == null || !nameNode.getTextContent().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected VirtualFabricException createVirtualFabricException(IMessage msg, Throwable error, Object ... args) {
        return new VirtualFabricException(msg, error, args);
    }

    public boolean hasChanges() {
        return !this.changeMgr.getChanges().isEmpty();
    }

    public void applyChangesTo(VirtualFabricManagement target) throws VirtualFabricException {
        List<VirtualFabric> vfs = this.getVirtualFabrics();
        HashMap<String, VirtualFabric> map = new HashMap<String, VirtualFabric>();
        for (VirtualFabric vf : vfs) {
            map.put(vf.getName(), vf);
        }
        for (String change : this.changeMgr.getChanges()) {
            VirtualFabric cur = (VirtualFabric)map.get(change);
            if (cur == null) {
                target.removeVirtualFabric(change);
                continue;
            }
            target.addOrUpdateVirtualFabric(change, cur);
        }
        this.changeMgr.resetChanges();
    }

    public void reset() {
        this.changeMgr.resetChanges();
    }
}

