/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.notice.impl;

import com.intel.stl.api.notice.GenericNoticeAttrBean;
import com.intel.stl.api.notice.IEventListener;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.NoticeType;
import com.intel.stl.api.notice.ProducerType;
import com.intel.stl.api.notice.TrapType;
import com.intel.stl.api.subnet.GIDGlobal;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.api.subnet.impl.NodeCache;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.fecdriver.messages.adapter.sa.GID;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeSimulator {
    private static Logger log = LoggerFactory.getLogger(NoticeSimulator.class);
    private static final String SIM_THREAD_PREFIX = "simthread-";
    private List<NodeRecordBean> nodes;
    private final List<IEventListener<NoticeBean>> listeners = new CopyOnWriteArrayList<IEventListener<NoticeBean>>();
    private final CacheManager cacheMgr;
    private Thread worker;
    private boolean stop;
    private final Random random = new Random();
    private final int minSleepTime = 10000;
    private final INoticeCreator hfiActiveCreator = new INoticeCreator(){

        @Override
        public NoticeBean createNotice(NodeRecordBean node) {
            NoticeBean res = new NoticeBean(true);
            GenericNoticeAttrBean attr = new GenericNoticeAttrBean();
            attr.setGeneric(true);
            attr.setType(NoticeType.INFO.getId());
            attr.setProducerType(ProducerType.CA.getId());
            attr.setTrapNumber(TrapType.GID_NOW_IN_SERVICE.getId());
            res.setAttributes(attr);
            res.setIssuerLID(node.getLid());
            res.setIssuerGID(new GIDGlobal());
            GID.Global gid = new GID.Global();
            gid.build(true);
            gid.setInterfaceId(node.getNodeInfo().getPortGUID());
            res.setData(gid.getByteBuffer().array());
            return res;
        }
    };
    private final INoticeCreator hfiInactiveCreator = new INoticeCreator(){

        @Override
        public NoticeBean createNotice(NodeRecordBean node) {
            NoticeBean res = new NoticeBean(true);
            GenericNoticeAttrBean attr = new GenericNoticeAttrBean();
            attr.setGeneric(true);
            attr.setType(NoticeType.FATAL.getId());
            attr.setProducerType(ProducerType.CA.getId());
            attr.setTrapNumber(TrapType.GID_OUT_OF_SERVICE.getId());
            res.setAttributes(attr);
            res.setIssuerLID(node.getLid());
            res.setIssuerGID(new GIDGlobal());
            GID.Global gid = new GID.Global();
            gid.build(true);
            gid.setInterfaceId(node.getNodeInfo().getPortGUID());
            res.setData(gid.getByteBuffer().array());
            return res;
        }
    };
    private final INoticeCreator linkChangeCreator = new INoticeCreator(){

        @Override
        public NoticeBean createNotice(NodeRecordBean node) {
            NoticeBean res = new NoticeBean(true);
            GenericNoticeAttrBean attr = new GenericNoticeAttrBean();
            attr.setGeneric(true);
            attr.setType(NoticeType.URGENT.getId());
            attr.setProducerType(ProducerType.SWITCH.getId());
            attr.setTrapNumber(TrapType.LINK_PORT_CHANGE_STATE.getId());
            res.setAttributes(attr);
            res.setIssuerLID(node.getLid());
            res.setIssuerGID(new GIDGlobal());
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(node.getLid());
            res.setData(buffer.array());
            return res;
        }
    };

    public NoticeSimulator(CacheManager cacheMgr) {
        this.cacheMgr = cacheMgr;
    }

    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    public synchronized void run() {
        if (this.worker != null && !this.stop) {
            return;
        }
        this.stop = false;
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                NoticeSimulator.this.simulate();
            }
        });
        SubnetDescription subnet = this.cacheMgr.getSAHelper().getSubnetDescription();
        this.worker.setName(SIM_THREAD_PREFIX + subnet.getSubnetId());
        this.worker.start();
    }

    public synchronized void stop() {
        this.stop = true;
    }

    protected void simulate() {
        while (!this.stop) {
            long sleepTime = (long)(this.random.nextDouble() * 2000.0) + 10000L;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.nodes == null) {
                NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
                try {
                    this.nodes = nodeCache.getNodes(false);
                }
                catch (SubnetDataNotFoundException e) {
                    // empty catch block
                }
            }
            if (this.nodes == null) continue;
            NoticeBean[] notices = new NoticeBean[10];
            for (int i = 0; i < notices.length; ++i) {
                notices[i] = this.createNotice();
            }
            String subnetName = this.cacheMgr.getSAHelper().getSubnetDescription().getName();
            this.cacheMgr.getDatabaseManager().saveNotices(subnetName, notices);
            this.fireNotice(notices);
        }
    }

    protected NoticeBean createNotice() {
        int nodeIndex = this.random.nextInt(this.nodes.size());
        NodeRecordBean node = this.nodes.get(nodeIndex);
        NoticeBean notice = null;
        notice = node.getNodeInfo().getNodeType() == NodeType.HFI.getId() ? (this.random.nextBoolean() ? this.hfiActiveCreator.createNotice(node) : this.hfiInactiveCreator.createNotice(node)) : this.linkChangeCreator.createNotice(node);
        return notice;
    }

    protected void fireNotice(NoticeBean[] notices) {
        for (IEventListener<NoticeBean> listener : this.listeners) {
            listener.onNewEvent((NoticeBean[])notices);
        }
    }

    public void addEventListener(IEventListener<NoticeBean> listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(IEventListener<NoticeBean> listener) {
        this.listeners.remove(listener);
    }

    private static interface INoticeCreator {
        public NoticeBean createNotice(NodeRecordBean var1);
    }
}

