/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.performance.GroupListBean;
import com.intel.stl.api.performance.impl.GroupCache;
import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupCacheImpl
extends MemoryCache<Map<String, String>>
implements GroupCache {
    private final DatabaseManager dbMgr;
    private final PAHelper helper;
    private final String subnetName;

    public GroupCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.dbMgr = cacheMgr.getDatabaseManager();
        this.helper = cacheMgr.getPAHelper();
        this.subnetName = this.helper.getSubnetDescription().getName();
    }

    @Override
    public boolean isGroupDefined(String groupName) {
        Map groupList = (Map)this.getCachedObject();
        boolean defined = groupList.containsKey(groupName);
        if (!defined) {
            this.setCacheReady(false);
            this.updateCache();
            defined = groupList.containsKey(groupName);
        }
        return defined;
    }

    @Override
    protected Map<String, String> retrieveObjectForCache() throws Exception {
        List<GroupListBean> groupList = this.helper.getGroupList();
        if (groupList == null || groupList.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> groups = new HashMap<String, String>(groupList.size());
        for (GroupListBean group : groupList) {
            groups.put(group.getGroupName(), null);
        }
        try {
            this.dbMgr.saveGroupList(this.subnetName, groupList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groups;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        return true;
    }
}

