/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance.impl;

import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GroupInfoSaveTask
extends AsyncTask<Void> {
    private final DatabaseManager dbMgr;
    private final PAHelper helper;
    private final ConcurrentLinkedQueue<GroupInfoBean> groupInfoBuffer;

    public GroupInfoSaveTask(PAHelper helper, DatabaseManager dbMgr, ConcurrentLinkedQueue<GroupInfoBean> groupInfoBuffer) {
        this.checkArguments(helper, dbMgr, groupInfoBuffer);
        this.helper = helper;
        this.dbMgr = dbMgr;
        this.groupInfoBuffer = groupInfoBuffer;
    }

    @Override
    public Void process() throws Exception {
        String subnetName = this.helper.getSubnetDescription().getName();
        ArrayList<GroupInfoBean> saveList = new ArrayList<GroupInfoBean>(this.groupInfoBuffer.size());
        while (!this.groupInfoBuffer.isEmpty()) {
            GroupInfoBean groupInfo = this.groupInfoBuffer.poll();
            if (groupInfo == null) continue;
            saveList.add(groupInfo);
        }
        if (saveList.size() > 0) {
            this.dbMgr.saveGroupInfos(subnetName, saveList);
        }
        return null;
    }
}

