/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.impl.SubnetContextImpl;
import com.intel.stl.api.performance.FocusPortsRspBean;
import com.intel.stl.api.performance.GroupConfigRspBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.GroupListBean;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.performance.PerformanceDataNotFoundException;
import com.intel.stl.api.performance.PerformanceException;
import com.intel.stl.api.performance.PerformanceRequestCancelledException;
import com.intel.stl.api.performance.PortConfigBean;
import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.api.performance.VFConfigRspBean;
import com.intel.stl.api.performance.VFFocusPortsRspBean;
import com.intel.stl.api.performance.VFInfoBean;
import com.intel.stl.api.performance.VFListBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.api.performance.impl.GroupCache;
import com.intel.stl.api.performance.impl.GroupConfCache;
import com.intel.stl.api.performance.impl.GroupInfoPurgeTask;
import com.intel.stl.api.performance.impl.GroupInfoSaveTask;
import com.intel.stl.api.performance.impl.ImageInfoSaveTask;
import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.api.performance.impl.PMConfigCache;
import com.intel.stl.api.performance.impl.Randomizer;
import com.intel.stl.api.subnet.Selection;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.CircularBuffer;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.ResultHandler;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.fecdriver.session.RequestCancelledByUserException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceApi
implements IPerformanceApi {
    private static Logger log = LoggerFactory.getLogger(PerformanceApi.class);
    protected static int IMAGE_INFO_BUFFER_SIZE = 10;
    protected static int IMAGE_INFO_SAVE_BATCH = 20;
    protected static int GROUP_INFO_SAVE_BATCH = 10;
    private static long IMAGE_INFO_SAVE_THROTTLE = 20000L;
    private static long GROUP_INFO_SAVE_THROTTLE = 20000L;
    private static int GROUP_INFO_PURGE_FREQUENCY = 360;
    private static int GROUP_INFO_RETENTION = 15;
    private static long GROUP_INFO_PURGE_FIRST = 300000L;
    private static long MILISECONDS_PER_HOUR = 3600000L;
    private static long MILISECONDS_PER_DAY = 86400000L;
    private final int imageinfoBatchSize;
    private final int groupinfoBatchSize;
    private final long groupinfoPurgeFrequency;
    private final long groupinfoRetention;
    private final SubnetContextImpl subnetContext;
    private final CacheManager cacheMgr;
    private final DatabaseManager dbServer;
    private final PAHelper helper;
    private final CircularBuffer<ImageIdBean, ImageInfoBean> imageInfoCache;
    private final ConcurrentLinkedQueue<GroupInfoBean> groupInfoSaveBuffer;
    private List<GroupListBean> groupList;
    private final AtomicLong lastImageInfoSaveTask = new AtomicLong(0L);
    private final AtomicLong lastGroupInfoSaveTask = new AtomicLong(0L);
    private final AtomicLong nextGroupInfoPurgeTask = new AtomicLong(0L);
    private List<VFListBean> vfList;
    private boolean addRandom;
    private final Randomizer randomizer = new Randomizer();
    private int numNodes = -1;

    public PerformanceApi(SubnetContextImpl subnetContext) {
        this.subnetContext = subnetContext;
        this.cacheMgr = subnetContext.getCacheManager();
        this.helper = subnetContext.getSession().getPAHelper();
        this.dbServer = this.cacheMgr.getDatabaseManager();
        int imageinfoBufferSize = this.getAppSetting("perf.imageinfo.cachesize", IMAGE_INFO_BUFFER_SIZE);
        this.imageInfoCache = new CircularBuffer(imageinfoBufferSize);
        this.groupInfoSaveBuffer = new ConcurrentLinkedQueue();
        this.imageinfoBatchSize = this.getAppSetting("perf.imageinfo.savebatch", IMAGE_INFO_SAVE_BATCH);
        this.groupinfoBatchSize = this.getAppSetting("perf.groupinfo.savebatch", GROUP_INFO_SAVE_BATCH);
        this.groupinfoPurgeFrequency = (long)this.getAppSetting("perf.groupinfo.purgefreq", GROUP_INFO_PURGE_FREQUENCY) * MILISECONDS_PER_HOUR;
        this.groupinfoRetention = (long)this.getAppSetting("perf.groupinfo.retention", GROUP_INFO_RETENTION) * MILISECONDS_PER_DAY;
        this.resetNextGroupInfoPurgeTime();
    }

    @Override
    public void setSeed(long seed) {
        this.randomizer.setSeed(seed);
    }

    @Override
    public void setRandom(boolean b) {
        this.addRandom = b;
    }

    @Override
    public SubnetDescription getConnectionDescription() {
        return this.helper.getSubnetDescription();
    }

    @Override
    public ImageInfoBean getImageInfo(long imageNumber, int imageOffset) {
        try {
            ImageInfoBean res = this.helper.getImageInfo(imageNumber, imageOffset);
            if (this.addRandom && res != null) {
                this.randomizer.randomImageInfo(res, this.getNumNodes());
            }
            return res;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    protected int getNumNodes() throws Exception {
        if (this.numNodes == -1) {
            List<GroupConfigRspBean> all = this.helper.getGroupConfig("All");
            HashSet<Integer> nodes = new HashSet<Integer>();
            for (GroupConfigRspBean pc : all) {
                nodes.add(pc.getPort().getNodeLid());
            }
            this.numNodes = nodes.size();
        }
        return this.numNodes;
    }

    @Override
    public ImageInfoBean getLatestImageInfo() {
        ImageInfoBean imageInfo = null;
        try {
            imageInfo = this.helper.getImageInfo(0L, 0);
            if (imageInfo != null) {
                this.imageInfoCache.put(imageInfo.getImageId(), imageInfo);
                if (this.addRandom) {
                    this.randomizer.randomImageInfo(imageInfo, this.getNumNodes());
                }
            }
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
        return imageInfo;
    }

    @Override
    public synchronized List<GroupListBean> getGroupList() {
        if (this.groupList == null) {
            try {
                this.groupList = this.helper.getGroupList();
            }
            catch (Exception e) {
                throw this.getPerformanceException(e);
            }
        }
        return this.groupList;
    }

    @Override
    public GroupInfoBean getGroupInfo(String name) {
        try {
            GroupInfoBean groupInfo = this.helper.getGroupInfo(name);
            if (groupInfo != null) {
                this.setTimeInfo(groupInfo.getImageId(), groupInfo);
                if (this.addRandom) {
                    this.randomizer.randomGroupInfo(groupInfo);
                }
            }
            return groupInfo;
        }
        catch (PerformanceRequestCancelledException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public GroupInfoBean getGroupInfoHistory(String name, long imageID, int imageOffset) {
        try {
            GroupInfoBean groupInfo = this.helper.getGroupInfoHistory(name, imageID, imageOffset);
            if (groupInfo != null) {
                if (!this.setTimeInfo(groupInfo.getImageId(), groupInfo)) {
                    groupInfo = null;
                } else if (this.addRandom) {
                    this.randomizer.randomGroupInfo(groupInfo);
                }
            }
            return groupInfo;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public void saveGroupConfig(String groupName, List<PortConfigBean> ports) {
        try {
            this.dbServer.saveGroupConfig(this.getConnectionDescription().getName(), groupName, ports);
        }
        catch (DatabaseException e) {
            PerformanceException pe = this.getPerformanceException(STLMessages.STL30048_ERROR_SAVING_GROUP_CONFIG, e);
            throw pe;
        }
    }

    @Override
    public List<GroupConfigRspBean> getGroupConfig(String subnetName, String groupName) throws PerformanceDataNotFoundException {
        List<GroupConfigRspBean> groupConfigBean = null;
        try {
            this.dbServer.getGroupConfig(subnetName, groupName);
        }
        catch (DatabaseException e) {
            PerformanceException pe = this.getPerformanceException(STLMessages.STL30049_ERROR_GETTING_GROUP_CONFIG, e);
            throw pe;
        }
        return groupConfigBean;
    }

    @Override
    public List<PortConfigBean> getPortConfig(String subnetName) throws PerformanceDataNotFoundException {
        List<PortConfigBean> portConfigBeans = null;
        try {
            portConfigBeans = this.dbServer.getPortConfig(subnetName);
        }
        catch (DatabaseException e) {
            PerformanceException pe = this.getPerformanceException(STLMessages.STL30050_ERROR_GETTING_PORT_CONFIG, e);
            throw pe;
        }
        return portConfigBeans;
    }

    @Override
    public List<GroupInfoBean> getGroupInfo(String subnetName, String groupName, long startTime, long stopTime) throws PerformanceDataNotFoundException {
        try {
            return this.dbServer.getGroupInfo(subnetName, groupName, startTime, stopTime);
        }
        catch (DatabaseException e) {
            PerformanceException pe = this.getPerformanceException(STLMessages.STL30052_ERROR_GETTING_GROUP_INFO, e);
            throw pe;
        }
    }

    @Override
    public List<GroupConfigRspBean> getGroupConfig(String name) {
        GroupConfCache gcc = this.cacheMgr.acquireGroupConfCache();
        try {
            List<GroupConfigRspBean> res = gcc.getGroupConfig(name);
            if (res != null && !res.isEmpty()) {
                ImageIdBean imageId = res.get(0).getImageId();
                this.setTimeInfo(imageId, res);
            }
            return res;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public List<String> getDeviceGroup(int lid) {
        ArrayList<String> res = new ArrayList<String>();
        List<GroupListBean> groupList = this.getGroupList();
        if (groupList == null || groupList.isEmpty()) {
            return res;
        }
        block0: for (GroupListBean group : groupList) {
            List<GroupConfigRspBean> conf = this.getGroupConfig(group.getGroupName());
            if (conf == null) continue;
            for (GroupConfigRspBean port : conf) {
                if (port.getPort().getNodeLid() != lid) continue;
                res.add(group.getGroupName());
                continue block0;
            }
        }
        return res;
    }

    @Override
    public synchronized PortCountersBean getPortCounters(int lid, short portNum) {
        try {
            PortCountersBean bean = this.helper.getPortCounter(lid, portNum);
            if (bean != null) {
                this.setTimeInfo(bean.getImageId(), bean);
                if (this.addRandom) {
                    this.randomizer.randomPortCounters(bean);
                }
            }
            return bean;
        }
        catch (PerformanceRequestCancelledException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public PortCountersBean getPortCountersHistory(int lid, short portNum, long imageID, int imageOffset) {
        try {
            PortCountersBean bean = this.helper.getPortCounterHistory(lid, portNum, imageID, imageOffset);
            if (bean != null && !this.setTimeInfo(bean.getImageId(), bean)) {
                bean = null;
            }
            return bean;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public List<FocusPortsRspBean> getFocusPorts(String groupName, Selection selection, int n) {
        try {
            List<FocusPortsRspBean> res = this.helper.getFocusPort(groupName, selection, n);
            if (res != null && !res.isEmpty()) {
                ImageIdBean imageId = res.get(0).getImageId();
                this.setTimeInfo(imageId, res);
                if (this.addRandom) {
                    this.randomizer.randomFocusPorts(res);
                }
            }
            return res;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public List<FocusPortsRspBean> getTopBandwidth(String groupName, int n) {
        return this.getFocusPorts(groupName, Selection.UTILIZATION_HIGH, n);
    }

    @Override
    public List<FocusPortsRspBean> getTopCongestion(String groupName, int n) {
        return this.getFocusPorts(groupName, Selection.CONGESTION_ERRORS_HIGH, n);
    }

    @Override
    public synchronized List<VFListBean> getVFList() {
        if (this.vfList == null) {
            try {
                this.vfList = this.helper.getVFList();
            }
            catch (Exception e) {
                throw this.getPerformanceException(e);
            }
        }
        return this.vfList;
    }

    @Override
    public VFInfoBean getVFInfo(String name) {
        try {
            VFInfoBean bean = this.helper.getVFInfo(name);
            if (bean != null) {
                this.setTimeInfo(bean.getImageId(), bean);
                if (this.addRandom) {
                    this.randomizer.randomVFInfo(bean);
                }
            }
            return bean;
        }
        catch (PerformanceRequestCancelledException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public VFInfoBean getVFInfoHistory(String name, long imageID, int imageOffset) {
        try {
            VFInfoBean bean = this.helper.getVFInfoHistory(name, imageID, imageOffset);
            if (bean != null && !this.setTimeInfo(bean.getImageId(), bean)) {
                bean = null;
            }
            if (this.addRandom && bean != null) {
                this.randomizer.randomVFInfo(bean);
            }
            return bean;
        }
        catch (PerformanceRequestCancelledException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public List<VFConfigRspBean> getVFConfig(String name) {
        GroupConfCache gcc = this.cacheMgr.acquireGroupConfCache();
        try {
            List<VFConfigRspBean> res = gcc.getVFConfig(name);
            if (res != null && !res.isEmpty()) {
                ImageIdBean imageId = res.get(0).getImageId();
                this.setTimeInfo(imageId, res);
            }
            return res;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public List<String> getVFNames(int lid) {
        ArrayList<String> res = new ArrayList<String>();
        List<VFListBean> vfList = this.getVFList();
        if (vfList == null || vfList.isEmpty()) {
            return res;
        }
        block0: for (VFListBean vf : vfList) {
            String name = vf.getVfName();
            List<VFConfigRspBean> conf = this.getVFConfig(name);
            if (conf == null) continue;
            for (VFConfigRspBean port : conf) {
                if (port.getPort().getNodeLid() != lid) continue;
                res.add(name);
                continue block0;
            }
        }
        return res;
    }

    @Override
    public List<VFFocusPortsRspBean> getVFFocusPorts(String vfName, Selection selection, int n) {
        try {
            List<VFFocusPortsRspBean> res = this.helper.getVFFocusPort(vfName, selection, n);
            if (res != null && !res.isEmpty()) {
                ImageIdBean imageId = res.get(0).getImageId();
                this.setTimeInfo(imageId, res);
                if (this.addRandom) {
                    this.randomizer.randomVFFocusPorts(res);
                }
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public VFPortCountersBean getVFPortCounters(String vfName, int lid, short portNum) {
        try {
            VFPortCountersBean bean = this.helper.getVFPortCounter(vfName, lid, portNum);
            if (bean != null) {
                this.setTimeInfo(bean.getImageId(), bean);
            }
            return bean;
        }
        catch (PerformanceRequestCancelledException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public VFPortCountersBean getVFPortCountersHistory(String vfName, int lid, short portNum, long imageID, int imageOffset) {
        try {
            VFPortCountersBean bean = this.helper.getVFPortCounterHistory(vfName, lid, portNum, imageID, imageOffset);
            if (bean != null && !this.setTimeInfo(bean.getImageId(), bean)) {
                bean = null;
            }
            return bean;
        }
        catch (PerformanceRequestCancelledException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    @Override
    public PMConfigBean getPMConfig() {
        PMConfigCache cache = this.cacheMgr.acquirePMConfigCache();
        try {
            return cache.getPMConfig();
        }
        catch (Exception e) {
            throw this.getPerformanceException(e);
        }
    }

    private void saveGroupInfo(GroupInfoBean groupInfo) throws Exception {
        if (this.setTimeInfo(groupInfo.getImageId(), groupInfo)) {
            long nextTry;
            boolean swapped;
            long purgeTime;
            long now;
            GroupCache groupCache = this.cacheMgr.acquireGroupCache();
            if (groupCache.isGroupDefined(groupInfo.getGroupName()) && !this.groupInfoSaveBuffer.contains(groupInfo)) {
                this.groupInfoSaveBuffer.offer(groupInfo);
            }
            if (this.groupInfoSaveBuffer.size() > this.groupinfoBatchSize) {
                GroupInfoSaveTask saveTask = new GroupInfoSaveTask(this.helper, this.dbServer, this.groupInfoSaveBuffer);
                this.submitWithThrottle(saveTask, this.lastGroupInfoSaveTask, GROUP_INFO_SAVE_THROTTLE);
            }
            if ((now = System.currentTimeMillis()) > (purgeTime = this.nextGroupInfoPurgeTask.get()) && (swapped = this.nextGroupInfoPurgeTask.compareAndSet(purgeTime, nextTry = now + GROUP_INFO_PURGE_FIRST))) {
                long ago = now - this.groupinfoRetention;
                GroupInfoPurgeTask task = new GroupInfoPurgeTask(this.helper, this.dbServer, ago);
                log.info("Starting GroupInfo purge task. Purging records older than {}", (Object)this.getFormattedTimestamp(ago));
                this.subnetContext.getProcessingService().submit(task, new ResultHandler<Integer>(){

                    @Override
                    public void onTaskCompleted(Future<Integer> result) {
                        try {
                            int deleted = result.get();
                            PerformanceApi.this.resetNextGroupInfoPurgeTime();
                            log.info("{} GroupInfo records purged.", (Object)deleted);
                        }
                        catch (InterruptedException e) {
                            log.error("GroupInfo purge task was interrupted");
                        }
                        catch (ExecutionException e) {
                            log.error("GroupInfo purge task had an error", e.getCause());
                        }
                    }
                });
            }
        }
    }

    private void saveImageInfoCacheIfNeeded() {
        if (this.imageInfoCache.getSaveQueueSize() > this.imageinfoBatchSize) {
            ImageInfoSaveTask saveTask = new ImageInfoSaveTask(this.helper, this.dbServer, this.imageInfoCache);
            this.submitWithThrottle(saveTask, this.lastImageInfoSaveTask, IMAGE_INFO_SAVE_THROTTLE);
        }
    }

    private ImageInfoBean getImageInfo(ImageIdBean imageId) throws Exception {
        ImageInfoBean imageInfo = this.imageInfoCache.get(imageId);
        if (imageInfo == null && (imageInfo = this.getLatestImageInfo()) != null && !imageInfo.getImageId().equals(imageId)) {
            imageInfo = null;
        }
        if (imageInfo == null) {
            imageInfo = this.helper.getImageInfo(imageId);
        }
        return imageInfo;
    }

    protected boolean setTimeInfo(ImageIdBean imageId, ITimestamped data) throws Exception {
        ImageInfoBean imageInfo;
        ImageInfoBean imageInfoBean = imageInfo = imageId == null ? null : this.getImageInfo(imageId);
        if (imageInfo != null) {
            data.setTimestamp(imageInfo.getSweepStart());
            data.setImageInterval(imageInfo.getImageInterval());
            return true;
        }
        return false;
    }

    protected boolean setTimeInfo(ImageIdBean imageId, Collection<? extends ITimestamped> data) throws Exception {
        ImageInfoBean imageInfo;
        ImageInfoBean imageInfoBean = imageInfo = imageId == null ? null : this.getImageInfo(imageId);
        if (imageInfo != null) {
            for (ITimestamped iTimestamped : data) {
                iTimestamped.setTimestamp(imageInfo.getSweepStart());
                iTimestamped.setImageInterval(imageInfo.getImageInterval());
            }
            return true;
        }
        return false;
    }

    private PerformanceException getPerformanceException(STLMessages msg, Exception e) {
        PerformanceException pe = new PerformanceException((IMessage)msg, (Throwable)e, StringUtils.getErrorMessage(e));
        log.error(StringUtils.getErrorMessage(pe), (Throwable)e);
        return pe;
    }

    private PerformanceException getPerformanceException(Exception e) {
        PerformanceException pe;
        if (e instanceof RequestCancelledByUserException) {
            pe = new PerformanceRequestCancelledException();
        } else {
            pe = new PerformanceException((IMessage)STLMessages.STL60003_PERFORMANCE_DATA_FAILURE, (Throwable)e, StringUtils.getErrorMessage(e));
            log.error(StringUtils.getErrorMessage(pe), (Throwable)e);
        }
        return pe;
    }

    private void submitWithThrottle(AsyncTask<?> task, AtomicLong lastSubmissionTS, long throttle) {
        boolean swapped;
        long lastSubmission;
        long now = System.currentTimeMillis();
        if (now > (lastSubmission = lastSubmissionTS.get()) + throttle && (swapped = lastSubmissionTS.compareAndSet(lastSubmission, now))) {
            this.subnetContext.getProcessingService().submit(task, null);
        }
    }

    private void resetNextGroupInfoPurgeTime() {
        Map<String, Properties> appProps = this.dbServer.getAppInfo().getPropertiesMap();
        Properties dbProps = appProps.get("Database");
        if (dbProps == null) {
            this.nextGroupInfoPurgeTask.set(System.currentTimeMillis() + GROUP_INFO_PURGE_FIRST);
        } else {
            SubnetDescription subnet = this.subnetContext.getSubnetDescription();
            String lastPurge = dbProps.getProperty("lastgroupinfopurge-" + subnet.getSubnetId());
            if (lastPurge == null) {
                this.nextGroupInfoPurgeTask.set(System.currentTimeMillis() + GROUP_INFO_PURGE_FIRST);
            } else {
                try {
                    long lastPurgeTS = Long.parseLong(lastPurge);
                    this.nextGroupInfoPurgeTask.set(lastPurgeTS + this.groupinfoPurgeFrequency);
                }
                catch (NumberFormatException e) {
                    this.nextGroupInfoPurgeTask.set(System.currentTimeMillis() + GROUP_INFO_PURGE_FIRST);
                }
            }
        }
        log.info("Next GroupInfo purge task to start on {}", (Object)this.getFormattedTimestamp(this.nextGroupInfoPurgeTask.get()));
    }

    private String getFormattedTimestamp(long timestamp) {
        Date date = new Date(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        return sdf.format(date);
    }

    private int getAppSetting(String settingName, int defaultValue) {
        try {
            int value = Integer.parseInt(this.subnetContext.getAppSetting(settingName, new Integer(defaultValue).toString()));
            return value;
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value for setting '{}'; using default value of {}", new Object[]{settingName, defaultValue, e});
            return defaultValue;
        }
    }

    protected CircularBuffer<ImageIdBean, ImageInfoBean> getImageInfoCache() {
        return this.imageInfoCache;
    }

    protected ConcurrentLinkedQueue<GroupInfoBean> getGroupInfoSaveBuffer() {
        return this.groupInfoSaveBuffer;
    }

    @Override
    public synchronized void reset() {
        this.vfList = null;
        this.groupList = null;
    }

    @Override
    public void cleanup() {
        this.helper.close();
        this.groupInfoSaveBuffer.clear();
    }
}

