/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance.impl;

import com.intel.stl.api.IRandomable;
import com.intel.stl.api.performance.CategoryBucketBean;
import com.intel.stl.api.performance.CategoryStatBean;
import com.intel.stl.api.performance.FocusPortsRspBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.api.performance.VFFocusPortsRspBean;
import com.intel.stl.api.performance.VFInfoBean;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Randomizer
implements IRandomable {
    private final Random random;
    private boolean isActive = true;
    private long allBandwidth;
    private long allPacketRate;
    private int allPmaFailedPorts;
    private int allTopoFailedPorts;
    private long allCongestion;
    private long allSignalIntegrity;
    private long allSmaCongestion;
    private long allSecurity;
    private long allRouting;
    private long bandwidth;
    private long packetRate;
    private int pmaFailedPorts;
    private int topoFailedPorts;
    private long congestion;
    private long signalIntegrity;
    private long smaCongestion;
    private long security;
    private long routing;
    private final List<ImageInfoBean> recentImageInfos = new ArrayList<ImageInfoBean>(4);
    private final List<GroupInfoBean> recentGroupInfos = new ArrayList<GroupInfoBean>(4);
    private final List<VFInfoBean> recentVFInfos = new ArrayList<VFInfoBean>(4);
    Map<Point, Long[]> counters = new HashMap<Point, Long[]>();

    public Randomizer() {
        this.random = new Random();
    }

    @Override
    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public void setRandom(boolean b) {
        this.isActive = b;
    }

    public void randomImageInfo(ImageInfoBean imageInfo, int nodes) {
        if (!this.isActive) {
            return;
        }
        int index = this.recentImageInfos.indexOf(imageInfo);
        if (index >= 0) {
            ImageInfoBean last = this.recentImageInfos.get(index);
            imageInfo.setNumNoRespNodes(last.getNumNoRespNodes());
            imageInfo.setNumSkippedNodes(last.getNumSkippedNodes());
            imageInfo.setNumNoRespPorts(last.getNumNoRespPorts());
            imageInfo.setNumSkippedPorts(last.getNumSkippedPorts());
            return;
        }
        if (this.recentImageInfos.size() >= 4) {
            this.recentImageInfos.remove(0);
        }
        this.recentImageInfos.add(imageInfo);
        imageInfo.setNumNoRespNodes(this.random.nextInt(nodes) / 10);
        imageInfo.setNumSkippedNodes(this.random.nextInt(nodes -= imageInfo.getNumNoRespNodes()) / 10);
        long ports = (long)imageInfo.getNumHFIPorts() + imageInfo.getNumSwitchPorts();
        imageInfo.setNumNoRespPorts((long)(this.random.nextDouble() * (double)ports / 10.0));
        imageInfo.setNumSkippedPorts((long)(this.random.nextDouble() * (double)(ports -= imageInfo.getNumNoRespPorts()) / 10.0));
    }

    public void randomGroupInfo(GroupInfoBean info) {
        int i;
        if (!this.isActive) {
            return;
        }
        int index = this.recentGroupInfos.indexOf(info);
        if (index >= 0) {
            GroupInfoBean last = this.recentGroupInfos.get(index);
            info.setInternalUtilStats(last.getInternalUtilStats());
            info.setInternalCategoryStats(last.getInternalCategoryStats());
            return;
        }
        if (this.recentGroupInfos.size() >= 4) {
            this.recentGroupInfos.remove(0);
        }
        this.recentGroupInfos.add(info);
        boolean isAll = info.getGroupName().equals("All");
        UtilStatsBean internalUtil = info.getInternalUtilStats();
        if (isAll) {
            this.allBandwidth = this.bandwidth = Math.max(this.bandwidth, internalUtil.getTotalMBps() + (long)this.random.nextInt(1000));
            this.allPacketRate = this.packetRate = Math.max(this.packetRate, internalUtil.getTotalKPps() + (long)this.random.nextInt(1000));
            if (Math.random() > 0.8) {
                this.allPmaFailedPorts = this.pmaFailedPorts = Math.max(this.pmaFailedPorts, internalUtil.getPmaNoRespPorts() + this.random.nextInt(10));
                this.allTopoFailedPorts = this.topoFailedPorts = Math.max(this.topoFailedPorts, internalUtil.getTopoIncompPorts() + this.random.nextInt(10));
            } else {
                this.pmaFailedPorts = 0;
                this.allPmaFailedPorts = 0;
                this.topoFailedPorts = 0;
                this.allTopoFailedPorts = 0;
            }
        } else {
            this.bandwidth = (long)((double)this.allBandwidth * this.random.nextDouble());
            this.packetRate = (long)((double)this.allPacketRate * this.random.nextDouble());
            this.pmaFailedPorts = (int)((double)this.allPmaFailedPorts * this.random.nextDouble());
            this.topoFailedPorts = (int)((double)this.allTopoFailedPorts * this.random.nextDouble());
        }
        internalUtil.setTotalMBps(this.bandwidth);
        internalUtil.setTotalKPps(this.packetRate);
        internalUtil.setPmaNoRespPorts(this.pmaFailedPorts);
        internalUtil.setTopoIncompPorts(this.topoFailedPorts);
        this.randomHistogram(internalUtil.getBwBucketsAsArray());
        CategoryStatBean errStat = info.getInternalCategoryStats();
        if (isAll) {
            this.allCongestion = this.congestion = Math.max(this.congestion, errStat.getCategoryMaximums().getCongestion() + (long)this.random.nextInt(99));
            this.allSignalIntegrity = this.signalIntegrity = Math.max(this.signalIntegrity, errStat.getCategoryMaximums().getIntegrityErrors() + (long)this.random.nextInt(99));
            this.allSmaCongestion = this.smaCongestion = Math.max(this.smaCongestion, errStat.getCategoryMaximums().getSmaCongestion() + (long)this.random.nextInt(99));
            this.allSecurity = this.security = Math.max(this.security, errStat.getCategoryMaximums().getSecurityErrors() + (long)this.random.nextInt(99));
            this.allRouting = this.routing = Math.max(this.routing, errStat.getCategoryMaximums().getRoutingErrors() + (long)this.random.nextInt(99));
        } else {
            this.congestion = (int)((double)this.allCongestion * this.random.nextDouble());
            this.signalIntegrity = (int)((double)this.allSignalIntegrity * this.random.nextDouble());
            this.smaCongestion = (int)((double)this.allSmaCongestion * this.random.nextDouble());
            this.security = (int)((double)this.allSecurity * this.random.nextDouble());
            this.routing = (int)((double)this.allRouting * this.random.nextDouble());
        }
        errStat.getCategoryMaximums().setCongestion(this.congestion);
        errStat.getCategoryMaximums().setIntegrityErrors(this.signalIntegrity);
        errStat.getCategoryMaximums().setSmaCongestion(this.smaCongestion);
        errStat.getCategoryMaximums().setSecurityErrors(this.security);
        errStat.getCategoryMaximums().setRoutingErrors(this.routing);
        CategoryBucketBean[] ports = errStat.getPorts();
        int[] congestions = new int[ports.length];
        int[] integrities = new int[ports.length];
        int[] smaCongestions = new int[ports.length];
        int[] securities = new int[ports.length];
        int[] routings = new int[ports.length];
        for (i = 0; i < ports.length; ++i) {
            congestions[i] = ports[i].getCongestion();
            integrities[i] = ports[i].getIntegrityErrors();
            smaCongestions[i] = ports[i].getSmaCongestion();
            securities[i] = ports[i].getSecurityErrors();
            routings[i] = ports[i].getRoutingErrors();
        }
        this.randomHistogram(congestions);
        this.randomHistogram(integrities);
        this.randomHistogram(smaCongestions);
        this.randomHistogram(securities);
        this.randomHistogram(routings);
        for (i = 0; i < ports.length; ++i) {
            ports[i].setCongestion(congestions[i]);
            ports[i].setIntegrityErrors(integrities[i]);
            ports[i].setSmaCongestion(smaCongestions[i]);
            ports[i].setSecurityErrors(securities[i]);
            ports[i].setRoutingErrors(routings[i]);
        }
    }

    public void randomVFInfo(VFInfoBean info) {
        int i;
        if (!this.isActive) {
            return;
        }
        int index = this.recentVFInfos.indexOf(info);
        if (index >= 0) {
            VFInfoBean last = this.recentVFInfos.get(index);
            info.setInternalUtilStats(last.getInternalUtilStats());
            info.setInternalCategoryStats(last.getInternalCategoryStats());
            return;
        }
        if (this.recentVFInfos.size() >= 4) {
            this.recentVFInfos.remove(0);
        }
        this.recentVFInfos.add(info);
        UtilStatsBean internalUtil = info.getInternalUtilStats();
        long bandwidth = internalUtil.getTotalMBps() + (long)this.random.nextInt(1000);
        long packetRate = internalUtil.getTotalKPps() + (long)this.random.nextInt(1000);
        internalUtil.setTotalMBps(bandwidth);
        internalUtil.setTotalKPps(packetRate);
        if (Math.random() > 0.8) {
            internalUtil.setPmaNoRespPorts(internalUtil.getPmaNoRespPorts() + this.random.nextInt(10));
            internalUtil.setTopoIncompPorts(internalUtil.getTopoIncompPorts() + this.random.nextInt(10));
        }
        this.randomHistogram(internalUtil.getBwBucketsAsArray());
        CategoryStatBean errStat = info.getInternalCategoryStats();
        long value = errStat.getCategoryMaximums().getCongestion() + (long)this.random.nextInt(99);
        errStat.getCategoryMaximums().setCongestion(value);
        value = errStat.getCategoryMaximums().getIntegrityErrors() + (long)this.random.nextInt(99);
        errStat.getCategoryMaximums().setIntegrityErrors(value);
        value = errStat.getCategoryMaximums().getSmaCongestion() + (long)this.random.nextInt(99);
        errStat.getCategoryMaximums().setSmaCongestion(value);
        value = errStat.getCategoryMaximums().getSecurityErrors() + (long)this.random.nextInt(99);
        errStat.getCategoryMaximums().setSecurityErrors(value);
        value = errStat.getCategoryMaximums().getRoutingErrors() + (long)this.random.nextInt(99);
        errStat.getCategoryMaximums().setRoutingErrors(value);
        CategoryBucketBean[] ports = errStat.getPorts();
        int[] congestions = new int[ports.length];
        int[] integrities = new int[ports.length];
        int[] smaCongestions = new int[ports.length];
        int[] securities = new int[ports.length];
        int[] routings = new int[ports.length];
        for (i = 0; i < ports.length; ++i) {
            congestions[i] = ports[i].getCongestion();
            integrities[i] = ports[i].getIntegrityErrors();
            smaCongestions[i] = ports[i].getSmaCongestion();
            securities[i] = ports[i].getSecurityErrors();
            routings[i] = ports[i].getRoutingErrors();
        }
        this.randomHistogram(congestions);
        this.randomHistogram(integrities);
        this.randomHistogram(smaCongestions);
        this.randomHistogram(securities);
        this.randomHistogram(routings);
        for (i = 0; i < ports.length; ++i) {
            ports[i].setCongestion(congestions[i]);
            ports[i].setIntegrityErrors(integrities[i]);
            ports[i].setSmaCongestion(smaCongestions[i]);
            ports[i].setSecurityErrors(securities[i]);
            ports[i].setRoutingErrors(routings[i]);
        }
    }

    protected void randomHistogram(int[] counts) {
        int delta = 0;
        int i = 0;
        while (i < counts.length - 1) {
            double tmp = (int)((double)counts[i] * this.random.nextDouble() - (double)delta * this.random.nextDouble());
            int n = i++;
            counts[n] = counts[n] - (int)tmp;
            delta += (int)tmp;
        }
        int n = counts.length - 1;
        counts[n] = counts[n] + delta;
    }

    protected void randomHistogram(Integer[] counts) {
        int delta = 0;
        int i = 0;
        while (i < counts.length - 1) {
            double tmp = (int)((double)counts[i].intValue() * this.random.nextDouble() - (double)delta * this.random.nextDouble());
            Integer[] integerArray = counts;
            int n = i++;
            Integer.valueOf(integerArray[n] - (int)tmp);
            delta += (int)tmp;
        }
        Integer[] integerArray = counts;
        int n = counts.length - 1;
        Integer.valueOf(integerArray[n] + delta);
    }

    public void randomFocusPorts(List<FocusPortsRspBean> focusPorts) {
        int i;
        if (!this.isActive) {
            return;
        }
        int[] values = new int[focusPorts.size()];
        for (i = 0; i < values.length; ++i) {
            values[i] = (int)(Math.random() * 100.0);
        }
        Arrays.sort(values);
        for (i = 0; i < values.length; ++i) {
            focusPorts.get(i).setValue(values[values.length - 1 - i]);
            int flag = this.random.nextInt(10);
            if (flag > 3) {
                flag = 0;
            }
            focusPorts.get(i).setLocalStatus((byte)flag);
        }
    }

    public void randomVFFocusPorts(List<VFFocusPortsRspBean> focusPort) {
        int i;
        if (!this.isActive) {
            return;
        }
        int[] values = new int[focusPort.size()];
        for (i = 0; i < values.length; ++i) {
            values[i] = (int)(Math.random() * 100.0);
        }
        Arrays.sort(values);
        for (i = 0; i < values.length; ++i) {
            focusPort.get(i).setValue(values[values.length - 1 - i]);
            int flag = this.random.nextInt(10);
            if (flag > 3) {
                flag = 0;
            }
            focusPort.get(i).setLocalStatus((byte)flag);
        }
    }

    public synchronized void randomPortCounters(PortCountersBean counter) {
        Point id = new Point(counter.getNodeLid(), counter.getPortNumber());
        Long[] last = this.counters.get(id);
        if (last == null) {
            this.counters.put(id, new Long[]{counter.getPortRcvData(), counter.getPortXmitData()});
            return;
        }
        last[0] = this.getRandomTraffic(last[0]);
        counter.setPortRcvData(last[0]);
        last[1] = this.getRandomTraffic(last[1]);
        counter.setPortXmitData(last[1]);
    }

    private long getRandomTraffic(long val) {
        if (val < 0x40000000L) {
            val = 0x40000000L;
        }
        long res = val + (long)Math.ceil(this.random.nextDouble() * 1.7179869184E10);
        return res;
    }
}

